package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Shared properties of both Application and Network Load Balancers
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-19T13:59:20.916Z")
public interface BaseLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The VPC network to place the load balancer in
     */
    software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc();
    /**
     * The VPC network to place the load balancer in
     */
    void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value);
    /**
     * Indicates whether deletion protection is enabled.
     * @default false
     */
    java.lang.Boolean getDeletionProtection();
    /**
     * Indicates whether deletion protection is enabled.
     * @default false
     */
    void setDeletionProtection(final java.lang.Boolean value);
    /**
     * Whether the load balancer has an internet-routable address
     * @default false
     */
    java.lang.Boolean getInternetFacing();
    /**
     * Whether the load balancer has an internet-routable address
     * @default false
     */
    void setInternetFacing(final java.lang.Boolean value);
    /**
     * Name of the load balancer
     * @default Automatically generated name
     */
    java.lang.String getLoadBalancerName();
    /**
     * Name of the load balancer
     * @default Automatically generated name
     */
    void setLoadBalancerName(final java.lang.String value);
    /**
     * Where in the VPC to place the load balancer
     * @default Public subnets if internetFacing, otherwise private subnets
     */
    software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement();
    /**
     * Where in the VPC to place the load balancer
     * @default Public subnets if internetFacing, otherwise private subnets
     */
    void setVpcPlacement(final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value);

    /**
     * @return a {@link Builder} of {@link BaseLoadBalancerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BaseLoadBalancerProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;
        @javax.annotation.Nullable
        private java.lang.Boolean _deletionProtection;
        @javax.annotation.Nullable
        private java.lang.Boolean _internetFacing;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.VpcPlacementStrategy _vpcPlacement;

        /**
         * Sets the value of Vpc
         * @param value The VPC network to place the load balancer in
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeletionProtection
         * @param value Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        public Builder withDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deletionProtection = value;
            return this;
        }
        /**
         * Sets the value of InternetFacing
         * @param value Whether the load balancer has an internet-routable address
         * @return {@code this}
         */
        public Builder withInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._internetFacing = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerName
         * @param value Name of the load balancer
         * @return {@code this}
         */
        public Builder withLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerName = value;
            return this;
        }
        /**
         * Sets the value of VpcPlacement
         * @param value Where in the VPC to place the load balancer
         * @return {@code this}
         */
        public Builder withVpcPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this._vpcPlacement = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BaseLoadBalancerProps build() {
            return new BaseLoadBalancerProps() {
                private software.amazon.awscdk.services.ec2.VpcNetworkRef $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $deletionProtection = _deletionProtection;
                @javax.annotation.Nullable
                private java.lang.Boolean $internetFacing = _internetFacing;
                @javax.annotation.Nullable
                private java.lang.String $loadBalancerName = _loadBalancerName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.VpcPlacementStrategy $vpcPlacement = _vpcPlacement;

                @Override
                public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public java.lang.Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public void setDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$deletionProtection = value;
                }

                @Override
                public java.lang.Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public void setInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$internetFacing = value;
                }

                @Override
                public java.lang.String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public void setLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$loadBalancerName = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement() {
                    return this.$vpcPlacement;
                }

                @Override
                public void setVpcPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
                    this.$vpcPlacement = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The VPC network to place the load balancer in
         */
        @Override
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }

        /**
         * The VPC network to place the load balancer in
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * Indicates whether deletion protection is enabled.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDeletionProtection() {
            return this.jsiiGet("deletionProtection", java.lang.Boolean.class);
        }

        /**
         * Indicates whether deletion protection is enabled.
         * @default false
         */
        @Override
        public void setDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("deletionProtection", value);
        }

        /**
         * Whether the load balancer has an internet-routable address
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getInternetFacing() {
            return this.jsiiGet("internetFacing", java.lang.Boolean.class);
        }

        /**
         * Whether the load balancer has an internet-routable address
         * @default false
         */
        @Override
        public void setInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("internetFacing", value);
        }

        /**
         * Name of the load balancer
         * @default Automatically generated name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerName() {
            return this.jsiiGet("loadBalancerName", java.lang.String.class);
        }

        /**
         * Name of the load balancer
         * @default Automatically generated name
         */
        @Override
        public void setLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("loadBalancerName", value);
        }

        /**
         * Where in the VPC to place the load balancer
         * @default Public subnets if internetFacing, otherwise private subnets
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement() {
            return this.jsiiGet("vpcPlacement", software.amazon.awscdk.services.ec2.VpcPlacementStrategy.class);
        }

        /**
         * Where in the VPC to place the load balancer
         * @default Public subnets if internetFacing, otherwise private subnets
         */
        @Override
        public void setVpcPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this.jsiiSet("vpcPlacement", value);
        }
    }
}
