package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties of both Application and Network Target Groups
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-19T13:59:20.919Z")
public interface BaseTargetGroupProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The virtual private cloud (VPC).
     */
    software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc();
    /**
     * The virtual private cloud (VPC).
     */
    void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value);
    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0–3600 seconds.
     * @default 300
     */
    java.lang.Number getDeregistrationDelaySec();
    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0–3600 seconds.
     * @default 300
     */
    void setDeregistrationDelaySec(final java.lang.Number value);
    /**
     * Health check configuration
     * @default No health check
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck();
    /**
     * Health check configuration
     * @default No health check
     */
    void setHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value);
    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * @default Automatically generated
     */
    java.lang.String getTargetGroupName();
    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * @default Automatically generated
     */
    void setTargetGroupName(final java.lang.String value);

    /**
     * @return a {@link Builder} of {@link BaseTargetGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BaseTargetGroupProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;
        @javax.annotation.Nullable
        private java.lang.Number _deregistrationDelaySec;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.String _targetGroupName;

        /**
         * Sets the value of Vpc
         * @param value The virtual private cloud (VPC).
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeregistrationDelaySec
         * @param value The amount of time for Elastic Load Balancing to wait before deregistering a target.

The range is 0–3600 seconds.
         * @return {@code this}
         */
        public Builder withDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check configuration
         * @return {@code this}
         */
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of TargetGroupName
         * @param value The name of the target group.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens, and
must not begin or end with a hyphen.
         * @return {@code this}
         */
        public Builder withTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._targetGroupName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BaseTargetGroupProps build() {
            return new BaseTargetGroupProps() {
                private software.amazon.awscdk.services.ec2.VpcNetworkRef $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private java.lang.Number $deregistrationDelaySec = _deregistrationDelaySec;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private java.lang.String $targetGroupName = _targetGroupName;

                @Override
                public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public java.lang.Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$deregistrationDelaySec = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public java.lang.String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$targetGroupName = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The virtual private cloud (VPC).
         */
        @Override
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }

        /**
         * The virtual private cloud (VPC).
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getDeregistrationDelaySec() {
            return this.jsiiGet("deregistrationDelaySec", java.lang.Number.class);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("deregistrationDelaySec", value);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this.jsiiSet("healthCheck", value);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTargetGroupName() {
            return this.jsiiGet("targetGroupName", java.lang.String.class);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("targetGroupName", value);
        }
    }
}
