package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining an Application Load Balancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-10-26T17:57:17.362Z")
public interface ApplicationLoadBalancerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {
    /**
     * Indicates whether HTTP/2 is enabled.
     * @default true
     */
    java.lang.Boolean getHttp2Enabled();
    /**
     * Indicates whether HTTP/2 is enabled.
     * @default true
     */
    void setHttp2Enabled(final java.lang.Boolean value);
    /**
     * The load balancer idle timeout, in seconds
     * @default 60
     */
    java.lang.Number getIdleTimeoutSecs();
    /**
     * The load balancer idle timeout, in seconds
     * @default 60
     */
    void setIdleTimeoutSecs(final java.lang.Number value);
    /**
     * The type of IP addresses to use
     * 
     * Only applies to application load balancers.
     * @default IpAddressType.Ipv4
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType();
    /**
     * The type of IP addresses to use
     * 
     * Only applies to application load balancers.
     * @default IpAddressType.Ipv4
     */
    void setIpAddressType(final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType value);
    /**
     * Security group to associate with this load balancer
     * @default A security group is created
     */
    software.amazon.awscdk.services.ec2.SecurityGroupRef getSecurityGroup();
    /**
     * Security group to associate with this load balancer
     * @default A security group is created
     */
    void setSecurityGroup(final software.amazon.awscdk.services.ec2.SecurityGroupRef value);

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationLoadBalancerProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _http2Enabled;
        @javax.annotation.Nullable
        private java.lang.Number _idleTimeoutSecs;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType _ipAddressType;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SecurityGroupRef _securityGroup;
        private software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;
        @javax.annotation.Nullable
        private java.lang.Boolean _deletionProtection;
        @javax.annotation.Nullable
        private java.lang.Boolean _internetFacing;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.VpcPlacementStrategy _vpcPlacement;

        /**
         * Sets the value of Http2Enabled
         * @param value Indicates whether HTTP/2 is enabled.
         * @return {@code this}
         */
        public Builder withHttp2Enabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._http2Enabled = value;
            return this;
        }
        /**
         * Sets the value of IdleTimeoutSecs
         * @param value The load balancer idle timeout, in seconds
         * @return {@code this}
         */
        public Builder withIdleTimeoutSecs(@javax.annotation.Nullable final java.lang.Number value) {
            this._idleTimeoutSecs = value;
            return this;
        }
        /**
         * Sets the value of IpAddressType
         * @param value The type of IP addresses to use

Only applies to application load balancers.
         * @return {@code this}
         */
        public Builder withIpAddressType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType value) {
            this._ipAddressType = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroup
         * @param value Security group to associate with this load balancer
         * @return {@code this}
         */
        public Builder withSecurityGroup(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SecurityGroupRef value) {
            this._securityGroup = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value The VPC network to place the load balancer in
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeletionProtection
         * @param value Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        public Builder withDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deletionProtection = value;
            return this;
        }
        /**
         * Sets the value of InternetFacing
         * @param value Whether the load balancer has an internet-routable address
         * @return {@code this}
         */
        public Builder withInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._internetFacing = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerName
         * @param value Name of the load balancer
         * @return {@code this}
         */
        public Builder withLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerName = value;
            return this;
        }
        /**
         * Sets the value of VpcPlacement
         * @param value Where in the VPC to place the load balancer
         * @return {@code this}
         */
        public Builder withVpcPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this._vpcPlacement = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApplicationLoadBalancerProps build() {
            return new ApplicationLoadBalancerProps() {
                @javax.annotation.Nullable
                private java.lang.Boolean $http2Enabled = _http2Enabled;
                @javax.annotation.Nullable
                private java.lang.Number $idleTimeoutSecs = _idleTimeoutSecs;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType $ipAddressType = _ipAddressType;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.SecurityGroupRef $securityGroup = _securityGroup;
                private software.amazon.awscdk.services.ec2.VpcNetworkRef $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $deletionProtection = _deletionProtection;
                @javax.annotation.Nullable
                private java.lang.Boolean $internetFacing = _internetFacing;
                @javax.annotation.Nullable
                private java.lang.String $loadBalancerName = _loadBalancerName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.ec2.VpcPlacementStrategy $vpcPlacement = _vpcPlacement;

                @Override
                public java.lang.Boolean getHttp2Enabled() {
                    return this.$http2Enabled;
                }

                @Override
                public void setHttp2Enabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$http2Enabled = value;
                }

                @Override
                public java.lang.Number getIdleTimeoutSecs() {
                    return this.$idleTimeoutSecs;
                }

                @Override
                public void setIdleTimeoutSecs(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$idleTimeoutSecs = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
                    return this.$ipAddressType;
                }

                @Override
                public void setIpAddressType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType value) {
                    this.$ipAddressType = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SecurityGroupRef getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public void setSecurityGroup(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SecurityGroupRef value) {
                    this.$securityGroup = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public java.lang.Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public void setDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$deletionProtection = value;
                }

                @Override
                public java.lang.Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public void setInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$internetFacing = value;
                }

                @Override
                public java.lang.String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public void setLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$loadBalancerName = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement() {
                    return this.$vpcPlacement;
                }

                @Override
                public void setVpcPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
                    this.$vpcPlacement = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Indicates whether HTTP/2 is enabled.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getHttp2Enabled() {
            return this.jsiiGet("http2Enabled", java.lang.Boolean.class);
        }

        /**
         * Indicates whether HTTP/2 is enabled.
         * @default true
         */
        @Override
        public void setHttp2Enabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("http2Enabled", value);
        }

        /**
         * The load balancer idle timeout, in seconds
         * @default 60
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getIdleTimeoutSecs() {
            return this.jsiiGet("idleTimeoutSecs", java.lang.Number.class);
        }

        /**
         * The load balancer idle timeout, in seconds
         * @default 60
         */
        @Override
        public void setIdleTimeoutSecs(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("idleTimeoutSecs", value);
        }

        /**
         * The type of IP addresses to use
         * 
         * Only applies to application load balancers.
         * @default IpAddressType.Ipv4
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
            return this.jsiiGet("ipAddressType", software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class);
        }

        /**
         * The type of IP addresses to use
         * 
         * Only applies to application load balancers.
         * @default IpAddressType.Ipv4
         */
        @Override
        public void setIpAddressType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType value) {
            this.jsiiSet("ipAddressType", value);
        }

        /**
         * Security group to associate with this load balancer
         * @default A security group is created
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SecurityGroupRef getSecurityGroup() {
            return this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.SecurityGroupRef.class);
        }

        /**
         * Security group to associate with this load balancer
         * @default A security group is created
         */
        @Override
        public void setSecurityGroup(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SecurityGroupRef value) {
            this.jsiiSet("securityGroup", value);
        }

        /**
         * The VPC network to place the load balancer in
         */
        @Override
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }

        /**
         * The VPC network to place the load balancer in
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * Indicates whether deletion protection is enabled.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDeletionProtection() {
            return this.jsiiGet("deletionProtection", java.lang.Boolean.class);
        }

        /**
         * Indicates whether deletion protection is enabled.
         * @default false
         */
        @Override
        public void setDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("deletionProtection", value);
        }

        /**
         * Whether the load balancer has an internet-routable address
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getInternetFacing() {
            return this.jsiiGet("internetFacing", java.lang.Boolean.class);
        }

        /**
         * Whether the load balancer has an internet-routable address
         * @default false
         */
        @Override
        public void setInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("internetFacing", value);
        }

        /**
         * Name of the load balancer
         * @default Automatically generated name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerName() {
            return this.jsiiGet("loadBalancerName", java.lang.String.class);
        }

        /**
         * Name of the load balancer
         * @default Automatically generated name
         */
        @Override
        public void setLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("loadBalancerName", value);
        }

        /**
         * Where in the VPC to place the load balancer
         * @default Public subnets if internetFacing, otherwise private subnets
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.VpcPlacementStrategy getVpcPlacement() {
            return this.jsiiGet("vpcPlacement", software.amazon.awscdk.services.ec2.VpcPlacementStrategy.class);
        }

        /**
         * Where in the VPC to place the load balancer
         * @default Public subnets if internetFacing, otherwise private subnets
         */
        @Override
        public void setVpcPlacement(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.VpcPlacementStrategy value) {
            this.jsiiSet("vpcPlacement", value);
        }
    }
}
