package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a conditional load balancing rule
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-06T17:20:32.123Z")
public interface AddRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Rule applies if the requested host matches the indicated host
     * 
     * May contain up to three '*' wildcards.
     * 
     * Requires that priority is set.
     * @default No host condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    java.lang.String getHostHeader();
    /**
     * Rule applies if the requested host matches the indicated host
     * 
     * May contain up to three '*' wildcards.
     * 
     * Requires that priority is set.
     * @default No host condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    void setHostHeader(final java.lang.String value);
    /**
     * Rule applies if the requested path matches the given path pattern
     * 
     * May contain up to three '*' wildcards.
     * 
     * Requires that priority is set.
     * @default No path condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    java.lang.String getPathPattern();
    /**
     * Rule applies if the requested path matches the given path pattern
     * 
     * May contain up to three '*' wildcards.
     * 
     * Requires that priority is set.
     * @default No path condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    void setPathPattern(final java.lang.String value);
    /**
     * Priority of this target group
     * 
     * The rule with the lowest priority will be used for every request.
     * If priority is not given, these target groups will be added as
     * defaults, and must not have conditions.
     * 
     * Priorities must be unique.
     * @default Target groups are used as defaults
     */
    java.lang.Number getPriority();
    /**
     * Priority of this target group
     * 
     * The rule with the lowest priority will be used for every request.
     * If priority is not given, these target groups will be added as
     * defaults, and must not have conditions.
     * 
     * Priorities must be unique.
     * @default Target groups are used as defaults
     */
    void setPriority(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link AddRuleProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddRuleProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.lang.Number _priority;

        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host

May contain up to three '*' wildcards.

Requires that priority is set.
         * @return {@code this}
         */
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern

May contain up to three '*' wildcards.

Requires that priority is set.
         * @return {@code this}
         */
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of this target group

The rule with the lowest priority will be used for every request.
If priority is not given, these target groups will be added as
defaults, and must not have conditions.

Priorities must be unique.
         * @return {@code this}
         */
        public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this._priority = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AddRuleProps build() {
            return new AddRuleProps() {
                @javax.annotation.Nullable
                private java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private java.lang.Number $priority = _priority;

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
                    this.$hostHeader = value;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
                    this.$pathPattern = value;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                @Override
                public void setPriority(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$priority = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("hostHeader", value);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("pathPattern", value);
        }

        /**
         * Priority of this target group
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * @default Target groups are used as defaults
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Priority of this target group
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * @default Target groups are used as defaults
         */
        @Override
        public void setPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("priority", value);
        }
    }
}
