/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.VpcNetworkRef;
import software.amazon.awscdk.services.ec2.VpcPlacementStrategy;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps;
import software.amazon.jsii.JsiiSerializable;

public interface NetworkLoadBalancerProps
extends JsiiSerializable,
BaseLoadBalancerProps {
    public Boolean getCrossZoneEnabled();

    public void setCrossZoneEnabled(Boolean var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Boolean _crossZoneEnabled;
        private VpcNetworkRef _vpc;
        @Nullable
        private Boolean _deletionProtection;
        @Nullable
        private Boolean _internetFacing;
        @Nullable
        private String _loadBalancerName;
        @Nullable
        private VpcPlacementStrategy _vpcPlacement;

        public Builder withCrossZoneEnabled(@Nullable Boolean value) {
            this._crossZoneEnabled = value;
            return this;
        }

        public Builder withVpc(VpcNetworkRef value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeletionProtection(@Nullable Boolean value) {
            this._deletionProtection = value;
            return this;
        }

        public Builder withInternetFacing(@Nullable Boolean value) {
            this._internetFacing = value;
            return this;
        }

        public Builder withLoadBalancerName(@Nullable String value) {
            this._loadBalancerName = value;
            return this;
        }

        public Builder withVpcPlacement(@Nullable VpcPlacementStrategy value) {
            this._vpcPlacement = value;
            return this;
        }

        public NetworkLoadBalancerProps build() {
            return new NetworkLoadBalancerProps(){
                @Nullable
                private Boolean $crossZoneEnabled;
                private VpcNetworkRef $vpc;
                @Nullable
                private Boolean $deletionProtection;
                @Nullable
                private Boolean $internetFacing;
                @Nullable
                private String $loadBalancerName;
                @Nullable
                private VpcPlacementStrategy $vpcPlacement;
                {
                    this.$crossZoneEnabled = _crossZoneEnabled;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deletionProtection = _deletionProtection;
                    this.$internetFacing = _internetFacing;
                    this.$loadBalancerName = _loadBalancerName;
                    this.$vpcPlacement = _vpcPlacement;
                }

                @Override
                public Boolean getCrossZoneEnabled() {
                    return this.$crossZoneEnabled;
                }

                @Override
                public void setCrossZoneEnabled(@Nullable Boolean value) {
                    this.$crossZoneEnabled = value;
                }

                @Override
                public VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(VpcNetworkRef value) {
                    this.$vpc = Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public void setDeletionProtection(@Nullable Boolean value) {
                    this.$deletionProtection = value;
                }

                @Override
                public Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public void setInternetFacing(@Nullable Boolean value) {
                    this.$internetFacing = value;
                }

                @Override
                public String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public void setLoadBalancerName(@Nullable String value) {
                    this.$loadBalancerName = value;
                }

                @Override
                public VpcPlacementStrategy getVpcPlacement() {
                    return this.$vpcPlacement;
                }

                @Override
                public void setVpcPlacement(@Nullable VpcPlacementStrategy value) {
                    this.$vpcPlacement = value;
                }
            };
        }
    }
}

