package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define the target of a load balancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-08T13:08:30.899Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseTargetGroup")
public abstract class BaseTargetGroup extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup,software.amazon.awscdk.services.codedeploy.api.ILoadBalancer {
    protected BaseTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Add a dependency between this target group and the indicated resources
     */
    public void addDependency(final software.amazon.awscdk.IDependable... other) {
        this.jsiiCall("addDependency", Void.class, java.util.Arrays.stream(java.util.Objects.requireNonNull(other, "other is required")).toArray());
    }

    /**
     * Register the given load balancing target as part of this group
     */
    protected void addLoadBalancerTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps props) {
        this.jsiiCall("addLoadBalancerTarget", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Specify the CodeDeploy-required properties of this load balancer.
     */
    @Override
    public software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps asCodeDeployLoadBalancer() {
        return this.jsiiCall("asCodeDeployLoadBalancer", software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps.class);
    }

    /**
     * Set/replace the target group's health check
     */
    public void configureHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
        this.jsiiCall("configureHealthCheck", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(healthCheck, "healthCheck is required")).toArray());
    }

    /**
     * Export this target group
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupRefProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupRefProps.class);
    }

    /**
     * Return an object to depend on the listeners added to this target group
     */
    @Override
    public software.amazon.awscdk.IDependable listenerDependency() {
        return this.jsiiCall("listenerDependency", software.amazon.awscdk.IDependable.class);
    }

    /**
     * Set a non-standard attribute on the target group
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     */
    public void setAttribute(final java.lang.String key, @javax.annotation.Nullable final java.lang.String value) {
        this.jsiiCall("setAttribute", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")), java.util.stream.Stream.of(value)).toArray());
    }

    /**
     * Set a non-standard attribute on the target group
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     */
    public void setAttribute(final java.lang.String key) {
        this.jsiiCall("setAttribute", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")).toArray());
    }

    /**
     * Default port configured for members of this target group
     */
    protected java.lang.String getDefaultPort() {
        return this.jsiiGet("defaultPort", java.lang.String.class);
    }

    /**
     * List of listeners routing to this target group
     */
    protected java.util.List<software.amazon.awscdk.IDependable> getDependableListeners() {
        return this.jsiiGet("dependableListeners", java.util.List.class);
    }

    /**
     * The ARN of the target group
     */
    @Override
    public java.lang.String getTargetGroupArn() {
        return this.jsiiGet("targetGroupArn", java.lang.String.class);
    }

    /**
     * The full name of the target group
     */
    public java.lang.String getTargetGroupFullName() {
        return this.jsiiGet("targetGroupFullName", java.lang.String.class);
    }

    /**
     * The name of the target group
     */
    public java.lang.String getTargetGroupName() {
        return this.jsiiGet("targetGroupName", java.lang.String.class);
    }

    /**
     * Health check for the members of this target group
     */
    public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
        return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
    }

    /**
     * Health check for the members of this target group
     */
    public void setHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
        this.jsiiSet("healthCheck", java.util.Objects.requireNonNull(value, "healthCheck is required"));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroup {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARN of the target group
         */
        @Override
        public java.lang.String getTargetGroupArn() {
            return this.jsiiGet("targetGroupArn", java.lang.String.class);
        }

        /**
         * Return an object to depend on the listeners added to this target group
         */
        @Override
        public software.amazon.awscdk.IDependable listenerDependency() {
            return this.jsiiCall("listenerDependency", software.amazon.awscdk.IDependable.class);
        }

        /**
         * Specify the CodeDeploy-required properties of this load balancer.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps asCodeDeployLoadBalancer() {
            return this.jsiiCall("asCodeDeployLoadBalancer", software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps.class);
        }
    }
}
