/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.VpcNetworkRef;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.jsii.JsiiSerializable;

public interface NetworkTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    public Number getPort();

    public void setPort(Number var1);

    public Boolean getProxyProtocolV2();

    public void setProxyProtocolV2(Boolean var1);

    public List<INetworkLoadBalancerTarget> getTargets();

    public void setTargets(List<INetworkLoadBalancerTarget> var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _port;
        @Nullable
        private Boolean _proxyProtocolV2;
        @Nullable
        private List<INetworkLoadBalancerTarget> _targets;
        private VpcNetworkRef _vpc;
        @Nullable
        private Number _deregistrationDelaySec;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private String _targetGroupName;

        public Builder withPort(Number value) {
            this._port = Objects.requireNonNull(value, "port is required");
            return this;
        }

        public Builder withProxyProtocolV2(@Nullable Boolean value) {
            this._proxyProtocolV2 = value;
            return this;
        }

        public Builder withTargets(@Nullable List<INetworkLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        public Builder withVpc(VpcNetworkRef value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeregistrationDelaySec(@Nullable Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withTargetGroupName(@Nullable String value) {
            this._targetGroupName = value;
            return this;
        }

        public NetworkTargetGroupProps build() {
            return new NetworkTargetGroupProps(){
                private Number $port;
                @Nullable
                private Boolean $proxyProtocolV2;
                @Nullable
                private List<INetworkLoadBalancerTarget> $targets;
                private VpcNetworkRef $vpc;
                @Nullable
                private Number $deregistrationDelaySec;
                @Nullable
                private HealthCheck $healthCheck;
                @Nullable
                private String $targetGroupName;
                {
                    this.$port = Objects.requireNonNull(_port, "port is required");
                    this.$proxyProtocolV2 = _proxyProtocolV2;
                    this.$targets = _targets;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deregistrationDelaySec = _deregistrationDelaySec;
                    this.$healthCheck = _healthCheck;
                    this.$targetGroupName = _targetGroupName;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(Number value) {
                    this.$port = Objects.requireNonNull(value, "port is required");
                }

                @Override
                public Boolean getProxyProtocolV2() {
                    return this.$proxyProtocolV2;
                }

                @Override
                public void setProxyProtocolV2(@Nullable Boolean value) {
                    this.$proxyProtocolV2 = value;
                }

                @Override
                public List<INetworkLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(@Nullable List<INetworkLoadBalancerTarget> value) {
                    this.$targets = value;
                }

                @Override
                public VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(VpcNetworkRef value) {
                    this.$vpc = Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public void setDeregistrationDelaySec(@Nullable Number value) {
                    this.$deregistrationDelaySec = value;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@Nullable HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public void setTargetGroupName(@Nullable String value) {
                    this.$targetGroupName = value;
                }
            };
        }
    }
}

