/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.SecurityGroupRef;
import software.amazon.awscdk.services.ec2.VpcNetworkRef;
import software.amazon.awscdk.services.ec2.VpcPlacementStrategy;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType;
import software.amazon.jsii.JsiiSerializable;

public interface ApplicationLoadBalancerProps
extends JsiiSerializable,
BaseLoadBalancerProps {
    public Boolean getHttp2Enabled();

    public void setHttp2Enabled(Boolean var1);

    public Number getIdleTimeoutSecs();

    public void setIdleTimeoutSecs(Number var1);

    public IpAddressType getIpAddressType();

    public void setIpAddressType(IpAddressType var1);

    public SecurityGroupRef getSecurityGroup();

    public void setSecurityGroup(SecurityGroupRef var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Boolean _http2Enabled;
        @Nullable
        private Number _idleTimeoutSecs;
        @Nullable
        private IpAddressType _ipAddressType;
        @Nullable
        private SecurityGroupRef _securityGroup;
        private VpcNetworkRef _vpc;
        @Nullable
        private Boolean _deletionProtection;
        @Nullable
        private Boolean _internetFacing;
        @Nullable
        private String _loadBalancerName;
        @Nullable
        private VpcPlacementStrategy _vpcPlacement;

        public Builder withHttp2Enabled(@Nullable Boolean value) {
            this._http2Enabled = value;
            return this;
        }

        public Builder withIdleTimeoutSecs(@Nullable Number value) {
            this._idleTimeoutSecs = value;
            return this;
        }

        public Builder withIpAddressType(@Nullable IpAddressType value) {
            this._ipAddressType = value;
            return this;
        }

        public Builder withSecurityGroup(@Nullable SecurityGroupRef value) {
            this._securityGroup = value;
            return this;
        }

        public Builder withVpc(VpcNetworkRef value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeletionProtection(@Nullable Boolean value) {
            this._deletionProtection = value;
            return this;
        }

        public Builder withInternetFacing(@Nullable Boolean value) {
            this._internetFacing = value;
            return this;
        }

        public Builder withLoadBalancerName(@Nullable String value) {
            this._loadBalancerName = value;
            return this;
        }

        public Builder withVpcPlacement(@Nullable VpcPlacementStrategy value) {
            this._vpcPlacement = value;
            return this;
        }

        public ApplicationLoadBalancerProps build() {
            return new ApplicationLoadBalancerProps(){
                @Nullable
                private Boolean $http2Enabled;
                @Nullable
                private Number $idleTimeoutSecs;
                @Nullable
                private IpAddressType $ipAddressType;
                @Nullable
                private SecurityGroupRef $securityGroup;
                private VpcNetworkRef $vpc;
                @Nullable
                private Boolean $deletionProtection;
                @Nullable
                private Boolean $internetFacing;
                @Nullable
                private String $loadBalancerName;
                @Nullable
                private VpcPlacementStrategy $vpcPlacement;
                {
                    this.$http2Enabled = _http2Enabled;
                    this.$idleTimeoutSecs = _idleTimeoutSecs;
                    this.$ipAddressType = _ipAddressType;
                    this.$securityGroup = _securityGroup;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deletionProtection = _deletionProtection;
                    this.$internetFacing = _internetFacing;
                    this.$loadBalancerName = _loadBalancerName;
                    this.$vpcPlacement = _vpcPlacement;
                }

                @Override
                public Boolean getHttp2Enabled() {
                    return this.$http2Enabled;
                }

                @Override
                public void setHttp2Enabled(@Nullable Boolean value) {
                    this.$http2Enabled = value;
                }

                @Override
                public Number getIdleTimeoutSecs() {
                    return this.$idleTimeoutSecs;
                }

                @Override
                public void setIdleTimeoutSecs(@Nullable Number value) {
                    this.$idleTimeoutSecs = value;
                }

                @Override
                public IpAddressType getIpAddressType() {
                    return this.$ipAddressType;
                }

                @Override
                public void setIpAddressType(@Nullable IpAddressType value) {
                    this.$ipAddressType = value;
                }

                @Override
                public SecurityGroupRef getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public void setSecurityGroup(@Nullable SecurityGroupRef value) {
                    this.$securityGroup = value;
                }

                @Override
                public VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(VpcNetworkRef value) {
                    this.$vpc = Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public void setDeletionProtection(@Nullable Boolean value) {
                    this.$deletionProtection = value;
                }

                @Override
                public Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public void setInternetFacing(@Nullable Boolean value) {
                    this.$internetFacing = value;
                }

                @Override
                public String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public void setLoadBalancerName(@Nullable String value) {
                    this.$loadBalancerName = value;
                }

                @Override
                public VpcPlacementStrategy getVpcPlacement() {
                    return this.$vpcPlacement;
                }

                @Override
                public void setVpcPlacement(@Nullable VpcPlacementStrategy value) {
                    this.$vpcPlacement = value;
                }
            };
        }
    }
}

