/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.jsii.JsiiSerializable;

public interface ApplicationListenerProps
extends JsiiSerializable,
BaseApplicationListenerProps {
    public IApplicationLoadBalancer getLoadBalancer();

    public void setLoadBalancer(IApplicationLoadBalancer var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IApplicationLoadBalancer _loadBalancer;
        @Nullable
        private List<String> _certificateArns;
        @Nullable
        private List<IApplicationTargetGroup> _defaultTargetGroups;
        @Nullable
        private Boolean _open;
        @Nullable
        private Number _port;
        @Nullable
        private ApplicationProtocol _protocol;
        @Nullable
        private SslPolicy _sslPolicy;

        public Builder withLoadBalancer(IApplicationLoadBalancer value) {
            this._loadBalancer = Objects.requireNonNull(value, "loadBalancer is required");
            return this;
        }

        public Builder withCertificateArns(@Nullable List<String> value) {
            this._certificateArns = value;
            return this;
        }

        public Builder withDefaultTargetGroups(@Nullable List<IApplicationTargetGroup> value) {
            this._defaultTargetGroups = value;
            return this;
        }

        public Builder withOpen(@Nullable Boolean value) {
            this._open = value;
            return this;
        }

        public Builder withPort(@Nullable Number value) {
            this._port = value;
            return this;
        }

        public Builder withProtocol(@Nullable ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }

        public Builder withSslPolicy(@Nullable SslPolicy value) {
            this._sslPolicy = value;
            return this;
        }

        public ApplicationListenerProps build() {
            return new ApplicationListenerProps(){
                private IApplicationLoadBalancer $loadBalancer;
                @Nullable
                private List<String> $certificateArns;
                @Nullable
                private List<IApplicationTargetGroup> $defaultTargetGroups;
                @Nullable
                private Boolean $open;
                @Nullable
                private Number $port;
                @Nullable
                private ApplicationProtocol $protocol;
                @Nullable
                private SslPolicy $sslPolicy;
                {
                    this.$loadBalancer = Objects.requireNonNull(_loadBalancer, "loadBalancer is required");
                    this.$certificateArns = _certificateArns;
                    this.$defaultTargetGroups = _defaultTargetGroups;
                    this.$open = _open;
                    this.$port = _port;
                    this.$protocol = _protocol;
                    this.$sslPolicy = _sslPolicy;
                }

                @Override
                public IApplicationLoadBalancer getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public void setLoadBalancer(IApplicationLoadBalancer value) {
                    this.$loadBalancer = Objects.requireNonNull(value, "loadBalancer is required");
                }

                @Override
                public List<String> getCertificateArns() {
                    return this.$certificateArns;
                }

                @Override
                public void setCertificateArns(@Nullable List<String> value) {
                    this.$certificateArns = value;
                }

                @Override
                public List<IApplicationTargetGroup> getDefaultTargetGroups() {
                    return this.$defaultTargetGroups;
                }

                @Override
                public void setDefaultTargetGroups(@Nullable List<IApplicationTargetGroup> value) {
                    this.$defaultTargetGroups = value;
                }

                @Override
                public Boolean getOpen() {
                    return this.$open;
                }

                @Override
                public void setOpen(@Nullable Boolean value) {
                    this.$open = value;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(@Nullable Number value) {
                    this.$port = value;
                }

                @Override
                public ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@Nullable ApplicationProtocol value) {
                    this.$protocol = value;
                }

                @Override
                public SslPolicy getSslPolicy() {
                    return this.$sslPolicy;
                }

                @Override
                public void setSslPolicy(@Nullable SslPolicy value) {
                    this.$sslPolicy = value;
                }
            };
        }
    }
}

