package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a listener rule
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-11-21T12:42:29.509Z")
public interface ApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerRuleProps {
    /**
     * The listener to attach the rule to
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();
    /**
     * The listener to attach the rule to
     */
    void setListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener value);

    /**
     * @return a {@link Builder} of {@link ApplicationListenerRuleProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerRuleProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener _listener;
        private java.lang.Number _priority;
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> _targetGroups;

        /**
         * Sets the value of Listener
         * @param value The listener to attach the rule to
         * @return {@code this}
         */
        public Builder withListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener value) {
            this._listener = java.util.Objects.requireNonNull(value, "listener is required");
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of the rule

The rule with the lowest priority will be used for every request.

Priorities must be unique.
         * @return {@code this}
         */
        public Builder withPriority(final java.lang.Number value) {
            this._priority = java.util.Objects.requireNonNull(value, "priority is required");
            return this;
        }
        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host

May contain up to three '*' wildcards.
         * @return {@code this}
         */
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern

May contain up to three '*' wildcards.
         * @return {@code this}
         */
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of TargetGroups
         * @param value Target groups to forward requests to
         * @return {@code this}
         */
        public Builder withTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this._targetGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApplicationListenerRuleProps build() {
            return new ApplicationListenerRuleProps() {
                private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener $listener = java.util.Objects.requireNonNull(_listener, "listener is required");
                private java.lang.Number $priority = java.util.Objects.requireNonNull(_priority, "priority is required");
                @javax.annotation.Nullable
                private java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> $targetGroups = _targetGroups;

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
                    return this.$listener;
                }

                @Override
                public void setListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener value) {
                    this.$listener = java.util.Objects.requireNonNull(value, "listener is required");
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                @Override
                public void setPriority(final java.lang.Number value) {
                    this.$priority = java.util.Objects.requireNonNull(value, "priority is required");
                }

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
                    this.$hostHeader = value;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
                    this.$pathPattern = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
                    return this.$targetGroups;
                }

                @Override
                public void setTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
                    this.$targetGroups = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The listener to attach the rule to
         */
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.jsiiGet("listener", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class);
        }

        /**
         * The listener to attach the rule to
         */
        @Override
        public void setListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener value) {
            this.jsiiSet("listener", java.util.Objects.requireNonNull(value, "listener is required"));
        }

        /**
         * Priority of the rule
         * 
         * The rule with the lowest priority will be used for every request.
         * 
         * Priorities must be unique.
         */
        @Override
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Priority of the rule
         * 
         * The rule with the lowest priority will be used for every request.
         * 
         * Priorities must be unique.
         */
        @Override
        public void setPriority(final java.lang.Number value) {
            this.jsiiSet("priority", java.util.Objects.requireNonNull(value, "priority is required"));
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("hostHeader", value);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("pathPattern", value);
        }

        /**
         * Target groups to forward requests to
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.jsiiGet("targetGroups", java.util.List.class);
        }

        /**
         * Target groups to forward requests to
         */
        @Override
        public void setTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this.jsiiSet("targetGroups", value);
        }
    }
}
