package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a new Network Target Group
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:21:46.518Z")
public interface NetworkTargetGroupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps {
    /**
     * The port on which the listener listens for requests.
     */
    java.lang.Number getPort();
    /**
     * The port on which the listener listens for requests.
     */
    void setPort(final java.lang.Number value);
    /**
     * Indicates whether Proxy Protocol version 2 is enabled.
     * @default false
     */
    java.lang.Boolean getProxyProtocolV2();
    /**
     * Indicates whether Proxy Protocol version 2 is enabled.
     * @default false
     */
    void setProxyProtocolV2(final java.lang.Boolean value);
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets();
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> value);

    /**
     * @return a {@link Builder} of {@link NetworkTargetGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NetworkTargetGroupProps}
     */
    final class Builder {
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private java.lang.Boolean _proxyProtocolV2;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> _targets;
        private software.amazon.awscdk.services.ec2.VpcNetworkRef _vpc;
        @javax.annotation.Nullable
        private java.lang.Number _deregistrationDelaySec;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.String _targetGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType _targetType;

        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of ProxyProtocolV2
         * @param value Indicates whether Proxy Protocol version 2 is enabled.
         * @return {@code this}
         */
        public Builder withProxyProtocolV2(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._proxyProtocolV2 = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value The targets to add to this target group.

Can be `Instance`, `IPAddress`, or any self-registering load balancing
target. If you use either `Instance` or `IPAddress` as targets, all
target must be of the same type.
         * @return {@code this}
         */
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value The virtual private cloud (VPC).
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeregistrationDelaySec
         * @param value The amount of time for Elastic Load Balancing to wait before deregistering a target.

The range is 0–3600 seconds.
         * @return {@code this}
         */
        public Builder withDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check configuration
         * @return {@code this}
         */
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of TargetGroupName
         * @param value The name of the target group.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens, and
must not begin or end with a hyphen.
         * @return {@code this}
         */
        public Builder withTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._targetGroupName = value;
            return this;
        }
        /**
         * Sets the value of TargetType
         * @param value The type of targets registered to this TargetGroup, either IP or Instance.

All targets registered into the group must be of this type. If you
register targets to the TargetGroup in the CDK app, the TargetType is
determined automatically.
         * @return {@code this}
         */
        public Builder withTargetType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
            this._targetType = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public NetworkTargetGroupProps build() {
            return new NetworkTargetGroupProps() {
                private java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                @javax.annotation.Nullable
                private java.lang.Boolean $proxyProtocolV2 = _proxyProtocolV2;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> $targets = _targets;
                private software.amazon.awscdk.services.ec2.VpcNetworkRef $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private java.lang.Number $deregistrationDelaySec = _deregistrationDelaySec;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private java.lang.String $targetGroupName = _targetGroupName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType $targetType = _targetType;

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(final java.lang.Number value) {
                    this.$port = java.util.Objects.requireNonNull(value, "port is required");
                }

                @Override
                public java.lang.Boolean getProxyProtocolV2() {
                    return this.$proxyProtocolV2;
                }

                @Override
                public void setProxyProtocolV2(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$proxyProtocolV2 = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> value) {
                    this.$targets = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public java.lang.Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$deregistrationDelaySec = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public java.lang.String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$targetGroupName = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
                    return this.$targetType;
                }

                @Override
                public void setTargetType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
                    this.$targetType = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The port on which the listener listens for requests.
         */
        @Override
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The port on which the listener listens for requests.
         */
        @Override
        public void setPort(final java.lang.Number value) {
            this.jsiiSet("port", java.util.Objects.requireNonNull(value, "port is required"));
        }

        /**
         * Indicates whether Proxy Protocol version 2 is enabled.
         * @default false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getProxyProtocolV2() {
            return this.jsiiGet("proxyProtocolV2", java.lang.Boolean.class);
        }

        /**
         * Indicates whether Proxy Protocol version 2 is enabled.
         * @default false
         */
        @Override
        public void setProxyProtocolV2(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("proxyProtocolV2", value);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> value) {
            this.jsiiSet("targets", value);
        }

        /**
         * The virtual private cloud (VPC).
         */
        @Override
        public software.amazon.awscdk.services.ec2.VpcNetworkRef getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.VpcNetworkRef.class);
        }

        /**
         * The virtual private cloud (VPC).
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.VpcNetworkRef value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getDeregistrationDelaySec() {
            return this.jsiiGet("deregistrationDelaySec", java.lang.Number.class);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("deregistrationDelaySec", value);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this.jsiiSet("healthCheck", value);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTargetGroupName() {
            return this.jsiiGet("targetGroupName", java.lang.String.class);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("targetGroupName", value);
        }

        /**
         * The type of targets registered to this TargetGroup, either IP or Instance.
         * 
         * All targets registered into the group must be of this type. If you
         * register targets to the TargetGroup in the CDK app, the TargetType is
         * determined automatically.
         * @default Determined automatically
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
        }

        /**
         * The type of targets registered to this TargetGroup, either IP or Instance.
         * 
         * All targets registered into the group must be of this type. If you
         * register targets to the TargetGroup in the CDK app, the TargetType is
         * determined automatically.
         * @default Determined automatically
         */
        @Override
        public void setTargetType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
            this.jsiiSet("targetType", value);
        }
    }
}
