package software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:21:46.523Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.cloudformation.ListenerResource")
public class ListenerResource extends software.amazon.awscdk.Resource {
    protected ListenerResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ElasticLoadBalancingV2::Listener``.
     * @param parent the ``cdk.Construct`` this ``ListenerResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ListenerResource``
     */
    public ListenerResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required")).toArray());
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getListenerArn() {
        return this.jsiiGet("listenerArn", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResourceProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResourceProps.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html
     */
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        java.lang.Object getType();
        /**
         * ``ListenerResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        void setType(final java.lang.String value);
        /**
         * ``ListenerResource.ActionProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
         */
        java.lang.Object getAuthenticateCognitoConfig();
        /**
         * ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
         */
        void setAuthenticateCognitoConfig(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
         */
        void setAuthenticateCognitoConfig(final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateCognitoConfigProperty value);
        /**
         * ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
         */
        java.lang.Object getAuthenticateOidcConfig();
        /**
         * ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
         */
        void setAuthenticateOidcConfig(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
         */
        void setAuthenticateOidcConfig(final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateOidcConfigProperty value);
        /**
         * ``ListenerResource.ActionProperty.FixedResponseConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
         */
        java.lang.Object getFixedResponseConfig();
        /**
         * ``ListenerResource.ActionProperty.FixedResponseConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
         */
        void setFixedResponseConfig(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.ActionProperty.FixedResponseConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
         */
        void setFixedResponseConfig(final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.FixedResponseConfigProperty value);
        /**
         * ``ListenerResource.ActionProperty.Order``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
         */
        java.lang.Object getOrder();
        /**
         * ``ListenerResource.ActionProperty.Order``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
         */
        void setOrder(final java.lang.Number value);
        /**
         * ``ListenerResource.ActionProperty.Order``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
         */
        void setOrder(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.ActionProperty.RedirectConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
         */
        java.lang.Object getRedirectConfig();
        /**
         * ``ListenerResource.ActionProperty.RedirectConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
         */
        void setRedirectConfig(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.ActionProperty.RedirectConfig``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
         */
        void setRedirectConfig(final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.RedirectConfigProperty value);
        /**
         * ``ListenerResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        java.lang.Object getTargetGroupArn();
        /**
         * ``ListenerResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        void setTargetGroupArn(final java.lang.String value);
        /**
         * ``ListenerResource.ActionProperty.TargetGroupArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        void setTargetGroupArn(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ActionProperty}
         */
        final class Builder {
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _authenticateCognitoConfig;
            @javax.annotation.Nullable
            private java.lang.Object _authenticateOidcConfig;
            @javax.annotation.Nullable
            private java.lang.Object _fixedResponseConfig;
            @javax.annotation.Nullable
            private java.lang.Object _order;
            @javax.annotation.Nullable
            private java.lang.Object _redirectConfig;
            @javax.annotation.Nullable
            private java.lang.Object _targetGroupArn;

            /**
             * Sets the value of Type
             * @param value ``ListenerResource.ActionProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``ListenerResource.ActionProperty.Type``
             * @return {@code this}
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param value ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
             * @return {@code this}
             */
            public Builder withAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticateCognitoConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param value ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
             * @return {@code this}
             */
            public Builder withAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateCognitoConfigProperty value) {
                this._authenticateCognitoConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateOidcConfig
             * @param value ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
             * @return {@code this}
             */
            public Builder withAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticateOidcConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateOidcConfig
             * @param value ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
             * @return {@code this}
             */
            public Builder withAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateOidcConfigProperty value) {
                this._authenticateOidcConfig = value;
                return this;
            }
            /**
             * Sets the value of FixedResponseConfig
             * @param value ``ListenerResource.ActionProperty.FixedResponseConfig``
             * @return {@code this}
             */
            public Builder withFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._fixedResponseConfig = value;
                return this;
            }
            /**
             * Sets the value of FixedResponseConfig
             * @param value ``ListenerResource.ActionProperty.FixedResponseConfig``
             * @return {@code this}
             */
            public Builder withFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.FixedResponseConfigProperty value) {
                this._fixedResponseConfig = value;
                return this;
            }
            /**
             * Sets the value of Order
             * @param value ``ListenerResource.ActionProperty.Order``
             * @return {@code this}
             */
            public Builder withOrder(@javax.annotation.Nullable final java.lang.Number value) {
                this._order = value;
                return this;
            }
            /**
             * Sets the value of Order
             * @param value ``ListenerResource.ActionProperty.Order``
             * @return {@code this}
             */
            public Builder withOrder(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._order = value;
                return this;
            }
            /**
             * Sets the value of RedirectConfig
             * @param value ``ListenerResource.ActionProperty.RedirectConfig``
             * @return {@code this}
             */
            public Builder withRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._redirectConfig = value;
                return this;
            }
            /**
             * Sets the value of RedirectConfig
             * @param value ``ListenerResource.ActionProperty.RedirectConfig``
             * @return {@code this}
             */
            public Builder withRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.RedirectConfigProperty value) {
                this._redirectConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupArn
             * @param value ``ListenerResource.ActionProperty.TargetGroupArn``
             * @return {@code this}
             */
            public Builder withTargetGroupArn(@javax.annotation.Nullable final java.lang.String value) {
                this._targetGroupArn = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupArn
             * @param value ``ListenerResource.ActionProperty.TargetGroupArn``
             * @return {@code this}
             */
            public Builder withTargetGroupArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._targetGroupArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ActionProperty build() {
                return new ActionProperty() {
                    private java.lang.Object $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $authenticateCognitoConfig = _authenticateCognitoConfig;
                    @javax.annotation.Nullable
                    private java.lang.Object $authenticateOidcConfig = _authenticateOidcConfig;
                    @javax.annotation.Nullable
                    private java.lang.Object $fixedResponseConfig = _fixedResponseConfig;
                    @javax.annotation.Nullable
                    private java.lang.Object $order = _order;
                    @javax.annotation.Nullable
                    private java.lang.Object $redirectConfig = _redirectConfig;
                    @javax.annotation.Nullable
                    private java.lang.Object $targetGroupArn = _targetGroupArn;

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(final java.lang.String value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public void setType(final software.amazon.awscdk.Token value) {
                        this.$type = java.util.Objects.requireNonNull(value, "type is required");
                    }

                    @Override
                    public java.lang.Object getAuthenticateCognitoConfig() {
                        return this.$authenticateCognitoConfig;
                    }

                    @Override
                    public void setAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$authenticateCognitoConfig = value;
                    }

                    @Override
                    public void setAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateCognitoConfigProperty value) {
                        this.$authenticateCognitoConfig = value;
                    }

                    @Override
                    public java.lang.Object getAuthenticateOidcConfig() {
                        return this.$authenticateOidcConfig;
                    }

                    @Override
                    public void setAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$authenticateOidcConfig = value;
                    }

                    @Override
                    public void setAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateOidcConfigProperty value) {
                        this.$authenticateOidcConfig = value;
                    }

                    @Override
                    public java.lang.Object getFixedResponseConfig() {
                        return this.$fixedResponseConfig;
                    }

                    @Override
                    public void setFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$fixedResponseConfig = value;
                    }

                    @Override
                    public void setFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.FixedResponseConfigProperty value) {
                        this.$fixedResponseConfig = value;
                    }

                    @Override
                    public java.lang.Object getOrder() {
                        return this.$order;
                    }

                    @Override
                    public void setOrder(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$order = value;
                    }

                    @Override
                    public void setOrder(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$order = value;
                    }

                    @Override
                    public java.lang.Object getRedirectConfig() {
                        return this.$redirectConfig;
                    }

                    @Override
                    public void setRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$redirectConfig = value;
                    }

                    @Override
                    public void setRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.RedirectConfigProperty value) {
                        this.$redirectConfig = value;
                    }

                    @Override
                    public java.lang.Object getTargetGroupArn() {
                        return this.$targetGroupArn;
                    }

                    @Override
                    public void setTargetGroupArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$targetGroupArn = value;
                    }

                    @Override
                    public void setTargetGroupArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$targetGroupArn = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.ActionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ListenerResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
             */
            @Override
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
             */
            @Override
            public void setType(final java.lang.String value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ListenerResource.ActionProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
             */
            @Override
            public void setType(final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
            }

            /**
             * ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticateCognitoConfig() {
                return this.jsiiGet("authenticateCognitoConfig", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
             */
            @Override
            public void setAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("authenticateCognitoConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.AuthenticateCognitoConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
             */
            @Override
            public void setAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateCognitoConfigProperty value) {
                this.jsiiSet("authenticateCognitoConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticateOidcConfig() {
                return this.jsiiGet("authenticateOidcConfig", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
             */
            @Override
            public void setAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("authenticateOidcConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.AuthenticateOidcConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
             */
            @Override
            public void setAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateOidcConfigProperty value) {
                this.jsiiSet("authenticateOidcConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.FixedResponseConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFixedResponseConfig() {
                return this.jsiiGet("fixedResponseConfig", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.ActionProperty.FixedResponseConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
             */
            @Override
            public void setFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("fixedResponseConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.FixedResponseConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
             */
            @Override
            public void setFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.FixedResponseConfigProperty value) {
                this.jsiiSet("fixedResponseConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.Order``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOrder() {
                return this.jsiiGet("order", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.ActionProperty.Order``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
             */
            @Override
            public void setOrder(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("order", value);
            }

            /**
             * ``ListenerResource.ActionProperty.Order``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
             */
            @Override
            public void setOrder(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("order", value);
            }

            /**
             * ``ListenerResource.ActionProperty.RedirectConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRedirectConfig() {
                return this.jsiiGet("redirectConfig", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.ActionProperty.RedirectConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
             */
            @Override
            public void setRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("redirectConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.RedirectConfig``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
             */
            @Override
            public void setRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.RedirectConfigProperty value) {
                this.jsiiSet("redirectConfig", value);
            }

            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getTargetGroupArn() {
                return this.jsiiGet("targetGroupArn", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            @Override
            public void setTargetGroupArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("targetGroupArn", value);
            }

            /**
             * ``ListenerResource.ActionProperty.TargetGroupArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            @Override
            public void setTargetGroupArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("targetGroupArn", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html
     */
    public static interface AuthenticateCognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
         */
        java.lang.Object getUserPoolArn();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
         */
        void setUserPoolArn(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
         */
        void setUserPoolArn(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
         */
        java.lang.Object getUserPoolClientId();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
         */
        void setUserPoolClientId(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
         */
        void setUserPoolClientId(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
         */
        java.lang.Object getUserPoolDomain();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
         */
        void setUserPoolDomain(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
         */
        void setUserPoolDomain(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
         */
        java.lang.Object getAuthenticationRequestExtraParams();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
         */
        void setAuthenticationRequestExtraParams(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
         */
        void setAuthenticationRequestExtraParams(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
         */
        java.lang.Object getOnUnauthenticatedRequest();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
         */
        void setOnUnauthenticatedRequest(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
         */
        void setOnUnauthenticatedRequest(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
         */
        java.lang.Object getScope();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
         */
        void setScope(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
         */
        void setScope(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
         */
        java.lang.Object getSessionCookieName();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
         */
        void setSessionCookieName(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
         */
        void setSessionCookieName(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
         */
        java.lang.Object getSessionTimeout();
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
         */
        void setSessionTimeout(final java.lang.Number value);
        /**
         * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
         */
        void setSessionTimeout(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AuthenticateCognitoConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AuthenticateCognitoConfigProperty}
         */
        final class Builder {
            private java.lang.Object _userPoolArn;
            private java.lang.Object _userPoolClientId;
            private java.lang.Object _userPoolDomain;
            @javax.annotation.Nullable
            private java.lang.Object _authenticationRequestExtraParams;
            @javax.annotation.Nullable
            private java.lang.Object _onUnauthenticatedRequest;
            @javax.annotation.Nullable
            private java.lang.Object _scope;
            @javax.annotation.Nullable
            private java.lang.Object _sessionCookieName;
            @javax.annotation.Nullable
            private java.lang.Object _sessionTimeout;

            /**
             * Sets the value of UserPoolArn
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
             * @return {@code this}
             */
            public Builder withUserPoolArn(final java.lang.String value) {
                this._userPoolArn = java.util.Objects.requireNonNull(value, "userPoolArn is required");
                return this;
            }
            /**
             * Sets the value of UserPoolArn
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
             * @return {@code this}
             */
            public Builder withUserPoolArn(final software.amazon.awscdk.Token value) {
                this._userPoolArn = java.util.Objects.requireNonNull(value, "userPoolArn is required");
                return this;
            }
            /**
             * Sets the value of UserPoolClientId
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
             * @return {@code this}
             */
            public Builder withUserPoolClientId(final java.lang.String value) {
                this._userPoolClientId = java.util.Objects.requireNonNull(value, "userPoolClientId is required");
                return this;
            }
            /**
             * Sets the value of UserPoolClientId
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
             * @return {@code this}
             */
            public Builder withUserPoolClientId(final software.amazon.awscdk.Token value) {
                this._userPoolClientId = java.util.Objects.requireNonNull(value, "userPoolClientId is required");
                return this;
            }
            /**
             * Sets the value of UserPoolDomain
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
             * @return {@code this}
             */
            public Builder withUserPoolDomain(final java.lang.String value) {
                this._userPoolDomain = java.util.Objects.requireNonNull(value, "userPoolDomain is required");
                return this;
            }
            /**
             * Sets the value of UserPoolDomain
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
             * @return {@code this}
             */
            public Builder withUserPoolDomain(final software.amazon.awscdk.Token value) {
                this._userPoolDomain = java.util.Objects.requireNonNull(value, "userPoolDomain is required");
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
             * @return {@code this}
             */
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
             * @return {@code this}
             */
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
             * @return {@code this}
             */
            public Builder withScope(@javax.annotation.Nullable final java.lang.String value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
             * @return {@code this}
             */
            public Builder withScope(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
             * @return {@code this}
             */
            public Builder withSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
             * @return {@code this}
             */
            public Builder withSessionCookieName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this._sessionTimeout = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sessionTimeout = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateCognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AuthenticateCognitoConfigProperty build() {
                return new AuthenticateCognitoConfigProperty() {
                    private java.lang.Object $userPoolArn = java.util.Objects.requireNonNull(_userPoolArn, "userPoolArn is required");
                    private java.lang.Object $userPoolClientId = java.util.Objects.requireNonNull(_userPoolClientId, "userPoolClientId is required");
                    private java.lang.Object $userPoolDomain = java.util.Objects.requireNonNull(_userPoolDomain, "userPoolDomain is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $authenticationRequestExtraParams = _authenticationRequestExtraParams;
                    @javax.annotation.Nullable
                    private java.lang.Object $onUnauthenticatedRequest = _onUnauthenticatedRequest;
                    @javax.annotation.Nullable
                    private java.lang.Object $scope = _scope;
                    @javax.annotation.Nullable
                    private java.lang.Object $sessionCookieName = _sessionCookieName;
                    @javax.annotation.Nullable
                    private java.lang.Object $sessionTimeout = _sessionTimeout;

                    @Override
                    public java.lang.Object getUserPoolArn() {
                        return this.$userPoolArn;
                    }

                    @Override
                    public void setUserPoolArn(final java.lang.String value) {
                        this.$userPoolArn = java.util.Objects.requireNonNull(value, "userPoolArn is required");
                    }

                    @Override
                    public void setUserPoolArn(final software.amazon.awscdk.Token value) {
                        this.$userPoolArn = java.util.Objects.requireNonNull(value, "userPoolArn is required");
                    }

                    @Override
                    public java.lang.Object getUserPoolClientId() {
                        return this.$userPoolClientId;
                    }

                    @Override
                    public void setUserPoolClientId(final java.lang.String value) {
                        this.$userPoolClientId = java.util.Objects.requireNonNull(value, "userPoolClientId is required");
                    }

                    @Override
                    public void setUserPoolClientId(final software.amazon.awscdk.Token value) {
                        this.$userPoolClientId = java.util.Objects.requireNonNull(value, "userPoolClientId is required");
                    }

                    @Override
                    public java.lang.Object getUserPoolDomain() {
                        return this.$userPoolDomain;
                    }

                    @Override
                    public void setUserPoolDomain(final java.lang.String value) {
                        this.$userPoolDomain = java.util.Objects.requireNonNull(value, "userPoolDomain is required");
                    }

                    @Override
                    public void setUserPoolDomain(final software.amazon.awscdk.Token value) {
                        this.$userPoolDomain = java.util.Objects.requireNonNull(value, "userPoolDomain is required");
                    }

                    @Override
                    public java.lang.Object getAuthenticationRequestExtraParams() {
                        return this.$authenticationRequestExtraParams;
                    }

                    @Override
                    public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$authenticationRequestExtraParams = value;
                    }

                    @Override
                    public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$authenticationRequestExtraParams = value;
                    }

                    @Override
                    public java.lang.Object getOnUnauthenticatedRequest() {
                        return this.$onUnauthenticatedRequest;
                    }

                    @Override
                    public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                        this.$onUnauthenticatedRequest = value;
                    }

                    @Override
                    public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$onUnauthenticatedRequest = value;
                    }

                    @Override
                    public java.lang.Object getScope() {
                        return this.$scope;
                    }

                    @Override
                    public void setScope(@javax.annotation.Nullable final java.lang.String value) {
                        this.$scope = value;
                    }

                    @Override
                    public void setScope(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$scope = value;
                    }

                    @Override
                    public java.lang.Object getSessionCookieName() {
                        return this.$sessionCookieName;
                    }

                    @Override
                    public void setSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sessionCookieName = value;
                    }

                    @Override
                    public void setSessionCookieName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sessionCookieName = value;
                    }

                    @Override
                    public java.lang.Object getSessionTimeout() {
                        return this.$sessionTimeout;
                    }

                    @Override
                    public void setSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$sessionTimeout = value;
                    }

                    @Override
                    public void setSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sessionTimeout = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateCognitoConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
             */
            @Override
            public java.lang.Object getUserPoolArn() {
                return this.jsiiGet("userPoolArn", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
             */
            @Override
            public void setUserPoolArn(final java.lang.String value) {
                this.jsiiSet("userPoolArn", java.util.Objects.requireNonNull(value, "userPoolArn is required"));
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
             */
            @Override
            public void setUserPoolArn(final software.amazon.awscdk.Token value) {
                this.jsiiSet("userPoolArn", java.util.Objects.requireNonNull(value, "userPoolArn is required"));
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
             */
            @Override
            public java.lang.Object getUserPoolClientId() {
                return this.jsiiGet("userPoolClientId", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
             */
            @Override
            public void setUserPoolClientId(final java.lang.String value) {
                this.jsiiSet("userPoolClientId", java.util.Objects.requireNonNull(value, "userPoolClientId is required"));
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolClientId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
             */
            @Override
            public void setUserPoolClientId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("userPoolClientId", java.util.Objects.requireNonNull(value, "userPoolClientId is required"));
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
             */
            @Override
            public java.lang.Object getUserPoolDomain() {
                return this.jsiiGet("userPoolDomain", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
             */
            @Override
            public void setUserPoolDomain(final java.lang.String value) {
                this.jsiiSet("userPoolDomain", java.util.Objects.requireNonNull(value, "userPoolDomain is required"));
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.UserPoolDomain``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
             */
            @Override
            public void setUserPoolDomain(final software.amazon.awscdk.Token value) {
                this.jsiiSet("userPoolDomain", java.util.Objects.requireNonNull(value, "userPoolDomain is required"));
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
             */
            @Override
            public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("authenticationRequestExtraParams", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
             */
            @Override
            public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("authenticationRequestExtraParams", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOnUnauthenticatedRequest() {
                return this.jsiiGet("onUnauthenticatedRequest", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
             */
            @Override
            public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("onUnauthenticatedRequest", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
             */
            @Override
            public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("onUnauthenticatedRequest", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getScope() {
                return this.jsiiGet("scope", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
             */
            @Override
            public void setScope(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("scope", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.Scope``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
             */
            @Override
            public void setScope(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("scope", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSessionCookieName() {
                return this.jsiiGet("sessionCookieName", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
             */
            @Override
            public void setSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sessionCookieName", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionCookieName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
             */
            @Override
            public void setSessionCookieName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sessionCookieName", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSessionTimeout() {
                return this.jsiiGet("sessionTimeout", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
             */
            @Override
            public void setSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("sessionTimeout", value);
            }

            /**
             * ``ListenerResource.AuthenticateCognitoConfigProperty.SessionTimeout``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
             */
            @Override
            public void setSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sessionTimeout", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html
     */
    public static interface AuthenticateOidcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
         */
        java.lang.Object getAuthorizationEndpoint();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
         */
        void setAuthorizationEndpoint(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
         */
        void setAuthorizationEndpoint(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
         */
        java.lang.Object getClientId();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
         */
        void setClientId(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
         */
        void setClientId(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
         */
        java.lang.Object getClientSecret();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
         */
        void setClientSecret(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
         */
        void setClientSecret(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
         */
        java.lang.Object getIssuer();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
         */
        void setIssuer(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
         */
        void setIssuer(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
         */
        java.lang.Object getTokenEndpoint();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
         */
        void setTokenEndpoint(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
         */
        void setTokenEndpoint(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
         */
        java.lang.Object getUserInfoEndpoint();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
         */
        void setUserInfoEndpoint(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
         */
        void setUserInfoEndpoint(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
         */
        java.lang.Object getAuthenticationRequestExtraParams();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
         */
        void setAuthenticationRequestExtraParams(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
         */
        void setAuthenticationRequestExtraParams(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
         */
        java.lang.Object getOnUnauthenticatedRequest();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
         */
        void setOnUnauthenticatedRequest(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
         */
        void setOnUnauthenticatedRequest(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
         */
        java.lang.Object getScope();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
         */
        void setScope(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
         */
        void setScope(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
         */
        java.lang.Object getSessionCookieName();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
         */
        void setSessionCookieName(final java.lang.String value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
         */
        void setSessionCookieName(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
         */
        java.lang.Object getSessionTimeout();
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
         */
        void setSessionTimeout(final java.lang.Number value);
        /**
         * ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
         */
        void setSessionTimeout(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link AuthenticateOidcConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AuthenticateOidcConfigProperty}
         */
        final class Builder {
            private java.lang.Object _authorizationEndpoint;
            private java.lang.Object _clientId;
            private java.lang.Object _clientSecret;
            private java.lang.Object _issuer;
            private java.lang.Object _tokenEndpoint;
            private java.lang.Object _userInfoEndpoint;
            @javax.annotation.Nullable
            private java.lang.Object _authenticationRequestExtraParams;
            @javax.annotation.Nullable
            private java.lang.Object _onUnauthenticatedRequest;
            @javax.annotation.Nullable
            private java.lang.Object _scope;
            @javax.annotation.Nullable
            private java.lang.Object _sessionCookieName;
            @javax.annotation.Nullable
            private java.lang.Object _sessionTimeout;

            /**
             * Sets the value of AuthorizationEndpoint
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
             * @return {@code this}
             */
            public Builder withAuthorizationEndpoint(final java.lang.String value) {
                this._authorizationEndpoint = java.util.Objects.requireNonNull(value, "authorizationEndpoint is required");
                return this;
            }
            /**
             * Sets the value of AuthorizationEndpoint
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
             * @return {@code this}
             */
            public Builder withAuthorizationEndpoint(final software.amazon.awscdk.Token value) {
                this._authorizationEndpoint = java.util.Objects.requireNonNull(value, "authorizationEndpoint is required");
                return this;
            }
            /**
             * Sets the value of ClientId
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
             * @return {@code this}
             */
            public Builder withClientId(final java.lang.String value) {
                this._clientId = java.util.Objects.requireNonNull(value, "clientId is required");
                return this;
            }
            /**
             * Sets the value of ClientId
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
             * @return {@code this}
             */
            public Builder withClientId(final software.amazon.awscdk.Token value) {
                this._clientId = java.util.Objects.requireNonNull(value, "clientId is required");
                return this;
            }
            /**
             * Sets the value of ClientSecret
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
             * @return {@code this}
             */
            public Builder withClientSecret(final java.lang.String value) {
                this._clientSecret = java.util.Objects.requireNonNull(value, "clientSecret is required");
                return this;
            }
            /**
             * Sets the value of ClientSecret
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
             * @return {@code this}
             */
            public Builder withClientSecret(final software.amazon.awscdk.Token value) {
                this._clientSecret = java.util.Objects.requireNonNull(value, "clientSecret is required");
                return this;
            }
            /**
             * Sets the value of Issuer
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
             * @return {@code this}
             */
            public Builder withIssuer(final java.lang.String value) {
                this._issuer = java.util.Objects.requireNonNull(value, "issuer is required");
                return this;
            }
            /**
             * Sets the value of Issuer
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
             * @return {@code this}
             */
            public Builder withIssuer(final software.amazon.awscdk.Token value) {
                this._issuer = java.util.Objects.requireNonNull(value, "issuer is required");
                return this;
            }
            /**
             * Sets the value of TokenEndpoint
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
             * @return {@code this}
             */
            public Builder withTokenEndpoint(final java.lang.String value) {
                this._tokenEndpoint = java.util.Objects.requireNonNull(value, "tokenEndpoint is required");
                return this;
            }
            /**
             * Sets the value of TokenEndpoint
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
             * @return {@code this}
             */
            public Builder withTokenEndpoint(final software.amazon.awscdk.Token value) {
                this._tokenEndpoint = java.util.Objects.requireNonNull(value, "tokenEndpoint is required");
                return this;
            }
            /**
             * Sets the value of UserInfoEndpoint
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
             * @return {@code this}
             */
            public Builder withUserInfoEndpoint(final java.lang.String value) {
                this._userInfoEndpoint = java.util.Objects.requireNonNull(value, "userInfoEndpoint is required");
                return this;
            }
            /**
             * Sets the value of UserInfoEndpoint
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
             * @return {@code this}
             */
            public Builder withUserInfoEndpoint(final software.amazon.awscdk.Token value) {
                this._userInfoEndpoint = java.util.Objects.requireNonNull(value, "userInfoEndpoint is required");
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
             * @return {@code this}
             */
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
             * @return {@code this}
             */
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
             * @return {@code this}
             */
            public Builder withScope(@javax.annotation.Nullable final java.lang.String value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
             * @return {@code this}
             */
            public Builder withScope(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
             * @return {@code this}
             */
            public Builder withSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
             * @return {@code this}
             */
            public Builder withSessionCookieName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this._sessionTimeout = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sessionTimeout = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateOidcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AuthenticateOidcConfigProperty build() {
                return new AuthenticateOidcConfigProperty() {
                    private java.lang.Object $authorizationEndpoint = java.util.Objects.requireNonNull(_authorizationEndpoint, "authorizationEndpoint is required");
                    private java.lang.Object $clientId = java.util.Objects.requireNonNull(_clientId, "clientId is required");
                    private java.lang.Object $clientSecret = java.util.Objects.requireNonNull(_clientSecret, "clientSecret is required");
                    private java.lang.Object $issuer = java.util.Objects.requireNonNull(_issuer, "issuer is required");
                    private java.lang.Object $tokenEndpoint = java.util.Objects.requireNonNull(_tokenEndpoint, "tokenEndpoint is required");
                    private java.lang.Object $userInfoEndpoint = java.util.Objects.requireNonNull(_userInfoEndpoint, "userInfoEndpoint is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $authenticationRequestExtraParams = _authenticationRequestExtraParams;
                    @javax.annotation.Nullable
                    private java.lang.Object $onUnauthenticatedRequest = _onUnauthenticatedRequest;
                    @javax.annotation.Nullable
                    private java.lang.Object $scope = _scope;
                    @javax.annotation.Nullable
                    private java.lang.Object $sessionCookieName = _sessionCookieName;
                    @javax.annotation.Nullable
                    private java.lang.Object $sessionTimeout = _sessionTimeout;

                    @Override
                    public java.lang.Object getAuthorizationEndpoint() {
                        return this.$authorizationEndpoint;
                    }

                    @Override
                    public void setAuthorizationEndpoint(final java.lang.String value) {
                        this.$authorizationEndpoint = java.util.Objects.requireNonNull(value, "authorizationEndpoint is required");
                    }

                    @Override
                    public void setAuthorizationEndpoint(final software.amazon.awscdk.Token value) {
                        this.$authorizationEndpoint = java.util.Objects.requireNonNull(value, "authorizationEndpoint is required");
                    }

                    @Override
                    public java.lang.Object getClientId() {
                        return this.$clientId;
                    }

                    @Override
                    public void setClientId(final java.lang.String value) {
                        this.$clientId = java.util.Objects.requireNonNull(value, "clientId is required");
                    }

                    @Override
                    public void setClientId(final software.amazon.awscdk.Token value) {
                        this.$clientId = java.util.Objects.requireNonNull(value, "clientId is required");
                    }

                    @Override
                    public java.lang.Object getClientSecret() {
                        return this.$clientSecret;
                    }

                    @Override
                    public void setClientSecret(final java.lang.String value) {
                        this.$clientSecret = java.util.Objects.requireNonNull(value, "clientSecret is required");
                    }

                    @Override
                    public void setClientSecret(final software.amazon.awscdk.Token value) {
                        this.$clientSecret = java.util.Objects.requireNonNull(value, "clientSecret is required");
                    }

                    @Override
                    public java.lang.Object getIssuer() {
                        return this.$issuer;
                    }

                    @Override
                    public void setIssuer(final java.lang.String value) {
                        this.$issuer = java.util.Objects.requireNonNull(value, "issuer is required");
                    }

                    @Override
                    public void setIssuer(final software.amazon.awscdk.Token value) {
                        this.$issuer = java.util.Objects.requireNonNull(value, "issuer is required");
                    }

                    @Override
                    public java.lang.Object getTokenEndpoint() {
                        return this.$tokenEndpoint;
                    }

                    @Override
                    public void setTokenEndpoint(final java.lang.String value) {
                        this.$tokenEndpoint = java.util.Objects.requireNonNull(value, "tokenEndpoint is required");
                    }

                    @Override
                    public void setTokenEndpoint(final software.amazon.awscdk.Token value) {
                        this.$tokenEndpoint = java.util.Objects.requireNonNull(value, "tokenEndpoint is required");
                    }

                    @Override
                    public java.lang.Object getUserInfoEndpoint() {
                        return this.$userInfoEndpoint;
                    }

                    @Override
                    public void setUserInfoEndpoint(final java.lang.String value) {
                        this.$userInfoEndpoint = java.util.Objects.requireNonNull(value, "userInfoEndpoint is required");
                    }

                    @Override
                    public void setUserInfoEndpoint(final software.amazon.awscdk.Token value) {
                        this.$userInfoEndpoint = java.util.Objects.requireNonNull(value, "userInfoEndpoint is required");
                    }

                    @Override
                    public java.lang.Object getAuthenticationRequestExtraParams() {
                        return this.$authenticationRequestExtraParams;
                    }

                    @Override
                    public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$authenticationRequestExtraParams = value;
                    }

                    @Override
                    public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$authenticationRequestExtraParams = value;
                    }

                    @Override
                    public java.lang.Object getOnUnauthenticatedRequest() {
                        return this.$onUnauthenticatedRequest;
                    }

                    @Override
                    public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                        this.$onUnauthenticatedRequest = value;
                    }

                    @Override
                    public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$onUnauthenticatedRequest = value;
                    }

                    @Override
                    public java.lang.Object getScope() {
                        return this.$scope;
                    }

                    @Override
                    public void setScope(@javax.annotation.Nullable final java.lang.String value) {
                        this.$scope = value;
                    }

                    @Override
                    public void setScope(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$scope = value;
                    }

                    @Override
                    public java.lang.Object getSessionCookieName() {
                        return this.$sessionCookieName;
                    }

                    @Override
                    public void setSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                        this.$sessionCookieName = value;
                    }

                    @Override
                    public void setSessionCookieName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sessionCookieName = value;
                    }

                    @Override
                    public java.lang.Object getSessionTimeout() {
                        return this.$sessionTimeout;
                    }

                    @Override
                    public void setSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                        this.$sessionTimeout = value;
                    }

                    @Override
                    public void setSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$sessionTimeout = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.AuthenticateOidcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
             */
            @Override
            public java.lang.Object getAuthorizationEndpoint() {
                return this.jsiiGet("authorizationEndpoint", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
             */
            @Override
            public void setAuthorizationEndpoint(final java.lang.String value) {
                this.jsiiSet("authorizationEndpoint", java.util.Objects.requireNonNull(value, "authorizationEndpoint is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.AuthorizationEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
             */
            @Override
            public void setAuthorizationEndpoint(final software.amazon.awscdk.Token value) {
                this.jsiiSet("authorizationEndpoint", java.util.Objects.requireNonNull(value, "authorizationEndpoint is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
             */
            @Override
            public java.lang.Object getClientId() {
                return this.jsiiGet("clientId", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
             */
            @Override
            public void setClientId(final java.lang.String value) {
                this.jsiiSet("clientId", java.util.Objects.requireNonNull(value, "clientId is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.ClientId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
             */
            @Override
            public void setClientId(final software.amazon.awscdk.Token value) {
                this.jsiiSet("clientId", java.util.Objects.requireNonNull(value, "clientId is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
             */
            @Override
            public java.lang.Object getClientSecret() {
                return this.jsiiGet("clientSecret", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
             */
            @Override
            public void setClientSecret(final java.lang.String value) {
                this.jsiiSet("clientSecret", java.util.Objects.requireNonNull(value, "clientSecret is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.ClientSecret``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
             */
            @Override
            public void setClientSecret(final software.amazon.awscdk.Token value) {
                this.jsiiSet("clientSecret", java.util.Objects.requireNonNull(value, "clientSecret is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
             */
            @Override
            public java.lang.Object getIssuer() {
                return this.jsiiGet("issuer", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
             */
            @Override
            public void setIssuer(final java.lang.String value) {
                this.jsiiSet("issuer", java.util.Objects.requireNonNull(value, "issuer is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.Issuer``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
             */
            @Override
            public void setIssuer(final software.amazon.awscdk.Token value) {
                this.jsiiSet("issuer", java.util.Objects.requireNonNull(value, "issuer is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
             */
            @Override
            public java.lang.Object getTokenEndpoint() {
                return this.jsiiGet("tokenEndpoint", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
             */
            @Override
            public void setTokenEndpoint(final java.lang.String value) {
                this.jsiiSet("tokenEndpoint", java.util.Objects.requireNonNull(value, "tokenEndpoint is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.TokenEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
             */
            @Override
            public void setTokenEndpoint(final software.amazon.awscdk.Token value) {
                this.jsiiSet("tokenEndpoint", java.util.Objects.requireNonNull(value, "tokenEndpoint is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
             */
            @Override
            public java.lang.Object getUserInfoEndpoint() {
                return this.jsiiGet("userInfoEndpoint", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
             */
            @Override
            public void setUserInfoEndpoint(final java.lang.String value) {
                this.jsiiSet("userInfoEndpoint", java.util.Objects.requireNonNull(value, "userInfoEndpoint is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.UserInfoEndpoint``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
             */
            @Override
            public void setUserInfoEndpoint(final software.amazon.awscdk.Token value) {
                this.jsiiSet("userInfoEndpoint", java.util.Objects.requireNonNull(value, "userInfoEndpoint is required"));
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
             */
            @Override
            public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("authenticationRequestExtraParams", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
             */
            @Override
            public void setAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("authenticationRequestExtraParams", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOnUnauthenticatedRequest() {
                return this.jsiiGet("onUnauthenticatedRequest", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
             */
            @Override
            public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("onUnauthenticatedRequest", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
             */
            @Override
            public void setOnUnauthenticatedRequest(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("onUnauthenticatedRequest", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getScope() {
                return this.jsiiGet("scope", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
             */
            @Override
            public void setScope(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("scope", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.Scope``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
             */
            @Override
            public void setScope(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("scope", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSessionCookieName() {
                return this.jsiiGet("sessionCookieName", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
             */
            @Override
            public void setSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("sessionCookieName", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.SessionCookieName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
             */
            @Override
            public void setSessionCookieName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sessionCookieName", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSessionTimeout() {
                return this.jsiiGet("sessionTimeout", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
             */
            @Override
            public void setSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("sessionTimeout", value);
            }

            /**
             * ``ListenerResource.AuthenticateOidcConfigProperty.SessionTimeout``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
             */
            @Override
            public void setSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("sessionTimeout", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html
     */
    public static interface CertificateProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.CertificateProperty.CertificateArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        java.lang.Object getCertificateArn();
        /**
         * ``ListenerResource.CertificateProperty.CertificateArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        void setCertificateArn(final java.lang.String value);
        /**
         * ``ListenerResource.CertificateProperty.CertificateArn``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        void setCertificateArn(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link CertificateProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CertificateProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _certificateArn;

            /**
             * Sets the value of CertificateArn
             * @param value ``ListenerResource.CertificateProperty.CertificateArn``
             * @return {@code this}
             */
            public Builder withCertificateArn(@javax.annotation.Nullable final java.lang.String value) {
                this._certificateArn = value;
                return this;
            }
            /**
             * Sets the value of CertificateArn
             * @param value ``ListenerResource.CertificateProperty.CertificateArn``
             * @return {@code this}
             */
            public Builder withCertificateArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._certificateArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CertificateProperty build() {
                return new CertificateProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $certificateArn = _certificateArn;

                    @Override
                    public java.lang.Object getCertificateArn() {
                        return this.$certificateArn;
                    }

                    @Override
                    public void setCertificateArn(@javax.annotation.Nullable final java.lang.String value) {
                        this.$certificateArn = value;
                    }

                    @Override
                    public void setCertificateArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$certificateArn = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.CertificateProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCertificateArn() {
                return this.jsiiGet("certificateArn", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            @Override
            public void setCertificateArn(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("certificateArn", value);
            }

            /**
             * ``ListenerResource.CertificateProperty.CertificateArn``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            @Override
            public void setCertificateArn(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("certificateArn", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html
     */
    public static interface FixedResponseConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.FixedResponseConfigProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
         */
        java.lang.Object getStatusCode();
        /**
         * ``ListenerResource.FixedResponseConfigProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
         */
        void setStatusCode(final java.lang.String value);
        /**
         * ``ListenerResource.FixedResponseConfigProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
         */
        void setStatusCode(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.FixedResponseConfigProperty.ContentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
         */
        java.lang.Object getContentType();
        /**
         * ``ListenerResource.FixedResponseConfigProperty.ContentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
         */
        void setContentType(final java.lang.String value);
        /**
         * ``ListenerResource.FixedResponseConfigProperty.ContentType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
         */
        void setContentType(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.FixedResponseConfigProperty.MessageBody``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
         */
        java.lang.Object getMessageBody();
        /**
         * ``ListenerResource.FixedResponseConfigProperty.MessageBody``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
         */
        void setMessageBody(final java.lang.String value);
        /**
         * ``ListenerResource.FixedResponseConfigProperty.MessageBody``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
         */
        void setMessageBody(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link FixedResponseConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FixedResponseConfigProperty}
         */
        final class Builder {
            private java.lang.Object _statusCode;
            @javax.annotation.Nullable
            private java.lang.Object _contentType;
            @javax.annotation.Nullable
            private java.lang.Object _messageBody;

            /**
             * Sets the value of StatusCode
             * @param value ``ListenerResource.FixedResponseConfigProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of StatusCode
             * @param value ``ListenerResource.FixedResponseConfigProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final software.amazon.awscdk.Token value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of ContentType
             * @param value ``ListenerResource.FixedResponseConfigProperty.ContentType``
             * @return {@code this}
             */
            public Builder withContentType(@javax.annotation.Nullable final java.lang.String value) {
                this._contentType = value;
                return this;
            }
            /**
             * Sets the value of ContentType
             * @param value ``ListenerResource.FixedResponseConfigProperty.ContentType``
             * @return {@code this}
             */
            public Builder withContentType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._contentType = value;
                return this;
            }
            /**
             * Sets the value of MessageBody
             * @param value ``ListenerResource.FixedResponseConfigProperty.MessageBody``
             * @return {@code this}
             */
            public Builder withMessageBody(@javax.annotation.Nullable final java.lang.String value) {
                this._messageBody = value;
                return this;
            }
            /**
             * Sets the value of MessageBody
             * @param value ``ListenerResource.FixedResponseConfigProperty.MessageBody``
             * @return {@code this}
             */
            public Builder withMessageBody(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._messageBody = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedResponseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FixedResponseConfigProperty build() {
                return new FixedResponseConfigProperty() {
                    private java.lang.Object $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $contentType = _contentType;
                    @javax.annotation.Nullable
                    private java.lang.Object $messageBody = _messageBody;

                    @Override
                    public java.lang.Object getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public void setStatusCode(final java.lang.String value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public void setStatusCode(final software.amazon.awscdk.Token value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public java.lang.Object getContentType() {
                        return this.$contentType;
                    }

                    @Override
                    public void setContentType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$contentType = value;
                    }

                    @Override
                    public void setContentType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$contentType = value;
                    }

                    @Override
                    public java.lang.Object getMessageBody() {
                        return this.$messageBody;
                    }

                    @Override
                    public void setMessageBody(@javax.annotation.Nullable final java.lang.String value) {
                        this.$messageBody = value;
                    }

                    @Override
                    public void setMessageBody(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$messageBody = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.FixedResponseConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
             */
            @Override
            public java.lang.Object getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
             */
            @Override
            public void setStatusCode(final java.lang.String value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
             */
            @Override
            public void setStatusCode(final software.amazon.awscdk.Token value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.ContentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getContentType() {
                return this.jsiiGet("contentType", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.ContentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
             */
            @Override
            public void setContentType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("contentType", value);
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.ContentType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
             */
            @Override
            public void setContentType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("contentType", value);
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.MessageBody``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getMessageBody() {
                return this.jsiiGet("messageBody", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.MessageBody``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
             */
            @Override
            public void setMessageBody(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("messageBody", value);
            }

            /**
             * ``ListenerResource.FixedResponseConfigProperty.MessageBody``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
             */
            @Override
            public void setMessageBody(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("messageBody", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html
     */
    public static interface RedirectConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ListenerResource.RedirectConfigProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
         */
        java.lang.Object getStatusCode();
        /**
         * ``ListenerResource.RedirectConfigProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
         */
        void setStatusCode(final java.lang.String value);
        /**
         * ``ListenerResource.RedirectConfigProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
         */
        void setStatusCode(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Host``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
         */
        java.lang.Object getHost();
        /**
         * ``ListenerResource.RedirectConfigProperty.Host``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
         */
        void setHost(final java.lang.String value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Host``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
         */
        void setHost(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
         */
        java.lang.Object getPath();
        /**
         * ``ListenerResource.RedirectConfigProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
         */
        void setPath(final java.lang.String value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
         */
        void setPath(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Port``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
         */
        java.lang.Object getPort();
        /**
         * ``ListenerResource.RedirectConfigProperty.Port``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
         */
        void setPort(final java.lang.String value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Port``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
         */
        void setPort(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
         */
        java.lang.Object getProtocol();
        /**
         * ``ListenerResource.RedirectConfigProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
         */
        void setProtocol(final java.lang.String value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Protocol``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
         */
        void setProtocol(final software.amazon.awscdk.Token value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Query``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
         */
        java.lang.Object getQuery();
        /**
         * ``ListenerResource.RedirectConfigProperty.Query``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
         */
        void setQuery(final java.lang.String value);
        /**
         * ``ListenerResource.RedirectConfigProperty.Query``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
         */
        void setQuery(final software.amazon.awscdk.Token value);

        /**
         * @return a {@link Builder} of {@link RedirectConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectConfigProperty}
         */
        final class Builder {
            private java.lang.Object _statusCode;
            @javax.annotation.Nullable
            private java.lang.Object _host;
            @javax.annotation.Nullable
            private java.lang.Object _path;
            @javax.annotation.Nullable
            private java.lang.Object _port;
            @javax.annotation.Nullable
            private java.lang.Object _protocol;
            @javax.annotation.Nullable
            private java.lang.Object _query;

            /**
             * Sets the value of StatusCode
             * @param value ``ListenerResource.RedirectConfigProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of StatusCode
             * @param value ``ListenerResource.RedirectConfigProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final software.amazon.awscdk.Token value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of Host
             * @param value ``ListenerResource.RedirectConfigProperty.Host``
             * @return {@code this}
             */
            public Builder withHost(@javax.annotation.Nullable final java.lang.String value) {
                this._host = value;
                return this;
            }
            /**
             * Sets the value of Host
             * @param value ``ListenerResource.RedirectConfigProperty.Host``
             * @return {@code this}
             */
            public Builder withHost(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._host = value;
                return this;
            }
            /**
             * Sets the value of Path
             * @param value ``ListenerResource.RedirectConfigProperty.Path``
             * @return {@code this}
             */
            public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
                this._path = value;
                return this;
            }
            /**
             * Sets the value of Path
             * @param value ``ListenerResource.RedirectConfigProperty.Path``
             * @return {@code this}
             */
            public Builder withPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._path = value;
                return this;
            }
            /**
             * Sets the value of Port
             * @param value ``ListenerResource.RedirectConfigProperty.Port``
             * @return {@code this}
             */
            public Builder withPort(@javax.annotation.Nullable final java.lang.String value) {
                this._port = value;
                return this;
            }
            /**
             * Sets the value of Port
             * @param value ``ListenerResource.RedirectConfigProperty.Port``
             * @return {@code this}
             */
            public Builder withPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._port = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``ListenerResource.RedirectConfigProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value ``ListenerResource.RedirectConfigProperty.Protocol``
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of Query
             * @param value ``ListenerResource.RedirectConfigProperty.Query``
             * @return {@code this}
             */
            public Builder withQuery(@javax.annotation.Nullable final java.lang.String value) {
                this._query = value;
                return this;
            }
            /**
             * Sets the value of Query
             * @param value ``ListenerResource.RedirectConfigProperty.Query``
             * @return {@code this}
             */
            public Builder withQuery(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._query = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectConfigProperty build() {
                return new RedirectConfigProperty() {
                    private java.lang.Object $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $host = _host;
                    @javax.annotation.Nullable
                    private java.lang.Object $path = _path;
                    @javax.annotation.Nullable
                    private java.lang.Object $port = _port;
                    @javax.annotation.Nullable
                    private java.lang.Object $protocol = _protocol;
                    @javax.annotation.Nullable
                    private java.lang.Object $query = _query;

                    @Override
                    public java.lang.Object getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public void setStatusCode(final java.lang.String value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public void setStatusCode(final software.amazon.awscdk.Token value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public java.lang.Object getHost() {
                        return this.$host;
                    }

                    @Override
                    public void setHost(@javax.annotation.Nullable final java.lang.String value) {
                        this.$host = value;
                    }

                    @Override
                    public void setHost(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$host = value;
                    }

                    @Override
                    public java.lang.Object getPath() {
                        return this.$path;
                    }

                    @Override
                    public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                        this.$path = value;
                    }

                    @Override
                    public void setPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$path = value;
                    }

                    @Override
                    public java.lang.Object getPort() {
                        return this.$port;
                    }

                    @Override
                    public void setPort(@javax.annotation.Nullable final java.lang.String value) {
                        this.$port = value;
                    }

                    @Override
                    public void setPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$port = value;
                    }

                    @Override
                    public java.lang.Object getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                        this.$protocol = value;
                    }

                    @Override
                    public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$protocol = value;
                    }

                    @Override
                    public java.lang.Object getQuery() {
                        return this.$query;
                    }

                    @Override
                    public void setQuery(@javax.annotation.Nullable final java.lang.String value) {
                        this.$query = value;
                    }

                    @Override
                    public void setQuery(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                        this.$query = value;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.cloudformation.ListenerResource.RedirectConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
             */
            @Override
            public java.lang.Object getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
             */
            @Override
            public void setStatusCode(final java.lang.String value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
             */
            @Override
            public void setStatusCode(final software.amazon.awscdk.Token value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Host``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getHost() {
                return this.jsiiGet("host", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Host``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
             */
            @Override
            public void setHost(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("host", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Host``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
             */
            @Override
            public void setHost(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("host", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPath() {
                return this.jsiiGet("path", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
             */
            @Override
            public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("path", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
             */
            @Override
            public void setPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("path", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Port``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPort() {
                return this.jsiiGet("port", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Port``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
             */
            @Override
            public void setPort(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("port", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Port``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
             */
            @Override
            public void setPort(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("port", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getProtocol() {
                return this.jsiiGet("protocol", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("protocol", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Protocol``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
             */
            @Override
            public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("protocol", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Query``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getQuery() {
                return this.jsiiGet("query", java.lang.Object.class);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Query``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
             */
            @Override
            public void setQuery(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("query", value);
            }

            /**
             * ``ListenerResource.RedirectConfigProperty.Query``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
             */
            @Override
            public void setQuery(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("query", value);
            }
        }
    }
}
