package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an Application Target Group
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.12 (build 82990c5)", date = "2018-12-20T13:33:38.501Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.ApplicationTargetGroup")
public class ApplicationTargetGroup extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroup {
    protected ApplicationTargetGroup(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public ApplicationTargetGroup(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Import an existing target group
     */
    public static software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup import_(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupRefProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class, "import", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Add a load balancing target to this target group
     */
    public void addTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget... targets) {
        this.jsiiCall("addTarget", Void.class, java.util.Arrays.stream(java.util.Objects.requireNonNull(targets, "targets is required")).toArray());
    }

    /**
     * Enable sticky routing via a cookie to members of this target group
     */
    public void enableCookieStickiness(final java.lang.Number durationSec) {
        this.jsiiCall("enableCookieStickiness", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(durationSec, "durationSec is required")).toArray());
    }

    /**
     * Return the given named metric for this Application Load Balancer Target Group
     * 
     * Returns the metric for this target group from the point of view of the first
     * load balancer load balancing to it. If you have multiple load balancers load
     * sending traffic to the same target group, you will have to override the dimensions
     * on this metric.
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * Return the given named metric for this Application Load Balancer Target Group
     * 
     * Returns the metric for this target group from the point of view of the first
     * load balancer load balancing to it. If you have multiple load balancers load
     * sending traffic to the same target group, you will have to override the dimensions
     * on this metric.
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metric(final java.lang.String metricName) {
        return this.jsiiCall("metric", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(metricName, "metricName is required")).toArray());
    }

    /**
     * The number of healthy hosts in the target group
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The number of healthy hosts in the target group
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricHealthyHostCount() {
        return this.jsiiCall("metricHealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in this target group.
     * 
     * This does not include any response codes generated by the load balancer.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code, @javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricHttpCodeTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(code, "code is required")), java.util.stream.Stream.of(props)).toArray());
    }

    /**
     * The number of HTTP 2xx/3xx/4xx/5xx response codes generated by all targets in this target group.
     * 
     * This does not include any response codes generated by the load balancer.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricHttpCodeTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.HttpCodeTarget code) {
        return this.jsiiCall("metricHttpCodeTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(code, "code is required")).toArray());
    }

    /**
     * The number of IPv6 requests received by the target group
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricIPv6RequestCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricIPv6RequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The number of IPv6 requests received by the target group
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricIPv6RequestCount() {
        return this.jsiiCall("metricIPv6RequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * 
     * This count includes only the requests with a response generated by a target of the load balancer.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricRequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The number of requests processed over IPv4 and IPv6.
     * 
     * This count includes only the requests with a response generated by a target of the load balancer.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCount() {
        return this.jsiiCall("metricRequestCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The average number of requests received by each target in a target group.
     * 
     * The only valid statistic is Sum. Note that this represents the average not the sum.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCountPerTarget(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricRequestCountPerTarget", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The average number of requests received by each target in a target group.
     * 
     * The only valid statistic is Sum. Note that this represents the average not the sum.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricRequestCountPerTarget() {
        return this.jsiiCall("metricRequestCountPerTarget", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricTargetConnectionErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The number of connections that were not successfully established between the load balancer and target.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetConnectionErrorCount() {
        return this.jsiiCall("metricTargetConnectionErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricTargetResponseTime", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The time elapsed, in seconds, after the request leaves the load balancer until a response from the target is received.
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetResponseTime() {
        return this.jsiiCall("metricTargetResponseTime", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * 
     * Possible causes include a mismatch of ciphers or protocols.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricTargetTLSNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The number of TLS connections initiated by the load balancer that did not establish a session with the target.
     * 
     * Possible causes include a mismatch of ciphers or protocols.
     * @default Sum over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricTargetTLSNegotiationErrorCount() {
        return this.jsiiCall("metricTargetTLSNegotiationErrorCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * The number of unhealthy hosts in the target group
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricUnhealthyHostCount(@javax.annotation.Nullable final software.amazon.awscdk.services.cloudwatch.MetricCustomization props) {
        return this.jsiiCall("metricUnhealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class, java.util.stream.Stream.of(props).toArray());
    }

    /**
     * The number of unhealthy hosts in the target group
     * @default Average over 5 minutes
     */
    public software.amazon.awscdk.services.cloudwatch.Metric metricUnhealthyHostCount() {
        return this.jsiiCall("metricUnhealthyHostCount", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Register a connectable as a member of this target group.
     * 
     * Don't call this directly. It will be called by load balancing targets.
     */
    public void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable, @javax.annotation.Nullable final software.amazon.awscdk.services.ec2.IPortRange portRange) {
        this.jsiiCall("registerConnectable", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(connectable, "connectable is required")), java.util.stream.Stream.of(portRange)).toArray());
    }

    /**
     * Register a connectable as a member of this target group.
     * 
     * Don't call this directly. It will be called by load balancing targets.
     */
    public void registerConnectable(final software.amazon.awscdk.services.ec2.IConnectable connectable) {
        this.jsiiCall("registerConnectable", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(connectable, "connectable is required")).toArray());
    }

    /**
     * Register a listener that is load balancing to this target group.
     * 
     * Don't call this directly. It will be called by listeners.
     */
    public void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener, @javax.annotation.Nullable final software.amazon.awscdk.IDependable dependable) {
        this.jsiiCall("registerListener", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(listener, "listener is required")), java.util.stream.Stream.of(dependable)).toArray());
    }

    /**
     * Register a listener that is load balancing to this target group.
     * 
     * Don't call this directly. It will be called by listeners.
     */
    public void registerListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
        this.jsiiCall("registerListener", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(listener, "listener is required")).toArray());
    }

    /**
     * Full name of first load balancer
     */
    @Override
    public java.lang.String getFirstLoadBalancerFullName() {
        return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
    }
}
