package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for an ApplicationListener
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.13 (build 311bf88)", date = "2019-01-11T10:50:35.094Z")
public interface BaseApplicationListenerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The certificates to use on this listener
     */
    java.util.List<java.lang.String> getCertificateArns();
    /**
     * The certificates to use on this listener
     */
    void setCertificateArns(final java.util.List<java.lang.String> value);
    /**
     * Default target groups to load balance to
     * @default None
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups();
    /**
     * Default target groups to load balance to
     * @default None
     */
    void setDefaultTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value);
    /**
     * Allow anyone to connect to this listener
     * 
     * If this is specified, the listener will be opened up to anyone who can reach it.
     * For internal load balancers this is anyone in the same VPC. For public load
     * balancers, this is anyone on the internet.
     * 
     * If you want to be more selective about who can access this load
     * balancer, set this to `false` and use the listener's `connections`
     * object to selectively grant access to the listener.
     * @default true
     */
    java.lang.Boolean getOpen();
    /**
     * Allow anyone to connect to this listener
     * 
     * If this is specified, the listener will be opened up to anyone who can reach it.
     * For internal load balancers this is anyone in the same VPC. For public load
     * balancers, this is anyone on the internet.
     * 
     * If you want to be more selective about who can access this load
     * balancer, set this to `false` and use the listener's `connections`
     * object to selectively grant access to the listener.
     * @default true
     */
    void setOpen(final java.lang.Boolean value);
    /**
     * The port on which the listener listens for requests.
     * @default Determined from protocol if known
     */
    java.lang.Number getPort();
    /**
     * The port on which the listener listens for requests.
     * @default Determined from protocol if known
     */
    void setPort(final java.lang.Number value);
    /**
     * The protocol to use
     * @default Determined from port if known
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol();
    /**
     * The protocol to use
     * @default Determined from port if known
     */
    void setProtocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value);
    /**
     * The security policy that defines which ciphers and protocols are supported.
     * @default the current predefined security policy.
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy();
    /**
     * The security policy that defines which ciphers and protocols are supported.
     * @default the current predefined security policy.
     */
    void setSslPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy value);

    /**
     * @return a {@link Builder} of {@link BaseApplicationListenerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BaseApplicationListenerProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _certificateArns;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> _defaultTargetGroups;
        @javax.annotation.Nullable
        private java.lang.Boolean _open;
        @javax.annotation.Nullable
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol _protocol;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy _sslPolicy;

        /**
         * Sets the value of CertificateArns
         * @param value The certificates to use on this listener
         * @return {@code this}
         */
        public Builder withCertificateArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._certificateArns = value;
            return this;
        }
        /**
         * Sets the value of DefaultTargetGroups
         * @param value Default target groups to load balance to
         * @return {@code this}
         */
        public Builder withDefaultTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this._defaultTargetGroups = value;
            return this;
        }
        /**
         * Sets the value of Open
         * @param value Allow anyone to connect to this listener

If this is specified, the listener will be opened up to anyone who can reach it.
For internal load balancers this is anyone in the same VPC. For public load
balancers, this is anyone on the internet.

If you want to be more selective about who can access this load
balancer, set this to `false` and use the listener's `connections`
object to selectively grant access to the listener.
         * @return {@code this}
         */
        public Builder withOpen(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._open = value;
            return this;
        }
        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        public Builder withPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._port = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The protocol to use
         * @return {@code this}
         */
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of SslPolicy
         * @param value The security policy that defines which ciphers and protocols are supported.
         * @return {@code this}
         */
        public Builder withSslPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy value) {
            this._sslPolicy = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseApplicationListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BaseApplicationListenerProps build() {
            return new BaseApplicationListenerProps() {
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $certificateArns = _certificateArns;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> $defaultTargetGroups = _defaultTargetGroups;
                @javax.annotation.Nullable
                private java.lang.Boolean $open = _open;
                @javax.annotation.Nullable
                private java.lang.Number $port = _port;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy $sslPolicy = _sslPolicy;

                @Override
                public java.util.List<java.lang.String> getCertificateArns() {
                    return this.$certificateArns;
                }

                @Override
                public void setCertificateArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$certificateArns = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups() {
                    return this.$defaultTargetGroups;
                }

                @Override
                public void setDefaultTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
                    this.$defaultTargetGroups = value;
                }

                @Override
                public java.lang.Boolean getOpen() {
                    return this.$open;
                }

                @Override
                public void setOpen(@javax.annotation.Nullable final java.lang.Boolean value) {
                    this.$open = value;
                }

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$port = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
                    this.$protocol = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
                    return this.$sslPolicy;
                }

                @Override
                public void setSslPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy value) {
                    this.$sslPolicy = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The certificates to use on this listener
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getCertificateArns() {
            return this.jsiiGet("certificateArns", java.util.List.class);
        }

        /**
         * The certificates to use on this listener
         */
        @Override
        public void setCertificateArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("certificateArns", value);
        }

        /**
         * Default target groups to load balance to
         * @default None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups() {
            return this.jsiiGet("defaultTargetGroups", java.util.List.class);
        }

        /**
         * Default target groups to load balance to
         * @default None
         */
        @Override
        public void setDefaultTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this.jsiiSet("defaultTargetGroups", value);
        }

        /**
         * Allow anyone to connect to this listener
         * 
         * If this is specified, the listener will be opened up to anyone who can reach it.
         * For internal load balancers this is anyone in the same VPC. For public load
         * balancers, this is anyone on the internet.
         * 
         * If you want to be more selective about who can access this load
         * balancer, set this to `false` and use the listener's `connections`
         * object to selectively grant access to the listener.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getOpen() {
            return this.jsiiGet("open", java.lang.Boolean.class);
        }

        /**
         * Allow anyone to connect to this listener
         * 
         * If this is specified, the listener will be opened up to anyone who can reach it.
         * For internal load balancers this is anyone in the same VPC. For public load
         * balancers, this is anyone on the internet.
         * 
         * If you want to be more selective about who can access this load
         * balancer, set this to `false` and use the listener's `connections`
         * object to selectively grant access to the listener.
         * @default true
         */
        @Override
        public void setOpen(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("open", value);
        }

        /**
         * The port on which the listener listens for requests.
         * @default Determined from protocol if known
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The port on which the listener listens for requests.
         * @default Determined from protocol if known
         */
        @Override
        public void setPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("port", value);
        }

        /**
         * The protocol to use
         * @default Determined from port if known
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
        }

        /**
         * The protocol to use
         * @default Determined from port if known
         */
        @Override
        public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this.jsiiSet("protocol", value);
        }

        /**
         * The security policy that defines which ciphers and protocols are supported.
         * @default the current predefined security policy.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.jsiiGet("sslPolicy", software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class);
        }

        /**
         * The security policy that defines which ciphers and protocols are supported.
         * @default the current predefined security policy.
         */
        @Override
        public void setSslPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy value) {
            this.jsiiSet("sslPolicy", value);
        }
    }
}
