package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding new targets to a listener
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-04T14:55:00.853Z")
public interface AddApplicationTargetsProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {
    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0–3600 seconds.
     * @default 300
     */
    java.lang.Number getDeregistrationDelaySec();
    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0–3600 seconds.
     * @default 300
     */
    void setDeregistrationDelaySec(final java.lang.Number value);
    /**
     * Health check configuration
     * @default No health check
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck();
    /**
     * Health check configuration
     * @default No health check
     */
    void setHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value);
    /**
     * The port on which the listener listens for requests.
     * @default Determined from protocol if known
     */
    java.lang.Number getPort();
    /**
     * The port on which the listener listens for requests.
     * @default Determined from protocol if known
     */
    void setPort(final java.lang.Number value);
    /**
     * The protocol to use
     * @default Determined from port if known
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol();
    /**
     * The protocol to use
     * @default Determined from port if known
     */
    void setProtocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value);
    /**
     * The time period during which the load balancer sends a newly registered
     * target a linearly increasing share of the traffic to the target group.
     * 
     * The range is 30–900 seconds (15 minutes).
     * @default 0
     */
    java.lang.Number getSlowStartSec();
    /**
     * The time period during which the load balancer sends a newly registered
     * target a linearly increasing share of the traffic to the target group.
     * 
     * The range is 30–900 seconds (15 minutes).
     * @default 0
     */
    void setSlowStartSec(final java.lang.Number value);
    /**
     * The stickiness cookie expiration period.
     * 
     * Setting this value enables load balancer stickiness.
     * 
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     * @default 86400 (1 day)
     */
    java.lang.Number getStickinessCookieDurationSec();
    /**
     * The stickiness cookie expiration period.
     * 
     * Setting this value enables load balancer stickiness.
     * 
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     * @default 86400 (1 day)
     */
    void setStickinessCookieDurationSec(final java.lang.Number value);
    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * @default Automatically generated
     */
    java.lang.String getTargetGroupName();
    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * @default Automatically generated
     */
    void setTargetGroupName(final java.lang.String value);
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets();
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value);

    /**
     * @return a {@link Builder} of {@link AddApplicationTargetsProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddApplicationTargetsProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _deregistrationDelaySec;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol _protocol;
        @javax.annotation.Nullable
        private java.lang.Number _slowStartSec;
        @javax.annotation.Nullable
        private java.lang.Number _stickinessCookieDurationSec;
        @javax.annotation.Nullable
        private java.lang.String _targetGroupName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> _targets;
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.lang.Number _priority;

        /**
         * Sets the value of DeregistrationDelaySec
         * @param value The amount of time for Elastic Load Balancing to wait before deregistering a target.

The range is 0–3600 seconds.
         * @return {@code this}
         */
        public Builder withDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check configuration
         * @return {@code this}
         */
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        public Builder withPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._port = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The protocol to use
         * @return {@code this}
         */
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of SlowStartSec
         * @param value The time period during which the load balancer sends a newly registered
target a linearly increasing share of the traffic to the target group.

The range is 30–900 seconds (15 minutes).
         * @return {@code this}
         */
        public Builder withSlowStartSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._slowStartSec = value;
            return this;
        }
        /**
         * Sets the value of StickinessCookieDurationSec
         * @param value The stickiness cookie expiration period.

Setting this value enables load balancer stickiness.

After this period, the cookie is considered stale. The minimum value is
1 second and the maximum value is 7 days (604800 seconds).
         * @return {@code this}
         */
        public Builder withStickinessCookieDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._stickinessCookieDurationSec = value;
            return this;
        }
        /**
         * Sets the value of TargetGroupName
         * @param value The name of the target group.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens, and
must not begin or end with a hyphen.
         * @return {@code this}
         */
        public Builder withTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._targetGroupName = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value The targets to add to this target group.

Can be `Instance`, `IPAddress`, or any self-registering load balancing
target. If you use either `Instance` or `IPAddress` as targets, all
target must be of the same type.
         * @return {@code this}
         */
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }
        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host

May contain up to three '*' wildcards.

Requires that priority is set.
         * @return {@code this}
         */
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern

May contain up to three '*' wildcards.

Requires that priority is set.
         * @return {@code this}
         */
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of this target group

The rule with the lowest priority will be used for every request.
If priority is not given, these target groups will be added as
defaults, and must not have conditions.

Priorities must be unique.
         * @return {@code this}
         */
        public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this._priority = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddApplicationTargetsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AddApplicationTargetsProps build() {
            return new AddApplicationTargetsProps() {
                @javax.annotation.Nullable
                private java.lang.Number $deregistrationDelaySec = _deregistrationDelaySec;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private java.lang.Number $port = _port;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private java.lang.Number $slowStartSec = _slowStartSec;
                @javax.annotation.Nullable
                private java.lang.Number $stickinessCookieDurationSec = _stickinessCookieDurationSec;
                @javax.annotation.Nullable
                private java.lang.String $targetGroupName = _targetGroupName;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> $targets = _targets;
                @javax.annotation.Nullable
                private java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private java.lang.Number $priority = _priority;

                @Override
                public java.lang.Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$deregistrationDelaySec = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$port = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
                    this.$protocol = value;
                }

                @Override
                public java.lang.Number getSlowStartSec() {
                    return this.$slowStartSec;
                }

                @Override
                public void setSlowStartSec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$slowStartSec = value;
                }

                @Override
                public java.lang.Number getStickinessCookieDurationSec() {
                    return this.$stickinessCookieDurationSec;
                }

                @Override
                public void setStickinessCookieDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$stickinessCookieDurationSec = value;
                }

                @Override
                public java.lang.String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$targetGroupName = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value) {
                    this.$targets = value;
                }

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
                    this.$hostHeader = value;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
                    this.$pathPattern = value;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                @Override
                public void setPriority(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$priority = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getDeregistrationDelaySec() {
            return this.jsiiGet("deregistrationDelaySec", java.lang.Number.class);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("deregistrationDelaySec", value);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this.jsiiSet("healthCheck", value);
        }

        /**
         * The port on which the listener listens for requests.
         * @default Determined from protocol if known
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The port on which the listener listens for requests.
         * @default Determined from protocol if known
         */
        @Override
        public void setPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("port", value);
        }

        /**
         * The protocol to use
         * @default Determined from port if known
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
        }

        /**
         * The protocol to use
         * @default Determined from port if known
         */
        @Override
        public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this.jsiiSet("protocol", value);
        }

        /**
         * The time period during which the load balancer sends a newly registered
         * target a linearly increasing share of the traffic to the target group.
         * 
         * The range is 30–900 seconds (15 minutes).
         * @default 0
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getSlowStartSec() {
            return this.jsiiGet("slowStartSec", java.lang.Number.class);
        }

        /**
         * The time period during which the load balancer sends a newly registered
         * target a linearly increasing share of the traffic to the target group.
         * 
         * The range is 30–900 seconds (15 minutes).
         * @default 0
         */
        @Override
        public void setSlowStartSec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("slowStartSec", value);
        }

        /**
         * The stickiness cookie expiration period.
         * 
         * Setting this value enables load balancer stickiness.
         * 
         * After this period, the cookie is considered stale. The minimum value is
         * 1 second and the maximum value is 7 days (604800 seconds).
         * @default 86400 (1 day)
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getStickinessCookieDurationSec() {
            return this.jsiiGet("stickinessCookieDurationSec", java.lang.Number.class);
        }

        /**
         * The stickiness cookie expiration period.
         * 
         * Setting this value enables load balancer stickiness.
         * 
         * After this period, the cookie is considered stale. The minimum value is
         * 1 second and the maximum value is 7 days (604800 seconds).
         * @default 86400 (1 day)
         */
        @Override
        public void setStickinessCookieDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("stickinessCookieDurationSec", value);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTargetGroupName() {
            return this.jsiiGet("targetGroupName", java.lang.String.class);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("targetGroupName", value);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value) {
            this.jsiiSet("targets", value);
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("hostHeader", value);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("pathPattern", value);
        }

        /**
         * Priority of this target group
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * @default Target groups are used as defaults
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Priority of this target group
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * @default Target groups are used as defaults
         */
        @Override
        public void setPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("priority", value);
        }
    }
}
