package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for defining a rule on a listener
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T11:15:23.665Z")
public interface BaseApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Priority of the rule
     * 
     * The rule with the lowest priority will be used for every request.
     * 
     * Priorities must be unique.
     */
    java.lang.Number getPriority();
    /**
     * Priority of the rule
     * 
     * The rule with the lowest priority will be used for every request.
     * 
     * Priorities must be unique.
     */
    void setPriority(final java.lang.Number value);
    /**
     * Rule applies if the requested host matches the indicated host
     * 
     * May contain up to three '*' wildcards.
     * @default No host condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    java.lang.String getHostHeader();
    /**
     * Rule applies if the requested host matches the indicated host
     * 
     * May contain up to three '*' wildcards.
     * @default No host condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
     */
    void setHostHeader(final java.lang.String value);
    /**
     * Rule applies if the requested path matches the given path pattern
     * 
     * May contain up to three '*' wildcards.
     * @default No path condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    java.lang.String getPathPattern();
    /**
     * Rule applies if the requested path matches the given path pattern
     * 
     * May contain up to three '*' wildcards.
     * @default No path condition
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
     */
    void setPathPattern(final java.lang.String value);
    /**
     * Target groups to forward requests to
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups();
    /**
     * Target groups to forward requests to
     */
    void setTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value);

    /**
     * @return a {@link Builder} of {@link BaseApplicationListenerRuleProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BaseApplicationListenerRuleProps}
     */
    final class Builder {
        private java.lang.Number _priority;
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> _targetGroups;

        /**
         * Sets the value of Priority
         * @param value Priority of the rule

The rule with the lowest priority will be used for every request.

Priorities must be unique.
         * @return {@code this}
         */
        public Builder withPriority(final java.lang.Number value) {
            this._priority = java.util.Objects.requireNonNull(value, "priority is required");
            return this;
        }
        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host

May contain up to three '*' wildcards.
         * @return {@code this}
         */
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern

May contain up to three '*' wildcards.
         * @return {@code this}
         */
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of TargetGroups
         * @param value Target groups to forward requests to
         * @return {@code this}
         */
        public Builder withTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this._targetGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BaseApplicationListenerRuleProps build() {
            return new BaseApplicationListenerRuleProps() {
                private java.lang.Number $priority = java.util.Objects.requireNonNull(_priority, "priority is required");
                @javax.annotation.Nullable
                private java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> $targetGroups = _targetGroups;

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                @Override
                public void setPriority(final java.lang.Number value) {
                    this.$priority = java.util.Objects.requireNonNull(value, "priority is required");
                }

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
                    this.$hostHeader = value;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
                    this.$pathPattern = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
                    return this.$targetGroups;
                }

                @Override
                public void setTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
                    this.$targetGroups = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerRuleProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Priority of the rule
         * 
         * The rule with the lowest priority will be used for every request.
         * 
         * Priorities must be unique.
         */
        @Override
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Priority of the rule
         * 
         * The rule with the lowest priority will be used for every request.
         * 
         * Priorities must be unique.
         */
        @Override
        public void setPriority(final java.lang.Number value) {
            this.jsiiSet("priority", java.util.Objects.requireNonNull(value, "priority is required"));
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("hostHeader", value);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("pathPattern", value);
        }

        /**
         * Target groups to forward requests to
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.jsiiGet("targetGroups", java.util.List.class);
        }

        /**
         * Target groups to forward requests to
         */
        @Override
        public void setTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this.jsiiSet("targetGroups", value);
        }
    }
}
