package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * An IP address that is a target for load balancing.
 * 
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 * 
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T17:00:01.900Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.IpTarget")
public class IpTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget,software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget {
    protected IpTarget(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * Create a new IPAddress target
     * 
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * 
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * 
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * 
     * Default is automatic.
     * @param ipAddress The IP Address to load balance to
     * @param port Override the group's default port
     * @param availabilityZone Availability zone to send traffic from
     */
    public IpTarget(final java.lang.String ipAddress, @javax.annotation.Nullable final java.lang.Number port, @javax.annotation.Nullable final java.lang.String availabilityZone) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(ipAddress, "ipAddress is required")), java.util.stream.Stream.of(port)), java.util.stream.Stream.of(availabilityZone)).toArray());
    }
    /**
     * Create a new IPAddress target
     * 
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * 
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * 
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * 
     * Default is automatic.
     * @param ipAddress The IP Address to load balance to
     * @param port Override the group's default port
     */
    public IpTarget(final java.lang.String ipAddress, @javax.annotation.Nullable final java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(ipAddress, "ipAddress is required")), java.util.stream.Stream.of(port)).toArray());
    }
    /**
     * Create a new IPAddress target
     * 
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * 
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * 
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * 
     * Default is automatic.
     * @param ipAddress The IP Address to load balance to
     */
    public IpTarget(final java.lang.String ipAddress) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.of(java.util.Objects.requireNonNull(ipAddress, "ipAddress is required")).toArray());
    }

    /**
     * Register this instance target with a load balancer
     * 
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup targetGroup) {
        return this.jsiiCall("attachToApplicationTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(targetGroup, "targetGroup is required")).toArray());
    }

    /**
     * Register this instance target with a load balancer
     * 
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup targetGroup) {
        return this.jsiiCall("attachToNetworkTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(targetGroup, "targetGroup is required")).toArray());
    }

    /**
     * The IP Address to load balance to
     */
    public java.lang.String getIpAddress() {
        return this.jsiiGet("ipAddress", java.lang.String.class);
    }

    /**
     * Availability zone to send traffic from
     */
    @javax.annotation.Nullable
    public java.lang.String getAvailabilityZone() {
        return this.jsiiGet("availabilityZone", java.lang.String.class);
    }

    /**
     * Override the group's default port
     */
    @javax.annotation.Nullable
    public java.lang.Number getPort() {
        return this.jsiiGet("port", java.lang.Number.class);
    }
}
