package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define the target of a load balancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.14 (build 91853ce)", date = "2019-02-07T17:00:01.920Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.TargetGroupBase")
public abstract class TargetGroupBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup,software.amazon.awscdk.services.codedeploy.api.ILoadBalancer {
    protected TargetGroupBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Register the given load balancing target as part of this group
     */
    protected void addLoadBalancerTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps props) {
        this.jsiiCall("addLoadBalancerTarget", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required")).toArray());
    }

    /**
     * Specify the CodeDeploy-required properties of this load balancer.
     */
    @Override
    public software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps asCodeDeployLoadBalancer() {
        return this.jsiiCall("asCodeDeployLoadBalancer", software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps.class);
    }

    /**
     * Set/replace the target group's health check
     */
    public void configureHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
        this.jsiiCall("configureHealthCheck", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(healthCheck, "healthCheck is required")).toArray());
    }

    /**
     * Export this target group
     */
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps.class);
    }

    /**
     * Set a non-standard attribute on the target group
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     */
    public void setAttribute(final java.lang.String key, @javax.annotation.Nullable final java.lang.String value) {
        this.jsiiCall("setAttribute", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")), java.util.stream.Stream.of(value)).toArray());
    }

    /**
     * Set a non-standard attribute on the target group
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     */
    public void setAttribute(final java.lang.String key) {
        this.jsiiCall("setAttribute", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")).toArray());
    }

    /**
     * Default port configured for members of this target group
     */
    protected java.lang.String getDefaultPort() {
        return this.jsiiGet("defaultPort", java.lang.String.class);
    }

    /**
     * Full name of first load balancer
     * 
     * This identifier is emitted as a dimensions of the metrics of this target
     * group.
     * @example app/my-load-balancer/123456789
     */
    public java.lang.String getFirstLoadBalancerFullName() {
        return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
    }

    /**
     * Health check for the members of this target group
     * A token representing a list of ARNs of the load balancers that route traffic to this target group
     */
    @Override
    public java.lang.String getLoadBalancerArns() {
        return this.jsiiGet("loadBalancerArns", java.lang.String.class);
    }

    /**
     * List of constructs that need to be depended on to ensure the TargetGroup is associated to a load balancer
     */
    @Override
    public software.amazon.awscdk.IDependable getLoadBalancerAttached() {
        return this.jsiiGet("loadBalancerAttached", software.amazon.awscdk.IDependable.class);
    }

    /**
     * Configurable dependable with all resources that lead to load balancer attachment
     */
    protected software.amazon.awscdk.ConcreteDependable getLoadBalancerAttachedDependencies() {
        return this.jsiiGet("loadBalancerAttachedDependencies", software.amazon.awscdk.ConcreteDependable.class);
    }

    /**
     * The ARN of the target group
     */
    @Override
    public java.lang.String getTargetGroupArn() {
        return this.jsiiGet("targetGroupArn", java.lang.String.class);
    }

    /**
     * The full name of the target group
     */
    public java.lang.String getTargetGroupFullName() {
        return this.jsiiGet("targetGroupFullName", java.lang.String.class);
    }

    /**
     * ARNs of load balancers load balancing to this TargetGroup
     */
    public java.util.List<java.lang.String> getTargetGroupLoadBalancerArns() {
        return this.jsiiGet("targetGroupLoadBalancerArns", java.util.List.class);
    }

    /**
     * The name of the target group
     */
    public java.lang.String getTargetGroupName() {
        return this.jsiiGet("targetGroupName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
        return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
    }

    public void setHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
        this.jsiiSet("healthCheck", java.util.Objects.requireNonNull(value, "healthCheck is required"));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Full name of first load balancer
         * 
         * This identifier is emitted as a dimensions of the metrics of this target
         * group.
         * @example app/my-load-balancer/123456789
         */
        @Override
        public java.lang.String getFirstLoadBalancerFullName() {
            return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
        }

        /**
         * A token representing a list of ARNs of the load balancers that route traffic to this target group
         */
        @Override
        public java.lang.String getLoadBalancerArns() {
            return this.jsiiGet("loadBalancerArns", java.lang.String.class);
        }

        /**
         * Return an object to depend on the listeners added to this target group
         */
        @Override
        public software.amazon.awscdk.IDependable getLoadBalancerAttached() {
            return this.jsiiGet("loadBalancerAttached", software.amazon.awscdk.IDependable.class);
        }

        /**
         * ARN of the target group
         */
        @Override
        public java.lang.String getTargetGroupArn() {
            return this.jsiiGet("targetGroupArn", java.lang.String.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Export this target group
         */
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps export() {
            return this.jsiiCall("export", software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps.class);
        }

        /**
         * Specify the CodeDeploy-required properties of this load balancer.
         */
        @Override
        public software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps asCodeDeployLoadBalancer() {
            return this.jsiiCall("asCodeDeployLoadBalancer", software.amazon.awscdk.services.codedeploy.api.ILoadBalancerProps.class);
        }
    }
}
