/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpcNetwork;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.JsiiSerializable;

public interface BaseTargetGroupProps
extends JsiiSerializable {
    public IVpcNetwork getVpc();

    public void setVpc(IVpcNetwork var1);

    public Number getDeregistrationDelaySec();

    public void setDeregistrationDelaySec(Number var1);

    public HealthCheck getHealthCheck();

    public void setHealthCheck(HealthCheck var1);

    public String getTargetGroupName();

    public void setTargetGroupName(String var1);

    public TargetType getTargetType();

    public void setTargetType(TargetType var1);

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpcNetwork _vpc;
        @Nullable
        private Number _deregistrationDelaySec;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private String _targetGroupName;
        @Nullable
        private TargetType _targetType;

        public Builder withVpc(IVpcNetwork value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeregistrationDelaySec(@Nullable Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withTargetGroupName(@Nullable String value) {
            this._targetGroupName = value;
            return this;
        }

        public Builder withTargetType(@Nullable TargetType value) {
            this._targetType = value;
            return this;
        }

        public BaseTargetGroupProps build() {
            return new BaseTargetGroupProps(){
                private IVpcNetwork $vpc;
                @Nullable
                private Number $deregistrationDelaySec;
                @Nullable
                private HealthCheck $healthCheck;
                @Nullable
                private String $targetGroupName;
                @Nullable
                private TargetType $targetType;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deregistrationDelaySec = _deregistrationDelaySec;
                    this.$healthCheck = _healthCheck;
                    this.$targetGroupName = _targetGroupName;
                    this.$targetType = _targetType;
                }

                @Override
                public IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(IVpcNetwork value) {
                    this.$vpc = Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public void setDeregistrationDelaySec(@Nullable Number value) {
                    this.$deregistrationDelaySec = value;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@Nullable HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public void setTargetGroupName(@Nullable String value) {
                    this.$targetGroupName = value;
                }

                @Override
                public TargetType getTargetType() {
                    return this.$targetType;
                }

                @Override
                public void setTargetType(@Nullable TargetType value) {
                    this.$targetType = value;
                }
            };
        }
    }
}

