package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a new target group to a listener
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-07T22:16:55.326Z")
public interface AddApplicationTargetGroupsProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {
    /**
     * Target groups to forward requests to
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups();
    /**
     * Target groups to forward requests to
     */
    void setTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value);

    /**
     * @return a {@link Builder} of {@link AddApplicationTargetGroupsProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddApplicationTargetGroupsProps}
     */
    final class Builder {
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> _targetGroups;
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.lang.Number _priority;

        /**
         * Sets the value of TargetGroups
         * @param value Target groups to forward requests to
         * @return {@code this}
         */
        public Builder withTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
            return this;
        }
        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host

May contain up to three '*' wildcards.

Requires that priority is set.
         * @return {@code this}
         */
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern

May contain up to three '*' wildcards.

Requires that priority is set.
         * @return {@code this}
         */
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of this target group

The rule with the lowest priority will be used for every request.
If priority is not given, these target groups will be added as
defaults, and must not have conditions.

Priorities must be unique.
         * @return {@code this}
         */
        public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this._priority = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddApplicationTargetGroupsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public AddApplicationTargetGroupsProps build() {
            return new AddApplicationTargetGroupsProps() {
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> $targetGroups = java.util.Objects.requireNonNull(_targetGroups, "targetGroups is required");
                @javax.annotation.Nullable
                private java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private java.lang.Number $priority = _priority;

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
                    return this.$targetGroups;
                }

                @Override
                public void setTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
                    this.$targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
                }

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
                    this.$hostHeader = value;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
                    this.$pathPattern = value;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                @Override
                public void setPriority(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$priority = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Target groups to forward requests to
         */
        @Override
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.jsiiGet("targetGroups", java.util.List.class);
        }

        /**
         * Target groups to forward requests to
         */
        @Override
        public void setTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this.jsiiSet("targetGroups", java.util.Objects.requireNonNull(value, "targetGroups is required"));
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No host condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        public void setHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("hostHeader", value);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * @default No path condition
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        public void setPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("pathPattern", value);
        }

        /**
         * Priority of this target group
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * @default Target groups are used as defaults
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * Priority of this target group
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * @default Target groups are used as defaults
         */
        @Override
        public void setPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("priority", value);
        }
    }
}
