package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Base class for both Application and Network Load Balancers
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-07T22:16:55.399Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.BaseLoadBalancer")
public abstract class BaseLoadBalancer extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.route53.IAliasRecordTarget {
    protected BaseLoadBalancer(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets
     */
    @Override
    public software.amazon.awscdk.services.route53.AliasRecordTargetProps asAliasRecordTarget() {
        return this.jsiiCall("asAliasRecordTarget", software.amazon.awscdk.services.route53.AliasRecordTargetProps.class);
    }

    /**
     * Remove an attribute from the load balancer
     */
    public void removeAttribute(final java.lang.String key) {
        this.jsiiCall("removeAttribute", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")).toArray());
    }

    /**
     * Set a non-standard attribute on the load balancer
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes
     */
    public void setAttribute(final java.lang.String key, @javax.annotation.Nullable final java.lang.String value) {
        this.jsiiCall("setAttribute", Void.class, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")), java.util.stream.Stream.of(value)).toArray());
    }

    /**
     * Set a non-standard attribute on the load balancer
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes
     */
    public void setAttribute(final java.lang.String key) {
        this.jsiiCall("setAttribute", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(key, "key is required")).toArray());
    }

    /**
     * The canonical hosted zone ID of this load balancer
     * @example Z2P70J7EXAMPLE
     */
    public java.lang.String getCanonicalHostedZoneId() {
        return this.jsiiGet("canonicalHostedZoneId", java.lang.String.class);
    }

    /**
     * The DNS name of this load balancer
     * @example my-load-balancer-424835706.us-west-2.elb.amazonaws.com
     */
    public java.lang.String getDnsName() {
        return this.jsiiGet("dnsName", java.lang.String.class);
    }

    /**
     * The full name of this load balancer
     * @example app/my-load-balancer/50dc6c495c0c9188
     */
    public java.lang.String getFullName() {
        return this.jsiiGet("fullName", java.lang.String.class);
    }

    /**
     * The ARN of this load balancer
     * @example arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-internal-load-balancer/50dc6c495c0c9188
     */
    public java.lang.String getLoadBalancerArn() {
        return this.jsiiGet("loadBalancerArn", java.lang.String.class);
    }

    /**
     * The name of this load balancer
     * @example my-load-balancer
     */
    public java.lang.String getLoadBalancerName() {
        return this.jsiiGet("loadBalancerName", java.lang.String.class);
    }

    /**
     * The VPC this load balancer has been created in, if available
     * 
     * If the Load Balancer was imported, the VPC is not available.
     */
    @javax.annotation.Nullable
    public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
        return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }

        /**
         * The set of constructs that form the root of this dependable
         * 
         * All resources under all returned constructs are included in the ordering
         * dependency.
         */
        @Override
        public java.util.List<software.amazon.awscdk.IConstruct> getDependencyRoots() {
            return this.jsiiGet("dependencyRoots", java.util.List.class);
        }

        /**
         * Return hosted zone ID and DNS name, usable for Route53 alias targets
         */
        @Override
        public software.amazon.awscdk.services.route53.AliasRecordTargetProps asAliasRecordTarget() {
            return this.jsiiCall("asAliasRecordTarget", software.amazon.awscdk.services.route53.AliasRecordTargetProps.class);
        }
    }
}
