package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining an Application Target Group
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-12T14:25:02.629Z")
public interface ApplicationTargetGroupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps {
    /**
     * The port on which the listener listens for requests.
     * @default Determined from protocol if known
     */
    java.lang.Number getPort();
    /**
     * The port on which the listener listens for requests.
     * @default Determined from protocol if known
     */
    void setPort(final java.lang.Number value);
    /**
     * The protocol to use
     * @default Determined from port if known
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol();
    /**
     * The protocol to use
     * @default Determined from port if known
     */
    void setProtocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value);
    /**
     * The time period during which the load balancer sends a newly registered
     * target a linearly increasing share of the traffic to the target group.
     * 
     * The range is 30–900 seconds (15 minutes).
     * @default 0
     */
    java.lang.Number getSlowStartSec();
    /**
     * The time period during which the load balancer sends a newly registered
     * target a linearly increasing share of the traffic to the target group.
     * 
     * The range is 30–900 seconds (15 minutes).
     * @default 0
     */
    void setSlowStartSec(final java.lang.Number value);
    /**
     * The stickiness cookie expiration period.
     * 
     * Setting this value enables load balancer stickiness.
     * 
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     * @default 86400 (1 day)
     */
    java.lang.Number getStickinessCookieDurationSec();
    /**
     * The stickiness cookie expiration period.
     * 
     * Setting this value enables load balancer stickiness.
     * 
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     * @default 86400 (1 day)
     */
    void setStickinessCookieDurationSec(final java.lang.Number value);
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets();
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    void setTargets(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value);

    /**
     * @return a {@link Builder} of {@link ApplicationTargetGroupProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationTargetGroupProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol _protocol;
        @javax.annotation.Nullable
        private java.lang.Number _slowStartSec;
        @javax.annotation.Nullable
        private java.lang.Number _stickinessCookieDurationSec;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> _targets;
        private software.amazon.awscdk.services.ec2.IVpcNetwork _vpc;
        @javax.annotation.Nullable
        private java.lang.Number _deregistrationDelaySec;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.String _targetGroupName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType _targetType;

        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        public Builder withPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._port = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The protocol to use
         * @return {@code this}
         */
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of SlowStartSec
         * @param value The time period during which the load balancer sends a newly registered
target a linearly increasing share of the traffic to the target group.

The range is 30–900 seconds (15 minutes).
         * @return {@code this}
         */
        public Builder withSlowStartSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._slowStartSec = value;
            return this;
        }
        /**
         * Sets the value of StickinessCookieDurationSec
         * @param value The stickiness cookie expiration period.

Setting this value enables load balancer stickiness.

After this period, the cookie is considered stale. The minimum value is
1 second and the maximum value is 7 days (604800 seconds).
         * @return {@code this}
         */
        public Builder withStickinessCookieDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
            this._stickinessCookieDurationSec = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value The targets to add to this target group.

Can be `Instance`, `IPAddress`, or any self-registering load balancing
target. If you use either `Instance` or `IPAddress` as targets, all
target must be of the same type.
         * @return {@code this}
         */
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value The virtual private cloud (VPC).
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeregistrationDelaySec
         * @param value The amount of time for Elastic Load Balancing to wait before deregistering a target.

The range is 0–3600 seconds.
         * @return {@code this}
         */
        public Builder withDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check configuration
         * @return {@code this}
         */
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of TargetGroupName
         * @param value The name of the target group.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens, and
must not begin or end with a hyphen.
         * @return {@code this}
         */
        public Builder withTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._targetGroupName = value;
            return this;
        }
        /**
         * Sets the value of TargetType
         * @param value The type of targets registered to this TargetGroup, either IP or Instance.

All targets registered into the group must be of this type. If you
register targets to the TargetGroup in the CDK app, the TargetType is
determined automatically.
         * @return {@code this}
         */
        public Builder withTargetType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
            this._targetType = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationTargetGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApplicationTargetGroupProps build() {
            return new ApplicationTargetGroupProps() {
                @javax.annotation.Nullable
                private java.lang.Number $port = _port;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private java.lang.Number $slowStartSec = _slowStartSec;
                @javax.annotation.Nullable
                private java.lang.Number $stickinessCookieDurationSec = _stickinessCookieDurationSec;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> $targets = _targets;
                private software.amazon.awscdk.services.ec2.IVpcNetwork $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private java.lang.Number $deregistrationDelaySec = _deregistrationDelaySec;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private java.lang.String $targetGroupName = _targetGroupName;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType $targetType = _targetType;

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$port = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
                    this.$protocol = value;
                }

                @Override
                public java.lang.Number getSlowStartSec() {
                    return this.$slowStartSec;
                }

                @Override
                public void setSlowStartSec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$slowStartSec = value;
                }

                @Override
                public java.lang.Number getStickinessCookieDurationSec() {
                    return this.$stickinessCookieDurationSec;
                }

                @Override
                public void setStickinessCookieDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$stickinessCookieDurationSec = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value) {
                    this.$targets = value;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
                    this.$vpc = java.util.Objects.requireNonNull(value, "vpc is required");
                }

                @Override
                public java.lang.Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$deregistrationDelaySec = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
                    this.$healthCheck = value;
                }

                @Override
                public java.lang.String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$targetGroupName = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
                    return this.$targetType;
                }

                @Override
                public void setTargetType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
                    this.$targetType = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroupProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The port on which the listener listens for requests.
         * @default Determined from protocol if known
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The port on which the listener listens for requests.
         * @default Determined from protocol if known
         */
        @Override
        public void setPort(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("port", value);
        }

        /**
         * The protocol to use
         * @default Determined from port if known
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
        }

        /**
         * The protocol to use
         * @default Determined from port if known
         */
        @Override
        public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this.jsiiSet("protocol", value);
        }

        /**
         * The time period during which the load balancer sends a newly registered
         * target a linearly increasing share of the traffic to the target group.
         * 
         * The range is 30–900 seconds (15 minutes).
         * @default 0
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getSlowStartSec() {
            return this.jsiiGet("slowStartSec", java.lang.Number.class);
        }

        /**
         * The time period during which the load balancer sends a newly registered
         * target a linearly increasing share of the traffic to the target group.
         * 
         * The range is 30–900 seconds (15 minutes).
         * @default 0
         */
        @Override
        public void setSlowStartSec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("slowStartSec", value);
        }

        /**
         * The stickiness cookie expiration period.
         * 
         * Setting this value enables load balancer stickiness.
         * 
         * After this period, the cookie is considered stale. The minimum value is
         * 1 second and the maximum value is 7 days (604800 seconds).
         * @default 86400 (1 day)
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getStickinessCookieDurationSec() {
            return this.jsiiGet("stickinessCookieDurationSec", java.lang.Number.class);
        }

        /**
         * The stickiness cookie expiration period.
         * 
         * Setting this value enables load balancer stickiness.
         * 
         * After this period, the cookie is considered stale. The minimum value is
         * 1 second and the maximum value is 7 days (604800 seconds).
         * @default 86400 (1 day)
         */
        @Override
        public void setStickinessCookieDurationSec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("stickinessCookieDurationSec", value);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        public void setTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value) {
            this.jsiiSet("targets", value);
        }

        /**
         * The virtual private cloud (VPC).
         */
        @Override
        public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
        }

        /**
         * The virtual private cloud (VPC).
         */
        @Override
        public void setVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this.jsiiSet("vpc", java.util.Objects.requireNonNull(value, "vpc is required"));
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getDeregistrationDelaySec() {
            return this.jsiiGet("deregistrationDelaySec", java.lang.Number.class);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0–3600 seconds.
         * @default 300
         */
        @Override
        public void setDeregistrationDelaySec(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("deregistrationDelaySec", value);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
        }

        /**
         * Health check configuration
         * @default No health check
         */
        @Override
        public void setHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this.jsiiSet("healthCheck", value);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getTargetGroupName() {
            return this.jsiiGet("targetGroupName", java.lang.String.class);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * @default Automatically generated
         */
        @Override
        public void setTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("targetGroupName", value);
        }

        /**
         * The type of targets registered to this TargetGroup, either IP or Instance.
         * 
         * All targets registered into the group must be of this type. If you
         * register targets to the TargetGroup in the CDK app, the TargetType is
         * determined automatically.
         * @default Determined automatically
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
        }

        /**
         * The type of targets registered to this TargetGroup, either IP or Instance.
         * 
         * All targets registered into the group must be of this type. If you
         * register targets to the TargetGroup in the CDK app, the TargetType is
         * determined automatically.
         * @default Determined automatically
         */
        @Override
        public void setTargetType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
            this.jsiiSet("targetType", value);
        }
    }
}
