package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for configuring a health check
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.15 (build e429c41)", date = "2019-03-12T14:25:02.737Z")
public interface HealthCheck extends software.amazon.jsii.JsiiSerializable {
    /**
     * HTTP code to use when checking for a successful response from a target.
     * 
     * For Application Load Balancers, you can specify values between 200 and
     * 499, and the default value is 200. You can specify multiple values (for
     * example, "200,202") or a range of values (for example, "200-299").
     */
    java.lang.String getHealthyHttpCodes();
    /**
     * HTTP code to use when checking for a successful response from a target.
     * 
     * For Application Load Balancers, you can specify values between 200 and
     * 499, and the default value is 200. You can specify multiple values (for
     * example, "200,202") or a range of values (for example, "200-299").
     */
    void setHealthyHttpCodes(final java.lang.String value);
    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * 
     * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
     * @default 5 for ALBs, 3 for NLBs
     */
    java.lang.Number getHealthyThresholdCount();
    /**
     * The number of consecutive health checks successes required before considering an unhealthy target healthy.
     * 
     * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
     * @default 5 for ALBs, 3 for NLBs
     */
    void setHealthyThresholdCount(final java.lang.Number value);
    /**
     * The approximate number of seconds between health checks for an individual target.
     * @default 30
     */
    java.lang.Number getIntervalSecs();
    /**
     * The approximate number of seconds between health checks for an individual target.
     * @default 30
     */
    void setIntervalSecs(final java.lang.Number value);
    /**
     * The ping path destination where Elastic Load Balancing sends health check requests.
     * @default /
     */
    java.lang.String getPath();
    /**
     * The ping path destination where Elastic Load Balancing sends health check requests.
     * @default /
     */
    void setPath(final java.lang.String value);
    /**
     * The port that the load balancer uses when performing health checks on the targets.
     * @default 'traffic-port'
     */
    java.lang.String getPort();
    /**
     * The port that the load balancer uses when performing health checks on the targets.
     * @default 'traffic-port'
     */
    void setPort(final java.lang.String value);
    /**
     * The protocol the load balancer uses when performing health checks on targets.
     * 
     * The TCP protocol is supported only if the protocol of the target group
     * is TCP.
     * @default HTTP for ALBs, TCP for NLBs
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol();
    /**
     * The protocol the load balancer uses when performing health checks on targets.
     * 
     * The TCP protocol is supported only if the protocol of the target group
     * is TCP.
     * @default HTTP for ALBs, TCP for NLBs
     */
    void setProtocol(final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol value);
    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check.
     * 
     * For Application Load Balancers, the range is 2–60 seconds and the
     * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
     * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
     * @default 5 for ALBs, 10 or 6 for NLBs
     */
    java.lang.Number getTimeoutSeconds();
    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check.
     * 
     * For Application Load Balancers, the range is 2–60 seconds and the
     * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
     * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
     * @default 5 for ALBs, 10 or 6 for NLBs
     */
    void setTimeoutSeconds(final java.lang.Number value);
    /**
     * The number of consecutive health check failures required before considering a target unhealthy.
     * 
     * For Application Load Balancers, the default is 2. For Network Load
     * Balancers, this value must be the same as the healthy threshold count.
     * @default 2
     */
    java.lang.Number getUnhealthyThresholdCount();
    /**
     * The number of consecutive health check failures required before considering a target unhealthy.
     * 
     * For Application Load Balancers, the default is 2. For Network Load
     * Balancers, this value must be the same as the healthy threshold count.
     * @default 2
     */
    void setUnhealthyThresholdCount(final java.lang.Number value);

    /**
     * @return a {@link Builder} of {@link HealthCheck}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link HealthCheck}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _healthyHttpCodes;
        @javax.annotation.Nullable
        private java.lang.Number _healthyThresholdCount;
        @javax.annotation.Nullable
        private java.lang.Number _intervalSecs;
        @javax.annotation.Nullable
        private java.lang.String _path;
        @javax.annotation.Nullable
        private java.lang.String _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol _protocol;
        @javax.annotation.Nullable
        private java.lang.Number _timeoutSeconds;
        @javax.annotation.Nullable
        private java.lang.Number _unhealthyThresholdCount;

        /**
         * Sets the value of HealthyHttpCodes
         * @param value HTTP code to use when checking for a successful response from a target.

For Application Load Balancers, you can specify values between 200 and
499, and the default value is 200. You can specify multiple values (for
example, "200,202") or a range of values (for example, "200-299").
         * @return {@code this}
         */
        public Builder withHealthyHttpCodes(@javax.annotation.Nullable final java.lang.String value) {
            this._healthyHttpCodes = value;
            return this;
        }
        /**
         * Sets the value of HealthyThresholdCount
         * @param value The number of consecutive health checks successes required before considering an unhealthy target healthy.

For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
         * @return {@code this}
         */
        public Builder withHealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._healthyThresholdCount = value;
            return this;
        }
        /**
         * Sets the value of IntervalSecs
         * @param value The approximate number of seconds between health checks for an individual target.
         * @return {@code this}
         */
        public Builder withIntervalSecs(@javax.annotation.Nullable final java.lang.Number value) {
            this._intervalSecs = value;
            return this;
        }
        /**
         * Sets the value of Path
         * @param value The ping path destination where Elastic Load Balancing sends health check requests.
         * @return {@code this}
         */
        public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
            this._path = value;
            return this;
        }
        /**
         * Sets the value of Port
         * @param value The port that the load balancer uses when performing health checks on the targets.
         * @return {@code this}
         */
        public Builder withPort(@javax.annotation.Nullable final java.lang.String value) {
            this._port = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The protocol the load balancer uses when performing health checks on targets.

The TCP protocol is supported only if the protocol of the target group
is TCP.
         * @return {@code this}
         */
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of TimeoutSeconds
         * @param value The amount of time, in seconds, during which no response from a target means a failed health check.

For Application Load Balancers, the range is 2–60 seconds and the
default is 5 seconds. For Network Load Balancers, this is 10 seconds for
TCP and HTTPS health checks and 6 seconds for HTTP health checks.
         * @return {@code this}
         */
        public Builder withTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this._timeoutSeconds = value;
            return this;
        }
        /**
         * Sets the value of UnhealthyThresholdCount
         * @param value The number of consecutive health check failures required before considering a target unhealthy.

For Application Load Balancers, the default is 2. For Network Load
Balancers, this value must be the same as the healthy threshold count.
         * @return {@code this}
         */
        public Builder withUnhealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
            this._unhealthyThresholdCount = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthCheck}
         * @throws NullPointerException if any required attribute was not provided
         */
        public HealthCheck build() {
            return new HealthCheck() {
                @javax.annotation.Nullable
                private java.lang.String $healthyHttpCodes = _healthyHttpCodes;
                @javax.annotation.Nullable
                private java.lang.Number $healthyThresholdCount = _healthyThresholdCount;
                @javax.annotation.Nullable
                private java.lang.Number $intervalSecs = _intervalSecs;
                @javax.annotation.Nullable
                private java.lang.String $path = _path;
                @javax.annotation.Nullable
                private java.lang.String $port = _port;
                @javax.annotation.Nullable
                private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol $protocol = _protocol;
                @javax.annotation.Nullable
                private java.lang.Number $timeoutSeconds = _timeoutSeconds;
                @javax.annotation.Nullable
                private java.lang.Number $unhealthyThresholdCount = _unhealthyThresholdCount;

                @Override
                public java.lang.String getHealthyHttpCodes() {
                    return this.$healthyHttpCodes;
                }

                @Override
                public void setHealthyHttpCodes(@javax.annotation.Nullable final java.lang.String value) {
                    this.$healthyHttpCodes = value;
                }

                @Override
                public java.lang.Number getHealthyThresholdCount() {
                    return this.$healthyThresholdCount;
                }

                @Override
                public void setHealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$healthyThresholdCount = value;
                }

                @Override
                public java.lang.Number getIntervalSecs() {
                    return this.$intervalSecs;
                }

                @Override
                public void setIntervalSecs(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$intervalSecs = value;
                }

                @Override
                public java.lang.String getPath() {
                    return this.$path;
                }

                @Override
                public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                    this.$path = value;
                }

                @Override
                public java.lang.String getPort() {
                    return this.$port;
                }

                @Override
                public void setPort(@javax.annotation.Nullable final java.lang.String value) {
                    this.$port = value;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol value) {
                    this.$protocol = value;
                }

                @Override
                public java.lang.Number getTimeoutSeconds() {
                    return this.$timeoutSeconds;
                }

                @Override
                public void setTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$timeoutSeconds = value;
                }

                @Override
                public java.lang.Number getUnhealthyThresholdCount() {
                    return this.$unhealthyThresholdCount;
                }

                @Override
                public void setUnhealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
                    this.$unhealthyThresholdCount = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * HTTP code to use when checking for a successful response from a target.
         * 
         * For Application Load Balancers, you can specify values between 200 and
         * 499, and the default value is 200. You can specify multiple values (for
         * example, "200,202") or a range of values (for example, "200-299").
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getHealthyHttpCodes() {
            return this.jsiiGet("healthyHttpCodes", java.lang.String.class);
        }

        /**
         * HTTP code to use when checking for a successful response from a target.
         * 
         * For Application Load Balancers, you can specify values between 200 and
         * 499, and the default value is 200. You can specify multiple values (for
         * example, "200,202") or a range of values (for example, "200-299").
         */
        @Override
        public void setHealthyHttpCodes(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("healthyHttpCodes", value);
        }

        /**
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * 
         * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
         * @default 5 for ALBs, 3 for NLBs
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getHealthyThresholdCount() {
            return this.jsiiGet("healthyThresholdCount", java.lang.Number.class);
        }

        /**
         * The number of consecutive health checks successes required before considering an unhealthy target healthy.
         * 
         * For Application Load Balancers, the default is 5. For Network Load Balancers, the default is 3.
         * @default 5 for ALBs, 3 for NLBs
         */
        @Override
        public void setHealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("healthyThresholdCount", value);
        }

        /**
         * The approximate number of seconds between health checks for an individual target.
         * @default 30
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getIntervalSecs() {
            return this.jsiiGet("intervalSecs", java.lang.Number.class);
        }

        /**
         * The approximate number of seconds between health checks for an individual target.
         * @default 30
         */
        @Override
        public void setIntervalSecs(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("intervalSecs", value);
        }

        /**
         * The ping path destination where Elastic Load Balancing sends health check requests.
         * @default /
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPath() {
            return this.jsiiGet("path", java.lang.String.class);
        }

        /**
         * The ping path destination where Elastic Load Balancing sends health check requests.
         * @default /
         */
        @Override
        public void setPath(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("path", value);
        }

        /**
         * The port that the load balancer uses when performing health checks on the targets.
         * @default 'traffic-port'
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPort() {
            return this.jsiiGet("port", java.lang.String.class);
        }

        /**
         * The port that the load balancer uses when performing health checks on the targets.
         * @default 'traffic-port'
         */
        @Override
        public void setPort(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("port", value);
        }

        /**
         * The protocol the load balancer uses when performing health checks on targets.
         * 
         * The TCP protocol is supported only if the protocol of the target group
         * is TCP.
         * @default HTTP for ALBs, TCP for NLBs
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class);
        }

        /**
         * The protocol the load balancer uses when performing health checks on targets.
         * 
         * The TCP protocol is supported only if the protocol of the target group
         * is TCP.
         * @default HTTP for ALBs, TCP for NLBs
         */
        @Override
        public void setProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol value) {
            this.jsiiSet("protocol", value);
        }

        /**
         * The amount of time, in seconds, during which no response from a target means a failed health check.
         * 
         * For Application Load Balancers, the range is 2–60 seconds and the
         * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
         * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
         * @default 5 for ALBs, 10 or 6 for NLBs
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getTimeoutSeconds() {
            return this.jsiiGet("timeoutSeconds", java.lang.Number.class);
        }

        /**
         * The amount of time, in seconds, during which no response from a target means a failed health check.
         * 
         * For Application Load Balancers, the range is 2–60 seconds and the
         * default is 5 seconds. For Network Load Balancers, this is 10 seconds for
         * TCP and HTTPS health checks and 6 seconds for HTTP health checks.
         * @default 5 for ALBs, 10 or 6 for NLBs
         */
        @Override
        public void setTimeoutSeconds(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("timeoutSeconds", value);
        }

        /**
         * The number of consecutive health check failures required before considering a target unhealthy.
         * 
         * For Application Load Balancers, the default is 2. For Network Load
         * Balancers, this value must be the same as the healthy threshold count.
         * @default 2
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getUnhealthyThresholdCount() {
            return this.jsiiGet("unhealthyThresholdCount", java.lang.Number.class);
        }

        /**
         * The number of consecutive health check failures required before considering a target unhealthy.
         * 
         * For Application Load Balancers, the default is 2. For Network Load
         * Balancers, this value must be the same as the healthy threshold count.
         * @default 2
         */
        @Override
        public void setUnhealthyThresholdCount(@javax.annotation.Nullable final java.lang.Number value) {
            this.jsiiSet("unhealthyThresholdCount", value);
        }
    }
}
