package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for an ApplicationListener
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:37:24.768Z")
public interface BaseApplicationListenerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The certificates to use on this listener
     */
    java.util.List<java.lang.String> getCertificateArns();
    /**
     * Default target groups to load balance to
     * @default None
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups();
    /**
     * Allow anyone to connect to this listener
     * 
     * If this is specified, the listener will be opened up to anyone who can reach it.
     * For internal load balancers this is anyone in the same VPC. For public load
     * balancers, this is anyone on the internet.
     * 
     * If you want to be more selective about who can access this load
     * balancer, set this to `false` and use the listener's `connections`
     * object to selectively grant access to the listener.
     * @default true
     */
    java.lang.Boolean getOpen();
    /**
     * The port on which the listener listens for requests.
     * @default Determined from protocol if known
     */
    java.lang.Number getPort();
    /**
     * The protocol to use
     * @default Determined from port if known
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol();
    /**
     * The security policy that defines which ciphers and protocols are supported.
     * @default the current predefined security policy.
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy();

    /**
     * @return a {@link Builder} of {@link BaseApplicationListenerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BaseApplicationListenerProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _certificateArns;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> _defaultTargetGroups;
        @javax.annotation.Nullable
        private java.lang.Boolean _open;
        @javax.annotation.Nullable
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol _protocol;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy _sslPolicy;

        /**
         * Sets the value of CertificateArns
         * @param value The certificates to use on this listener
         * @return {@code this}
         */
        public Builder withCertificateArns(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._certificateArns = value;
            return this;
        }
        /**
         * Sets the value of DefaultTargetGroups
         * @param value Default target groups to load balance to
         * @return {@code this}
         */
        public Builder withDefaultTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this._defaultTargetGroups = value;
            return this;
        }
        /**
         * Sets the value of Open
         * @param value Allow anyone to connect to this listener

If this is specified, the listener will be opened up to anyone who can reach it.
For internal load balancers this is anyone in the same VPC. For public load
balancers, this is anyone on the internet.

If you want to be more selective about who can access this load
balancer, set this to `false` and use the listener's `connections`
object to selectively grant access to the listener.
         * @return {@code this}
         */
        public Builder withOpen(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._open = value;
            return this;
        }
        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        public Builder withPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._port = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The protocol to use
         * @return {@code this}
         */
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of SslPolicy
         * @param value The security policy that defines which ciphers and protocols are supported.
         * @return {@code this}
         */
        public Builder withSslPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy value) {
            this._sslPolicy = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseApplicationListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BaseApplicationListenerProps build() {
            return new BaseApplicationListenerProps() {
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $certificateArns = _certificateArns;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> $defaultTargetGroups = _defaultTargetGroups;
                @javax.annotation.Nullable
                private final java.lang.Boolean $open = _open;
                @javax.annotation.Nullable
                private final java.lang.Number $port = _port;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy $sslPolicy = _sslPolicy;

                @Override
                public java.util.List<java.lang.String> getCertificateArns() {
                    return this.$certificateArns;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups() {
                    return this.$defaultTargetGroups;
                }

                @Override
                public java.lang.Boolean getOpen() {
                    return this.$open;
                }

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
                    return this.$sslPolicy;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("certificateArns", om.valueToTree(this.getCertificateArns()));
                    obj.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
                    obj.set("open", om.valueToTree(this.getOpen()));
                    obj.set("port", om.valueToTree(this.getPort()));
                    obj.set("protocol", om.valueToTree(this.getProtocol()));
                    obj.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The certificates to use on this listener
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getCertificateArns() {
            return this.jsiiGet("certificateArns", java.util.List.class);
        }

        /**
         * Default target groups to load balance to
         * @default None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getDefaultTargetGroups() {
            return this.jsiiGet("defaultTargetGroups", java.util.List.class);
        }

        /**
         * Allow anyone to connect to this listener
         * 
         * If this is specified, the listener will be opened up to anyone who can reach it.
         * For internal load balancers this is anyone in the same VPC. For public load
         * balancers, this is anyone on the internet.
         * 
         * If you want to be more selective about who can access this load
         * balancer, set this to `false` and use the listener's `connections`
         * object to selectively grant access to the listener.
         * @default true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getOpen() {
            return this.jsiiGet("open", java.lang.Boolean.class);
        }

        /**
         * The port on which the listener listens for requests.
         * @default Determined from protocol if known
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The protocol to use
         * @default Determined from port if known
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
        }

        /**
         * The security policy that defines which ciphers and protocols are supported.
         * @default the current predefined security policy.
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.jsiiGet("sslPolicy", software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class);
        }
    }
}
