package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a Network Listener attached to a Load Balancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-03-28T21:37:24.857Z")
public interface NetworkListenerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps {
    /**
     * The load balancer to attach this listener to
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer();

    /**
     * @return a {@link Builder} of {@link NetworkListenerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NetworkListenerProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer _loadBalancer;
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> _defaultTargetGroups;

        /**
         * Sets the value of LoadBalancer
         * @param value The load balancer to attach this listener to
         * @return {@code this}
         */
        public Builder withLoadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer value) {
            this._loadBalancer = java.util.Objects.requireNonNull(value, "loadBalancer is required");
            return this;
        }
        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of DefaultTargetGroups
         * @param value Default target groups to load balance to
         * @return {@code this}
         */
        public Builder withDefaultTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> value) {
            this._defaultTargetGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public NetworkListenerProps build() {
            return new NetworkListenerProps() {
                private final software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer $loadBalancer = java.util.Objects.requireNonNull(_loadBalancer, "loadBalancer is required");
                private final java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> $defaultTargetGroups = _defaultTargetGroups;

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
                    return this.$defaultTargetGroups;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("loadBalancer", om.valueToTree(this.getLoadBalancer()));
                    obj.set("port", om.valueToTree(this.getPort()));
                    obj.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListenerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The load balancer to attach this listener to
         */
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer getLoadBalancer() {
            return this.jsiiGet("loadBalancer", software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer.class);
        }

        /**
         * The port on which the listener listens for requests.
         */
        @Override
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * Default target groups to load balance to
         * @default None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
            return this.jsiiGet("defaultTargetGroups", java.util.List.class);
        }
    }
}
