package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a set of certificates to a listener
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:07:39.215Z")
public interface ApplicationListenerCertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARNs of certificates to attach
     * 
     * Duplicates are not allowed.
     */
    java.util.List<java.lang.String> getCertificateArns();
    /**
     * The listener to attach the rule to
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerCertificateProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerCertificateProps}
     */
    final class Builder {
        private java.util.List<java.lang.String> _certificateArns;
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener _listener;

        /**
         * Sets the value of CertificateArns
         * @param value ARNs of certificates to attach

Duplicates are not allowed.
         * @return {@code this}
         */
        public Builder withCertificateArns(final java.util.List<java.lang.String> value) {
            this._certificateArns = java.util.Objects.requireNonNull(value, "certificateArns is required");
            return this;
        }
        /**
         * Sets the value of Listener
         * @param value The listener to attach the rule to
         * @return {@code this}
         */
        public Builder withListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener value) {
            this._listener = java.util.Objects.requireNonNull(value, "listener is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApplicationListenerCertificateProps build() {
            return new ApplicationListenerCertificateProps() {
                private final java.util.List<java.lang.String> $certificateArns = java.util.Objects.requireNonNull(_certificateArns, "certificateArns is required");
                private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener $listener = java.util.Objects.requireNonNull(_listener, "listener is required");

                @Override
                public java.util.List<java.lang.String> getCertificateArns() {
                    return this.$certificateArns;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
                    return this.$listener;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("certificateArns", om.valueToTree(this.getCertificateArns()));
                    obj.set("listener", om.valueToTree(this.getListener()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerCertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARNs of certificates to attach
         * 
         * Duplicates are not allowed.
         */
        @Override
        public java.util.List<java.lang.String> getCertificateArns() {
            return this.jsiiGet("certificateArns", java.util.List.class);
        }

        /**
         * The listener to attach the rule to
         */
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.jsiiGet("listener", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class);
        }
    }
}
