package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing load balancer
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.8.2 (build e9eb3c9)", date = "2019-04-04T15:07:39.220Z")
public interface ApplicationLoadBalancerImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARN of the load balancer
     */
    java.lang.String getLoadBalancerArn();
    /**
     * ID of the load balancer's security group
     */
    java.lang.String getSecurityGroupId();

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationLoadBalancerImportProps}
     */
    final class Builder {
        private java.lang.String _loadBalancerArn;
        private java.lang.String _securityGroupId;

        /**
         * Sets the value of LoadBalancerArn
         * @param value ARN of the load balancer
         * @return {@code this}
         */
        public Builder withLoadBalancerArn(final java.lang.String value) {
            this._loadBalancerArn = java.util.Objects.requireNonNull(value, "loadBalancerArn is required");
            return this;
        }
        /**
         * Sets the value of SecurityGroupId
         * @param value ID of the load balancer's security group
         * @return {@code this}
         */
        public Builder withSecurityGroupId(final java.lang.String value) {
            this._securityGroupId = java.util.Objects.requireNonNull(value, "securityGroupId is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApplicationLoadBalancerImportProps build() {
            return new ApplicationLoadBalancerImportProps() {
                private final java.lang.String $loadBalancerArn = java.util.Objects.requireNonNull(_loadBalancerArn, "loadBalancerArn is required");
                private final java.lang.String $securityGroupId = java.util.Objects.requireNonNull(_securityGroupId, "securityGroupId is required");

                @Override
                public java.lang.String getLoadBalancerArn() {
                    return this.$loadBalancerArn;
                }

                @Override
                public java.lang.String getSecurityGroupId() {
                    return this.$securityGroupId;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
                    obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARN of the load balancer
         */
        @Override
        public java.lang.String getLoadBalancerArn() {
            return this.jsiiGet("loadBalancerArn", java.lang.String.class);
        }

        /**
         * ID of the load balancer's security group
         */
        @Override
        public java.lang.String getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", java.lang.String.class);
        }
    }
}
