package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for a Network Listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:04:53.420Z")
public interface BaseNetworkListenerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The port on which the listener listens for requests.
     */
    java.lang.Number getPort();
    /**
     * Default target groups to load balance to.
     * 
     * Default: None
     */
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups();

    /**
     * @return a {@link Builder} of {@link BaseNetworkListenerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BaseNetworkListenerProps}
     */
    final class Builder {
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> _defaultTargetGroups;

        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of DefaultTargetGroups
         * @param value Default target groups to load balance to.
         * @return {@code this}
         */
        public Builder withDefaultTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> value) {
            this._defaultTargetGroups = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseNetworkListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public BaseNetworkListenerProps build() {
            return new BaseNetworkListenerProps() {
                private final java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> $defaultTargetGroups = _defaultTargetGroups;

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
                    return this.$defaultTargetGroups;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree(this.getPort()));
                    obj.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The port on which the listener listens for requests.
         */
        @Override
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * Default target groups to load balance to.
         * 
         * Default: None
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
            return this.jsiiGet("defaultTargetGroups", java.util.List.class);
        }
    }
}
