package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * A CloudFormation `AWS::ElasticLoadBalancingV2::Listener`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listener.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:12:43.379Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.CfnListener")
public class CfnListener extends software.amazon.awscdk.CfnResource {
    protected CfnListener(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Create a new `AWS::ElasticLoadBalancingV2::Listener`.
     * 
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     */
    public CfnListener(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(@javax.annotation.Nullable final java.lang.Object properties) {
        return this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { properties });
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public java.lang.String getListenerArn() {
        return this.jsiiGet("listenerArn", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps getPropertyOverrides() {
        return this.jsiiGet("propertyOverrides", software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerProps.class);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html
     */
    public static interface ActionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListener.ActionProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
         */
        java.lang.String getType();
        /**
         * `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
         */
        java.lang.Object getAuthenticateCognitoConfig();
        /**
         * `CfnListener.ActionProperty.AuthenticateOidcConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
         */
        java.lang.Object getAuthenticateOidcConfig();
        /**
         * `CfnListener.ActionProperty.FixedResponseConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
         */
        java.lang.Object getFixedResponseConfig();
        /**
         * `CfnListener.ActionProperty.Order`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
         */
        java.lang.Object getOrder();
        /**
         * `CfnListener.ActionProperty.RedirectConfig`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
         */
        java.lang.Object getRedirectConfig();
        /**
         * `CfnListener.ActionProperty.TargetGroupArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
         */
        java.lang.String getTargetGroupArn();

        /**
         * @return a {@link Builder} of {@link ActionProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link ActionProperty}
         */
        final class Builder {
            private java.lang.String _type;
            @javax.annotation.Nullable
            private java.lang.Object _authenticateCognitoConfig;
            @javax.annotation.Nullable
            private java.lang.Object _authenticateOidcConfig;
            @javax.annotation.Nullable
            private java.lang.Object _fixedResponseConfig;
            @javax.annotation.Nullable
            private java.lang.Object _order;
            @javax.annotation.Nullable
            private java.lang.Object _redirectConfig;
            @javax.annotation.Nullable
            private java.lang.String _targetGroupArn;

            /**
             * Sets the value of Type
             * @param value `CfnListener.ActionProperty.Type`.
             * @return {@code this}
             */
            public Builder withType(final java.lang.String value) {
                this._type = java.util.Objects.requireNonNull(value, "type is required");
                return this;
            }
            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param value `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            public Builder withAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticateCognitoConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateCognitoConfig
             * @param value `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
             * @return {@code this}
             */
            public Builder withAuthenticateCognitoConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty value) {
                this._authenticateCognitoConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateOidcConfig
             * @param value `CfnListener.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            public Builder withAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticateOidcConfig = value;
                return this;
            }
            /**
             * Sets the value of AuthenticateOidcConfig
             * @param value `CfnListener.ActionProperty.AuthenticateOidcConfig`.
             * @return {@code this}
             */
            public Builder withAuthenticateOidcConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty value) {
                this._authenticateOidcConfig = value;
                return this;
            }
            /**
             * Sets the value of FixedResponseConfig
             * @param value `CfnListener.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            public Builder withFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._fixedResponseConfig = value;
                return this;
            }
            /**
             * Sets the value of FixedResponseConfig
             * @param value `CfnListener.ActionProperty.FixedResponseConfig`.
             * @return {@code this}
             */
            public Builder withFixedResponseConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty value) {
                this._fixedResponseConfig = value;
                return this;
            }
            /**
             * Sets the value of Order
             * @param value `CfnListener.ActionProperty.Order`.
             * @return {@code this}
             */
            public Builder withOrder(@javax.annotation.Nullable final java.lang.Number value) {
                this._order = value;
                return this;
            }
            /**
             * Sets the value of Order
             * @param value `CfnListener.ActionProperty.Order`.
             * @return {@code this}
             */
            public Builder withOrder(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._order = value;
                return this;
            }
            /**
             * Sets the value of RedirectConfig
             * @param value `CfnListener.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            public Builder withRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._redirectConfig = value;
                return this;
            }
            /**
             * Sets the value of RedirectConfig
             * @param value `CfnListener.ActionProperty.RedirectConfig`.
             * @return {@code this}
             */
            public Builder withRedirectConfig(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.RedirectConfigProperty value) {
                this._redirectConfig = value;
                return this;
            }
            /**
             * Sets the value of TargetGroupArn
             * @param value `CfnListener.ActionProperty.TargetGroupArn`.
             * @return {@code this}
             */
            public Builder withTargetGroupArn(@javax.annotation.Nullable final java.lang.String value) {
                this._targetGroupArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public ActionProperty build() {
                return new ActionProperty() {
                    private final java.lang.String $type = java.util.Objects.requireNonNull(_type, "type is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticateCognitoConfig = _authenticateCognitoConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticateOidcConfig = _authenticateOidcConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $fixedResponseConfig = _fixedResponseConfig;
                    @javax.annotation.Nullable
                    private final java.lang.Object $order = _order;
                    @javax.annotation.Nullable
                    private final java.lang.Object $redirectConfig = _redirectConfig;
                    @javax.annotation.Nullable
                    private final java.lang.String $targetGroupArn = _targetGroupArn;

                    @Override
                    public java.lang.String getType() {
                        return this.$type;
                    }

                    @Override
                    public java.lang.Object getAuthenticateCognitoConfig() {
                        return this.$authenticateCognitoConfig;
                    }

                    @Override
                    public java.lang.Object getAuthenticateOidcConfig() {
                        return this.$authenticateOidcConfig;
                    }

                    @Override
                    public java.lang.Object getFixedResponseConfig() {
                        return this.$fixedResponseConfig;
                    }

                    @Override
                    public java.lang.Object getOrder() {
                        return this.$order;
                    }

                    @Override
                    public java.lang.Object getRedirectConfig() {
                        return this.$redirectConfig;
                    }

                    @Override
                    public java.lang.String getTargetGroupArn() {
                        return this.$targetGroupArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("type", om.valueToTree(this.getType()));
                        obj.set("authenticateCognitoConfig", om.valueToTree(this.getAuthenticateCognitoConfig()));
                        obj.set("authenticateOidcConfig", om.valueToTree(this.getAuthenticateOidcConfig()));
                        obj.set("fixedResponseConfig", om.valueToTree(this.getFixedResponseConfig()));
                        obj.set("order", om.valueToTree(this.getOrder()));
                        obj.set("redirectConfig", om.valueToTree(this.getRedirectConfig()));
                        obj.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.ActionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListener.ActionProperty.Type`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-type
             */
            @Override
            public java.lang.String getType() {
                return this.jsiiGet("type", java.lang.String.class);
            }

            /**
             * `CfnListener.ActionProperty.AuthenticateCognitoConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticatecognitoconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticateCognitoConfig() {
                return this.jsiiGet("authenticateCognitoConfig", java.lang.Object.class);
            }

            /**
             * `CfnListener.ActionProperty.AuthenticateOidcConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-authenticateoidcconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticateOidcConfig() {
                return this.jsiiGet("authenticateOidcConfig", java.lang.Object.class);
            }

            /**
             * `CfnListener.ActionProperty.FixedResponseConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-fixedresponseconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getFixedResponseConfig() {
                return this.jsiiGet("fixedResponseConfig", java.lang.Object.class);
            }

            /**
             * `CfnListener.ActionProperty.Order`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-order
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getOrder() {
                return this.jsiiGet("order", java.lang.Object.class);
            }

            /**
             * `CfnListener.ActionProperty.RedirectConfig`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-action-redirectconfig
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRedirectConfig() {
                return this.jsiiGet("redirectConfig", java.lang.Object.class);
            }

            /**
             * `CfnListener.ActionProperty.TargetGroupArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-defaultactions.html#cfn-elasticloadbalancingv2-listener-defaultactions-targetgrouparn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getTargetGroupArn() {
                return this.jsiiGet("targetGroupArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html
     */
    public static interface AuthenticateCognitoConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
         */
        java.lang.String getUserPoolArn();
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolClientId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
         */
        java.lang.String getUserPoolClientId();
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolDomain`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
         */
        java.lang.String getUserPoolDomain();
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
         */
        java.lang.Object getAuthenticationRequestExtraParams();
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
         */
        java.lang.String getOnUnauthenticatedRequest();
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.Scope`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
         */
        java.lang.String getScope();
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionCookieName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
         */
        java.lang.String getSessionCookieName();
        /**
         * `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
         */
        java.lang.Object getSessionTimeout();

        /**
         * @return a {@link Builder} of {@link AuthenticateCognitoConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AuthenticateCognitoConfigProperty}
         */
        final class Builder {
            private java.lang.String _userPoolArn;
            private java.lang.String _userPoolClientId;
            private java.lang.String _userPoolDomain;
            @javax.annotation.Nullable
            private java.lang.Object _authenticationRequestExtraParams;
            @javax.annotation.Nullable
            private java.lang.String _onUnauthenticatedRequest;
            @javax.annotation.Nullable
            private java.lang.String _scope;
            @javax.annotation.Nullable
            private java.lang.String _sessionCookieName;
            @javax.annotation.Nullable
            private java.lang.Object _sessionTimeout;

            /**
             * Sets the value of UserPoolArn
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.UserPoolArn`.
             * @return {@code this}
             */
            public Builder withUserPoolArn(final java.lang.String value) {
                this._userPoolArn = java.util.Objects.requireNonNull(value, "userPoolArn is required");
                return this;
            }
            /**
             * Sets the value of UserPoolClientId
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.UserPoolClientId`.
             * @return {@code this}
             */
            public Builder withUserPoolClientId(final java.lang.String value) {
                this._userPoolClientId = java.util.Objects.requireNonNull(value, "userPoolClientId is required");
                return this;
            }
            /**
             * Sets the value of UserPoolDomain
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.UserPoolDomain`.
             * @return {@code this}
             */
            public Builder withUserPoolDomain(final java.lang.String value) {
                this._userPoolDomain = java.util.Objects.requireNonNull(value, "userPoolDomain is required");
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.Scope`.
             * @return {@code this}
             */
            public Builder withScope(@javax.annotation.Nullable final java.lang.String value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            public Builder withSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this._sessionTimeout = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sessionTimeout = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateCognitoConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AuthenticateCognitoConfigProperty build() {
                return new AuthenticateCognitoConfigProperty() {
                    private final java.lang.String $userPoolArn = java.util.Objects.requireNonNull(_userPoolArn, "userPoolArn is required");
                    private final java.lang.String $userPoolClientId = java.util.Objects.requireNonNull(_userPoolClientId, "userPoolClientId is required");
                    private final java.lang.String $userPoolDomain = java.util.Objects.requireNonNull(_userPoolDomain, "userPoolDomain is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticationRequestExtraParams = _authenticationRequestExtraParams;
                    @javax.annotation.Nullable
                    private final java.lang.String $onUnauthenticatedRequest = _onUnauthenticatedRequest;
                    @javax.annotation.Nullable
                    private final java.lang.String $scope = _scope;
                    @javax.annotation.Nullable
                    private final java.lang.String $sessionCookieName = _sessionCookieName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sessionTimeout = _sessionTimeout;

                    @Override
                    public java.lang.String getUserPoolArn() {
                        return this.$userPoolArn;
                    }

                    @Override
                    public java.lang.String getUserPoolClientId() {
                        return this.$userPoolClientId;
                    }

                    @Override
                    public java.lang.String getUserPoolDomain() {
                        return this.$userPoolDomain;
                    }

                    @Override
                    public java.lang.Object getAuthenticationRequestExtraParams() {
                        return this.$authenticationRequestExtraParams;
                    }

                    @Override
                    public java.lang.String getOnUnauthenticatedRequest() {
                        return this.$onUnauthenticatedRequest;
                    }

                    @Override
                    public java.lang.String getScope() {
                        return this.$scope;
                    }

                    @Override
                    public java.lang.String getSessionCookieName() {
                        return this.$sessionCookieName;
                    }

                    @Override
                    public java.lang.Object getSessionTimeout() {
                        return this.$sessionTimeout;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("userPoolArn", om.valueToTree(this.getUserPoolArn()));
                        obj.set("userPoolClientId", om.valueToTree(this.getUserPoolClientId()));
                        obj.set("userPoolDomain", om.valueToTree(this.getUserPoolDomain()));
                        obj.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                        obj.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                        obj.set("scope", om.valueToTree(this.getScope()));
                        obj.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                        obj.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateCognitoConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolarn
             */
            @Override
            public java.lang.String getUserPoolArn() {
                return this.jsiiGet("userPoolArn", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolClientId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpoolclientid
             */
            @Override
            public java.lang.String getUserPoolClientId() {
                return this.jsiiGet("userPoolClientId", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.UserPoolDomain`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-userpooldomain
             */
            @Override
            public java.lang.String getUserPoolDomain() {
                return this.jsiiGet("userPoolDomain", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.AuthenticationRequestExtraParams`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-authenticationrequestextraparams
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.OnUnauthenticatedRequest`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-onunauthenticatedrequest
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.Scope`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-scope
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getScope() {
                return this.jsiiGet("scope", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.SessionCookieName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessioncookiename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSessionCookieName() {
                return this.jsiiGet("sessionCookieName", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateCognitoConfigProperty.SessionTimeout`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticatecognitoconfig.html#cfn-elasticloadbalancingv2-listener-authenticatecognitoconfig-sessiontimeout
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSessionTimeout() {
                return this.jsiiGet("sessionTimeout", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html
     */
    public static interface AuthenticateOidcConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
         */
        java.lang.String getAuthorizationEndpoint();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
         */
        java.lang.String getClientId();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.ClientSecret`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
         */
        java.lang.String getClientSecret();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Issuer`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
         */
        java.lang.String getIssuer();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.TokenEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
         */
        java.lang.String getTokenEndpoint();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
         */
        java.lang.String getUserInfoEndpoint();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
         */
        java.lang.Object getAuthenticationRequestExtraParams();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
         */
        java.lang.String getOnUnauthenticatedRequest();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.Scope`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
         */
        java.lang.String getScope();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionCookieName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
         */
        java.lang.String getSessionCookieName();
        /**
         * `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
         */
        java.lang.Object getSessionTimeout();

        /**
         * @return a {@link Builder} of {@link AuthenticateOidcConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link AuthenticateOidcConfigProperty}
         */
        final class Builder {
            private java.lang.String _authorizationEndpoint;
            private java.lang.String _clientId;
            private java.lang.String _clientSecret;
            private java.lang.String _issuer;
            private java.lang.String _tokenEndpoint;
            private java.lang.String _userInfoEndpoint;
            @javax.annotation.Nullable
            private java.lang.Object _authenticationRequestExtraParams;
            @javax.annotation.Nullable
            private java.lang.String _onUnauthenticatedRequest;
            @javax.annotation.Nullable
            private java.lang.String _scope;
            @javax.annotation.Nullable
            private java.lang.String _sessionCookieName;
            @javax.annotation.Nullable
            private java.lang.Object _sessionTimeout;

            /**
             * Sets the value of AuthorizationEndpoint
             * @param value `CfnListener.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
             * @return {@code this}
             */
            public Builder withAuthorizationEndpoint(final java.lang.String value) {
                this._authorizationEndpoint = java.util.Objects.requireNonNull(value, "authorizationEndpoint is required");
                return this;
            }
            /**
             * Sets the value of ClientId
             * @param value `CfnListener.AuthenticateOidcConfigProperty.ClientId`.
             * @return {@code this}
             */
            public Builder withClientId(final java.lang.String value) {
                this._clientId = java.util.Objects.requireNonNull(value, "clientId is required");
                return this;
            }
            /**
             * Sets the value of ClientSecret
             * @param value `CfnListener.AuthenticateOidcConfigProperty.ClientSecret`.
             * @return {@code this}
             */
            public Builder withClientSecret(final java.lang.String value) {
                this._clientSecret = java.util.Objects.requireNonNull(value, "clientSecret is required");
                return this;
            }
            /**
             * Sets the value of Issuer
             * @param value `CfnListener.AuthenticateOidcConfigProperty.Issuer`.
             * @return {@code this}
             */
            public Builder withIssuer(final java.lang.String value) {
                this._issuer = java.util.Objects.requireNonNull(value, "issuer is required");
                return this;
            }
            /**
             * Sets the value of TokenEndpoint
             * @param value `CfnListener.AuthenticateOidcConfigProperty.TokenEndpoint`.
             * @return {@code this}
             */
            public Builder withTokenEndpoint(final java.lang.String value) {
                this._tokenEndpoint = java.util.Objects.requireNonNull(value, "tokenEndpoint is required");
                return this;
            }
            /**
             * Sets the value of UserInfoEndpoint
             * @param value `CfnListener.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
             * @return {@code this}
             */
            public Builder withUserInfoEndpoint(final java.lang.String value) {
                this._userInfoEndpoint = java.util.Objects.requireNonNull(value, "userInfoEndpoint is required");
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of AuthenticationRequestExtraParams
             * @param value `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * @return {@code this}
             */
            public Builder withAuthenticationRequestExtraParams(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                this._authenticationRequestExtraParams = value;
                return this;
            }
            /**
             * Sets the value of OnUnauthenticatedRequest
             * @param value `CfnListener.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
             * @return {@code this}
             */
            public Builder withOnUnauthenticatedRequest(@javax.annotation.Nullable final java.lang.String value) {
                this._onUnauthenticatedRequest = value;
                return this;
            }
            /**
             * Sets the value of Scope
             * @param value `CfnListener.AuthenticateOidcConfigProperty.Scope`.
             * @return {@code this}
             */
            public Builder withScope(@javax.annotation.Nullable final java.lang.String value) {
                this._scope = value;
                return this;
            }
            /**
             * Sets the value of SessionCookieName
             * @param value `CfnListener.AuthenticateOidcConfigProperty.SessionCookieName`.
             * @return {@code this}
             */
            public Builder withSessionCookieName(@javax.annotation.Nullable final java.lang.String value) {
                this._sessionCookieName = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final java.lang.Number value) {
                this._sessionTimeout = value;
                return this;
            }
            /**
             * Sets the value of SessionTimeout
             * @param value `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
             * @return {@code this}
             */
            public Builder withSessionTimeout(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this._sessionTimeout = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticateOidcConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public AuthenticateOidcConfigProperty build() {
                return new AuthenticateOidcConfigProperty() {
                    private final java.lang.String $authorizationEndpoint = java.util.Objects.requireNonNull(_authorizationEndpoint, "authorizationEndpoint is required");
                    private final java.lang.String $clientId = java.util.Objects.requireNonNull(_clientId, "clientId is required");
                    private final java.lang.String $clientSecret = java.util.Objects.requireNonNull(_clientSecret, "clientSecret is required");
                    private final java.lang.String $issuer = java.util.Objects.requireNonNull(_issuer, "issuer is required");
                    private final java.lang.String $tokenEndpoint = java.util.Objects.requireNonNull(_tokenEndpoint, "tokenEndpoint is required");
                    private final java.lang.String $userInfoEndpoint = java.util.Objects.requireNonNull(_userInfoEndpoint, "userInfoEndpoint is required");
                    @javax.annotation.Nullable
                    private final java.lang.Object $authenticationRequestExtraParams = _authenticationRequestExtraParams;
                    @javax.annotation.Nullable
                    private final java.lang.String $onUnauthenticatedRequest = _onUnauthenticatedRequest;
                    @javax.annotation.Nullable
                    private final java.lang.String $scope = _scope;
                    @javax.annotation.Nullable
                    private final java.lang.String $sessionCookieName = _sessionCookieName;
                    @javax.annotation.Nullable
                    private final java.lang.Object $sessionTimeout = _sessionTimeout;

                    @Override
                    public java.lang.String getAuthorizationEndpoint() {
                        return this.$authorizationEndpoint;
                    }

                    @Override
                    public java.lang.String getClientId() {
                        return this.$clientId;
                    }

                    @Override
                    public java.lang.String getClientSecret() {
                        return this.$clientSecret;
                    }

                    @Override
                    public java.lang.String getIssuer() {
                        return this.$issuer;
                    }

                    @Override
                    public java.lang.String getTokenEndpoint() {
                        return this.$tokenEndpoint;
                    }

                    @Override
                    public java.lang.String getUserInfoEndpoint() {
                        return this.$userInfoEndpoint;
                    }

                    @Override
                    public java.lang.Object getAuthenticationRequestExtraParams() {
                        return this.$authenticationRequestExtraParams;
                    }

                    @Override
                    public java.lang.String getOnUnauthenticatedRequest() {
                        return this.$onUnauthenticatedRequest;
                    }

                    @Override
                    public java.lang.String getScope() {
                        return this.$scope;
                    }

                    @Override
                    public java.lang.String getSessionCookieName() {
                        return this.$sessionCookieName;
                    }

                    @Override
                    public java.lang.Object getSessionTimeout() {
                        return this.$sessionTimeout;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("authorizationEndpoint", om.valueToTree(this.getAuthorizationEndpoint()));
                        obj.set("clientId", om.valueToTree(this.getClientId()));
                        obj.set("clientSecret", om.valueToTree(this.getClientSecret()));
                        obj.set("issuer", om.valueToTree(this.getIssuer()));
                        obj.set("tokenEndpoint", om.valueToTree(this.getTokenEndpoint()));
                        obj.set("userInfoEndpoint", om.valueToTree(this.getUserInfoEndpoint()));
                        obj.set("authenticationRequestExtraParams", om.valueToTree(this.getAuthenticationRequestExtraParams()));
                        obj.set("onUnauthenticatedRequest", om.valueToTree(this.getOnUnauthenticatedRequest()));
                        obj.set("scope", om.valueToTree(this.getScope()));
                        obj.set("sessionCookieName", om.valueToTree(this.getSessionCookieName()));
                        obj.set("sessionTimeout", om.valueToTree(this.getSessionTimeout()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.AuthenticateOidcConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.AuthorizationEndpoint`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authorizationendpoint
             */
            @Override
            public java.lang.String getAuthorizationEndpoint() {
                return this.jsiiGet("authorizationEndpoint", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.ClientId`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientid
             */
            @Override
            public java.lang.String getClientId() {
                return this.jsiiGet("clientId", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.ClientSecret`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-clientsecret
             */
            @Override
            public java.lang.String getClientSecret() {
                return this.jsiiGet("clientSecret", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.Issuer`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-issuer
             */
            @Override
            public java.lang.String getIssuer() {
                return this.jsiiGet("issuer", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.TokenEndpoint`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-tokenendpoint
             */
            @Override
            public java.lang.String getTokenEndpoint() {
                return this.jsiiGet("tokenEndpoint", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.UserInfoEndpoint`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-userinfoendpoint
             */
            @Override
            public java.lang.String getUserInfoEndpoint() {
                return this.jsiiGet("userInfoEndpoint", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.AuthenticationRequestExtraParams`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-authenticationrequestextraparams
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getAuthenticationRequestExtraParams() {
                return this.jsiiGet("authenticationRequestExtraParams", java.lang.Object.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.OnUnauthenticatedRequest`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-onunauthenticatedrequest
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getOnUnauthenticatedRequest() {
                return this.jsiiGet("onUnauthenticatedRequest", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.Scope`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-scope
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getScope() {
                return this.jsiiGet("scope", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.SessionCookieName`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessioncookiename
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getSessionCookieName() {
                return this.jsiiGet("sessionCookieName", java.lang.String.class);
            }

            /**
             * `CfnListener.AuthenticateOidcConfigProperty.SessionTimeout`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-authenticateoidcconfig.html#cfn-elasticloadbalancingv2-listener-authenticateoidcconfig-sessiontimeout
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSessionTimeout() {
                return this.jsiiGet("sessionTimeout", java.lang.Object.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html
     */
    public static interface CertificateProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListener.CertificateProperty.CertificateArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
         */
        java.lang.String getCertificateArn();

        /**
         * @return a {@link Builder} of {@link CertificateProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link CertificateProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.String _certificateArn;

            /**
             * Sets the value of CertificateArn
             * @param value `CfnListener.CertificateProperty.CertificateArn`.
             * @return {@code this}
             */
            public Builder withCertificateArn(@javax.annotation.Nullable final java.lang.String value) {
                this._certificateArn = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public CertificateProperty build() {
                return new CertificateProperty() {
                    @javax.annotation.Nullable
                    private final java.lang.String $certificateArn = _certificateArn;

                    @Override
                    public java.lang.String getCertificateArn() {
                        return this.$certificateArn;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.CertificateProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListener.CertificateProperty.CertificateArn`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-certificates.html#cfn-elasticloadbalancingv2-listener-certificates-certificatearn
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getCertificateArn() {
                return this.jsiiGet("certificateArn", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html
     */
    public static interface FixedResponseConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListener.FixedResponseConfigProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
         */
        java.lang.String getStatusCode();
        /**
         * `CfnListener.FixedResponseConfigProperty.ContentType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
         */
        java.lang.String getContentType();
        /**
         * `CfnListener.FixedResponseConfigProperty.MessageBody`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
         */
        java.lang.String getMessageBody();

        /**
         * @return a {@link Builder} of {@link FixedResponseConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link FixedResponseConfigProperty}
         */
        final class Builder {
            private java.lang.String _statusCode;
            @javax.annotation.Nullable
            private java.lang.String _contentType;
            @javax.annotation.Nullable
            private java.lang.String _messageBody;

            /**
             * Sets the value of StatusCode
             * @param value `CfnListener.FixedResponseConfigProperty.StatusCode`.
             * @return {@code this}
             */
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of ContentType
             * @param value `CfnListener.FixedResponseConfigProperty.ContentType`.
             * @return {@code this}
             */
            public Builder withContentType(@javax.annotation.Nullable final java.lang.String value) {
                this._contentType = value;
                return this;
            }
            /**
             * Sets the value of MessageBody
             * @param value `CfnListener.FixedResponseConfigProperty.MessageBody`.
             * @return {@code this}
             */
            public Builder withMessageBody(@javax.annotation.Nullable final java.lang.String value) {
                this._messageBody = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FixedResponseConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public FixedResponseConfigProperty build() {
                return new FixedResponseConfigProperty() {
                    private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $contentType = _contentType;
                    @javax.annotation.Nullable
                    private final java.lang.String $messageBody = _messageBody;

                    @Override
                    public java.lang.String getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public java.lang.String getContentType() {
                        return this.$contentType;
                    }

                    @Override
                    public java.lang.String getMessageBody() {
                        return this.$messageBody;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                        obj.set("contentType", om.valueToTree(this.getContentType()));
                        obj.set("messageBody", om.valueToTree(this.getMessageBody()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.FixedResponseConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListener.FixedResponseConfigProperty.StatusCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-statuscode
             */
            @Override
            public java.lang.String getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.String.class);
            }

            /**
             * `CfnListener.FixedResponseConfigProperty.ContentType`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-contenttype
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getContentType() {
                return this.jsiiGet("contentType", java.lang.String.class);
            }

            /**
             * `CfnListener.FixedResponseConfigProperty.MessageBody`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-fixedresponseconfig.html#cfn-elasticloadbalancingv2-listener-fixedresponseconfig-messagebody
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getMessageBody() {
                return this.jsiiGet("messageBody", java.lang.String.class);
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html
     */
    public static interface RedirectConfigProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * `CfnListener.RedirectConfigProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
         */
        java.lang.String getStatusCode();
        /**
         * `CfnListener.RedirectConfigProperty.Host`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
         */
        java.lang.String getHost();
        /**
         * `CfnListener.RedirectConfigProperty.Path`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
         */
        java.lang.String getPath();
        /**
         * `CfnListener.RedirectConfigProperty.Port`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
         */
        java.lang.String getPort();
        /**
         * `CfnListener.RedirectConfigProperty.Protocol`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
         */
        java.lang.String getProtocol();
        /**
         * `CfnListener.RedirectConfigProperty.Query`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
         */
        java.lang.String getQuery();

        /**
         * @return a {@link Builder} of {@link RedirectConfigProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link RedirectConfigProperty}
         */
        final class Builder {
            private java.lang.String _statusCode;
            @javax.annotation.Nullable
            private java.lang.String _host;
            @javax.annotation.Nullable
            private java.lang.String _path;
            @javax.annotation.Nullable
            private java.lang.String _port;
            @javax.annotation.Nullable
            private java.lang.String _protocol;
            @javax.annotation.Nullable
            private java.lang.String _query;

            /**
             * Sets the value of StatusCode
             * @param value `CfnListener.RedirectConfigProperty.StatusCode`.
             * @return {@code this}
             */
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of Host
             * @param value `CfnListener.RedirectConfigProperty.Host`.
             * @return {@code this}
             */
            public Builder withHost(@javax.annotation.Nullable final java.lang.String value) {
                this._host = value;
                return this;
            }
            /**
             * Sets the value of Path
             * @param value `CfnListener.RedirectConfigProperty.Path`.
             * @return {@code this}
             */
            public Builder withPath(@javax.annotation.Nullable final java.lang.String value) {
                this._path = value;
                return this;
            }
            /**
             * Sets the value of Port
             * @param value `CfnListener.RedirectConfigProperty.Port`.
             * @return {@code this}
             */
            public Builder withPort(@javax.annotation.Nullable final java.lang.String value) {
                this._port = value;
                return this;
            }
            /**
             * Sets the value of Protocol
             * @param value `CfnListener.RedirectConfigProperty.Protocol`.
             * @return {@code this}
             */
            public Builder withProtocol(@javax.annotation.Nullable final java.lang.String value) {
                this._protocol = value;
                return this;
            }
            /**
             * Sets the value of Query
             * @param value `CfnListener.RedirectConfigProperty.Query`.
             * @return {@code this}
             */
            public Builder withQuery(@javax.annotation.Nullable final java.lang.String value) {
                this._query = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedirectConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public RedirectConfigProperty build() {
                return new RedirectConfigProperty() {
                    private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private final java.lang.String $host = _host;
                    @javax.annotation.Nullable
                    private final java.lang.String $path = _path;
                    @javax.annotation.Nullable
                    private final java.lang.String $port = _port;
                    @javax.annotation.Nullable
                    private final java.lang.String $protocol = _protocol;
                    @javax.annotation.Nullable
                    private final java.lang.String $query = _query;

                    @Override
                    public java.lang.String getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public java.lang.String getHost() {
                        return this.$host;
                    }

                    @Override
                    public java.lang.String getPath() {
                        return this.$path;
                    }

                    @Override
                    public java.lang.String getPort() {
                        return this.$port;
                    }

                    @Override
                    public java.lang.String getProtocol() {
                        return this.$protocol;
                    }

                    @Override
                    public java.lang.String getQuery() {
                        return this.$query;
                    }

                    public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                        com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                        com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                        obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                        obj.set("host", om.valueToTree(this.getHost()));
                        obj.set("path", om.valueToTree(this.getPath()));
                        obj.set("port", om.valueToTree(this.getPort()));
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                        obj.set("query", om.valueToTree(this.getQuery()));
                        return obj;
                    }

                };
            }
        }

        /**
         * A proxy class which represents a concrete javascript instance of this type.
         */
        final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListener.RedirectConfigProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * `CfnListener.RedirectConfigProperty.StatusCode`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-statuscode
             */
            @Override
            public java.lang.String getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.String.class);
            }

            /**
             * `CfnListener.RedirectConfigProperty.Host`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-host
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getHost() {
                return this.jsiiGet("host", java.lang.String.class);
            }

            /**
             * `CfnListener.RedirectConfigProperty.Path`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-path
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPath() {
                return this.jsiiGet("path", java.lang.String.class);
            }

            /**
             * `CfnListener.RedirectConfigProperty.Port`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-port
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getPort() {
                return this.jsiiGet("port", java.lang.String.class);
            }

            /**
             * `CfnListener.RedirectConfigProperty.Protocol`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-protocol
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getProtocol() {
                return this.jsiiGet("protocol", java.lang.String.class);
            }

            /**
             * `CfnListener.RedirectConfigProperty.Query`.
             * 
             * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticloadbalancingv2-listener-redirectconfig.html#cfn-elasticloadbalancingv2-listener-redirectconfig-query
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.String getQuery() {
                return this.jsiiGet("query", java.lang.String.class);
            }
        }
    }
}
