package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a `AWS::ElasticLoadBalancingV2::ListenerCertificate`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:12:43.389Z")
public interface CfnListenerCertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
     */
    java.lang.Object getCertificates();
    /**
     * `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
     */
    java.lang.String getListenerArn();

    /**
     * @return a {@link Builder} of {@link CfnListenerCertificateProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CfnListenerCertificateProps}
     */
    final class Builder {
        private java.lang.Object _certificates;
        private java.lang.String _listenerArn;

        /**
         * Sets the value of Certificates
         * @param value `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
         * @return {@code this}
         */
        public Builder withCertificates(final software.amazon.awscdk.Token value) {
            this._certificates = java.util.Objects.requireNonNull(value, "certificates is required");
            return this;
        }
        /**
         * Sets the value of Certificates
         * @param value `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
         * @return {@code this}
         */
        public Builder withCertificates(final java.util.List<java.lang.Object> value) {
            this._certificates = java.util.Objects.requireNonNull(value, "certificates is required");
            return this;
        }
        /**
         * Sets the value of ListenerArn
         * @param value `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
         * @return {@code this}
         */
        public Builder withListenerArn(final java.lang.String value) {
            this._listenerArn = java.util.Objects.requireNonNull(value, "listenerArn is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnListenerCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CfnListenerCertificateProps build() {
            return new CfnListenerCertificateProps() {
                private final java.lang.Object $certificates = java.util.Objects.requireNonNull(_certificates, "certificates is required");
                private final java.lang.String $listenerArn = java.util.Objects.requireNonNull(_listenerArn, "listenerArn is required");

                @Override
                public java.lang.Object getCertificates() {
                    return this.$certificates;
                }

                @Override
                public java.lang.String getListenerArn() {
                    return this.$listenerArn;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("certificates", om.valueToTree(this.getCertificates()));
                    obj.set("listenerArn", om.valueToTree(this.getListenerArn()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerCertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * `AWS::ElasticLoadBalancingV2::ListenerCertificate.Certificates`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-certificates
         */
        @Override
        public java.lang.Object getCertificates() {
            return this.jsiiGet("certificates", java.lang.Object.class);
        }

        /**
         * `AWS::ElasticLoadBalancingV2::ListenerCertificate.ListenerArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-elasticloadbalancingv2-listenercertificate.html#cfn-elasticloadbalancingv2-listenercertificate-listenerarn
         */
        @Override
        public java.lang.String getListenerArn() {
            return this.jsiiGet("listenerArn", java.lang.String.class);
        }
    }
}
