package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Result of attaching a target to load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:12:43.405Z")
public interface LoadBalancerTargetProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * What kind of target this is.
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType();
    /**
     * JSON representing the target's direct addition to the TargetGroup list.
     * 
     * May be omitted if the target is going to register itself later.
     */
    java.lang.Object getTargetJson();

    /**
     * @return a {@link Builder} of {@link LoadBalancerTargetProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link LoadBalancerTargetProps}
     */
    final class Builder {
        private software.amazon.awscdk.services.elasticloadbalancingv2.TargetType _targetType;
        @javax.annotation.Nullable
        private java.lang.Object _targetJson;

        /**
         * Sets the value of TargetType
         * @param value What kind of target this is.
         * @return {@code this}
         */
        public Builder withTargetType(final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType value) {
            this._targetType = java.util.Objects.requireNonNull(value, "targetType is required");
            return this;
        }
        /**
         * Sets the value of TargetJson
         * @param value JSON representing the target's direct addition to the TargetGroup list.
         * @return {@code this}
         */
        public Builder withTargetJson(@javax.annotation.Nullable final java.lang.Object value) {
            this._targetJson = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LoadBalancerTargetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public LoadBalancerTargetProps build() {
            return new LoadBalancerTargetProps() {
                private final software.amazon.awscdk.services.elasticloadbalancingv2.TargetType $targetType = java.util.Objects.requireNonNull(_targetType, "targetType is required");
                @javax.annotation.Nullable
                private final java.lang.Object $targetJson = _targetJson;

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
                    return this.$targetType;
                }

                @Override
                public java.lang.Object getTargetJson() {
                    return this.$targetJson;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("targetType", om.valueToTree(this.getTargetType()));
                    obj.set("targetJson", om.valueToTree(this.getTargetJson()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * What kind of target this is.
         */
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.TargetType getTargetType() {
            return this.jsiiGet("targetType", software.amazon.awscdk.services.elasticloadbalancingv2.TargetType.class);
        }

        /**
         * JSON representing the target's direct addition to the TargetGroup list.
         * 
         * May be omitted if the target is going to register itself later.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Object getTargetJson() {
            return this.jsiiGet("targetJson", java.lang.Object.class);
        }
    }
}
