package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for a network load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-05-02T10:12:43.409Z")
public interface NetworkLoadBalancerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {
    /**
     * Indicates whether cross-zone load balancing is enabled.
     * 
     * Default: false
     */
    java.lang.Boolean getCrossZoneEnabled();

    /**
     * @return a {@link Builder} of {@link NetworkLoadBalancerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NetworkLoadBalancerProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _crossZoneEnabled;
        private software.amazon.awscdk.services.ec2.IVpcNetwork _vpc;
        @javax.annotation.Nullable
        private java.lang.Boolean _deletionProtection;
        @javax.annotation.Nullable
        private java.lang.Boolean _internetFacing;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _vpcSubnets;

        /**
         * Sets the value of CrossZoneEnabled
         * @param value Indicates whether cross-zone load balancing is enabled.
         * @return {@code this}
         */
        public Builder withCrossZoneEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._crossZoneEnabled = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value The VPC network to place the load balancer in.
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeletionProtection
         * @param value Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        public Builder withDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deletionProtection = value;
            return this;
        }
        /**
         * Sets the value of InternetFacing
         * @param value Whether the load balancer has an internet-routable address.
         * @return {@code this}
         */
        public Builder withInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._internetFacing = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerName
         * @param value Name of the load balancer.
         * @return {@code this}
         */
        public Builder withLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerName = value;
            return this;
        }
        /**
         * Sets the value of VpcSubnets
         * @param value Where in the VPC to place the load balancer.
         * @return {@code this}
         */
        public Builder withVpcSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._vpcSubnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public NetworkLoadBalancerProps build() {
            return new NetworkLoadBalancerProps() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $crossZoneEnabled = _crossZoneEnabled;
                private final software.amazon.awscdk.services.ec2.IVpcNetwork $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $deletionProtection = _deletionProtection;
                @javax.annotation.Nullable
                private final java.lang.Boolean $internetFacing = _internetFacing;
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerName = _loadBalancerName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $vpcSubnets = _vpcSubnets;

                @Override
                public java.lang.Boolean getCrossZoneEnabled() {
                    return this.$crossZoneEnabled;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public java.lang.Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public java.lang.Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public java.lang.String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
                    return this.$vpcSubnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("crossZoneEnabled", om.valueToTree(this.getCrossZoneEnabled()));
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    obj.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
                    obj.set("internetFacing", om.valueToTree(this.getInternetFacing()));
                    obj.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
                    obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Indicates whether cross-zone load balancing is enabled.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getCrossZoneEnabled() {
            return this.jsiiGet("crossZoneEnabled", java.lang.Boolean.class);
        }

        /**
         * The VPC network to place the load balancer in.
         */
        @Override
        public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
        }

        /**
         * Indicates whether deletion protection is enabled.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDeletionProtection() {
            return this.jsiiGet("deletionProtection", java.lang.Boolean.class);
        }

        /**
         * Whether the load balancer has an internet-routable address.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getInternetFacing() {
            return this.jsiiGet("internetFacing", java.lang.Boolean.class);
        }

        /**
         * Name of the load balancer.
         * 
         * Default: Automatically generated name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerName() {
            return this.jsiiGet("loadBalancerName", java.lang.String.class);
        }

        /**
         * Where in the VPC to place the load balancer.
         * 
         * Default: Public subnets if internetFacing, otherwise private subnets
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }
    }
}
