package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:55:05.424Z")
public interface ApplicationListenerImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARN of the listener.
     */
    java.lang.String getListenerArn();
    /**
     * Security group ID of the load balancer this listener is associated with.
     */
    java.lang.String getSecurityGroupId();
    /**
     * The default port on which this listener is listening.
     */
    java.lang.String getDefaultPort();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerImportProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerImportProps}
     */
    final class Builder {
        private java.lang.String _listenerArn;
        private java.lang.String _securityGroupId;
        @javax.annotation.Nullable
        private java.lang.String _defaultPort;

        /**
         * Sets the value of ListenerArn
         * @param value ARN of the listener.
         * @return {@code this}
         */
        public Builder withListenerArn(final java.lang.String value) {
            this._listenerArn = java.util.Objects.requireNonNull(value, "listenerArn is required");
            return this;
        }
        /**
         * Sets the value of SecurityGroupId
         * @param value Security group ID of the load balancer this listener is associated with.
         * @return {@code this}
         */
        public Builder withSecurityGroupId(final java.lang.String value) {
            this._securityGroupId = java.util.Objects.requireNonNull(value, "securityGroupId is required");
            return this;
        }
        /**
         * Sets the value of DefaultPort
         * @param value The default port on which this listener is listening.
         * @return {@code this}
         */
        public Builder withDefaultPort(@javax.annotation.Nullable final java.lang.String value) {
            this._defaultPort = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApplicationListenerImportProps build() {
            return new ApplicationListenerImportProps() {
                private final java.lang.String $listenerArn = java.util.Objects.requireNonNull(_listenerArn, "listenerArn is required");
                private final java.lang.String $securityGroupId = java.util.Objects.requireNonNull(_securityGroupId, "securityGroupId is required");
                @javax.annotation.Nullable
                private final java.lang.String $defaultPort = _defaultPort;

                @Override
                public java.lang.String getListenerArn() {
                    return this.$listenerArn;
                }

                @Override
                public java.lang.String getSecurityGroupId() {
                    return this.$securityGroupId;
                }

                @Override
                public java.lang.String getDefaultPort() {
                    return this.$defaultPort;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("listenerArn", om.valueToTree(this.getListenerArn()));
                    obj.set("securityGroupId", om.valueToTree(this.getSecurityGroupId()));
                    obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARN of the listener.
         */
        @Override
        public java.lang.String getListenerArn() {
            return this.jsiiGet("listenerArn", java.lang.String.class);
        }

        /**
         * Security group ID of the load balancer this listener is associated with.
         */
        @Override
        public java.lang.String getSecurityGroupId() {
            return this.jsiiGet("securityGroupId", java.lang.String.class);
        }

        /**
         * The default port on which this listener is listening.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getDefaultPort() {
            return this.jsiiGet("defaultPort", java.lang.String.class);
        }
    }
}
