package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining an Application Load Balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.5 (build 46bc9b0)", date = "2019-05-06T20:55:05.428Z")
public interface ApplicationLoadBalancerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancerProps {
    /**
     * Indicates whether HTTP/2 is enabled.
     * 
     * Default: true
     */
    java.lang.Boolean getHttp2Enabled();
    /**
     * The load balancer idle timeout, in seconds.
     * 
     * Default: 60
     */
    java.lang.Number getIdleTimeoutSecs();
    /**
     * The type of IP addresses to use.
     * 
     * Only applies to application load balancers.
     * 
     * Default: IpAddressType.Ipv4
     */
    software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType();
    /**
     * Security group to associate with this load balancer.
     * 
     * Default: A security group is created
     */
    software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup();

    /**
     * @return a {@link Builder} of {@link ApplicationLoadBalancerProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationLoadBalancerProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.Boolean _http2Enabled;
        @javax.annotation.Nullable
        private java.lang.Number _idleTimeoutSecs;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType _ipAddressType;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.ISecurityGroup _securityGroup;
        private software.amazon.awscdk.services.ec2.IVpcNetwork _vpc;
        @javax.annotation.Nullable
        private java.lang.Boolean _deletionProtection;
        @javax.annotation.Nullable
        private java.lang.Boolean _internetFacing;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.ec2.SubnetSelection _vpcSubnets;

        /**
         * Sets the value of Http2Enabled
         * @param value Indicates whether HTTP/2 is enabled.
         * @return {@code this}
         */
        public Builder withHttp2Enabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._http2Enabled = value;
            return this;
        }
        /**
         * Sets the value of IdleTimeoutSecs
         * @param value The load balancer idle timeout, in seconds.
         * @return {@code this}
         */
        public Builder withIdleTimeoutSecs(@javax.annotation.Nullable final java.lang.Number value) {
            this._idleTimeoutSecs = value;
            return this;
        }
        /**
         * Sets the value of IpAddressType
         * @param value The type of IP addresses to use.
         * @return {@code this}
         */
        public Builder withIpAddressType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType value) {
            this._ipAddressType = value;
            return this;
        }
        /**
         * Sets the value of SecurityGroup
         * @param value Security group to associate with this load balancer.
         * @return {@code this}
         */
        public Builder withSecurityGroup(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.ISecurityGroup value) {
            this._securityGroup = value;
            return this;
        }
        /**
         * Sets the value of Vpc
         * @param value The VPC network to place the load balancer in.
         * @return {@code this}
         */
        public Builder withVpc(final software.amazon.awscdk.services.ec2.IVpcNetwork value) {
            this._vpc = java.util.Objects.requireNonNull(value, "vpc is required");
            return this;
        }
        /**
         * Sets the value of DeletionProtection
         * @param value Indicates whether deletion protection is enabled.
         * @return {@code this}
         */
        public Builder withDeletionProtection(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deletionProtection = value;
            return this;
        }
        /**
         * Sets the value of InternetFacing
         * @param value Whether the load balancer has an internet-routable address.
         * @return {@code this}
         */
        public Builder withInternetFacing(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._internetFacing = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerName
         * @param value Name of the load balancer.
         * @return {@code this}
         */
        public Builder withLoadBalancerName(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerName = value;
            return this;
        }
        /**
         * Sets the value of VpcSubnets
         * @param value Where in the VPC to place the load balancer.
         * @return {@code this}
         */
        public Builder withVpcSubnets(@javax.annotation.Nullable final software.amazon.awscdk.services.ec2.SubnetSelection value) {
            this._vpcSubnets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public ApplicationLoadBalancerProps build() {
            return new ApplicationLoadBalancerProps() {
                @javax.annotation.Nullable
                private final java.lang.Boolean $http2Enabled = _http2Enabled;
                @javax.annotation.Nullable
                private final java.lang.Number $idleTimeoutSecs = _idleTimeoutSecs;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType $ipAddressType = _ipAddressType;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.ISecurityGroup $securityGroup = _securityGroup;
                private final software.amazon.awscdk.services.ec2.IVpcNetwork $vpc = java.util.Objects.requireNonNull(_vpc, "vpc is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $deletionProtection = _deletionProtection;
                @javax.annotation.Nullable
                private final java.lang.Boolean $internetFacing = _internetFacing;
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerName = _loadBalancerName;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.ec2.SubnetSelection $vpcSubnets = _vpcSubnets;

                @Override
                public java.lang.Boolean getHttp2Enabled() {
                    return this.$http2Enabled;
                }

                @Override
                public java.lang.Number getIdleTimeoutSecs() {
                    return this.$idleTimeoutSecs;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
                    return this.$ipAddressType;
                }

                @Override
                public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
                    return this.$securityGroup;
                }

                @Override
                public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public java.lang.Boolean getDeletionProtection() {
                    return this.$deletionProtection;
                }

                @Override
                public java.lang.Boolean getInternetFacing() {
                    return this.$internetFacing;
                }

                @Override
                public java.lang.String getLoadBalancerName() {
                    return this.$loadBalancerName;
                }

                @Override
                public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
                    return this.$vpcSubnets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("http2Enabled", om.valueToTree(this.getHttp2Enabled()));
                    obj.set("idleTimeoutSecs", om.valueToTree(this.getIdleTimeoutSecs()));
                    obj.set("ipAddressType", om.valueToTree(this.getIpAddressType()));
                    obj.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
                    obj.set("vpc", om.valueToTree(this.getVpc()));
                    obj.set("deletionProtection", om.valueToTree(this.getDeletionProtection()));
                    obj.set("internetFacing", om.valueToTree(this.getInternetFacing()));
                    obj.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
                    obj.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationLoadBalancerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Indicates whether HTTP/2 is enabled.
         * 
         * Default: true
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getHttp2Enabled() {
            return this.jsiiGet("http2Enabled", java.lang.Boolean.class);
        }

        /**
         * The load balancer idle timeout, in seconds.
         * 
         * Default: 60
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Number getIdleTimeoutSecs() {
            return this.jsiiGet("idleTimeoutSecs", java.lang.Number.class);
        }

        /**
         * The type of IP addresses to use.
         * 
         * Only applies to application load balancers.
         * 
         * Default: IpAddressType.Ipv4
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType getIpAddressType() {
            return this.jsiiGet("ipAddressType", software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType.class);
        }

        /**
         * Security group to associate with this load balancer.
         * 
         * Default: A security group is created
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
        }

        /**
         * The VPC network to place the load balancer in.
         */
        @Override
        public software.amazon.awscdk.services.ec2.IVpcNetwork getVpc() {
            return this.jsiiGet("vpc", software.amazon.awscdk.services.ec2.IVpcNetwork.class);
        }

        /**
         * Indicates whether deletion protection is enabled.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getDeletionProtection() {
            return this.jsiiGet("deletionProtection", java.lang.Boolean.class);
        }

        /**
         * Whether the load balancer has an internet-routable address.
         * 
         * Default: false
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.Boolean getInternetFacing() {
            return this.jsiiGet("internetFacing", java.lang.Boolean.class);
        }

        /**
         * Name of the load balancer.
         * 
         * Default: Automatically generated name
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerName() {
            return this.jsiiGet("loadBalancerName", java.lang.String.class);
        }

        /**
         * Where in the VPC to place the load balancer.
         * 
         * Default: Public subnets if internetFacing, otherwise private subnets
         */
        @Override
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.jsiiGet("vpcSubnets", software.amazon.awscdk.services.ec2.SubnetSelection.class);
        }
    }
}
