/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpcNetwork;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ApplicationTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    public Number getPort();

    public ApplicationProtocol getProtocol();

    public Number getSlowStartSec();

    public Number getStickinessCookieDurationSec();

    public List<IApplicationLoadBalancerTarget> getTargets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Number _port;
        @Nullable
        private ApplicationProtocol _protocol;
        @Nullable
        private Number _slowStartSec;
        @Nullable
        private Number _stickinessCookieDurationSec;
        @Nullable
        private List<IApplicationLoadBalancerTarget> _targets;
        private IVpcNetwork _vpc;
        @Nullable
        private Number _deregistrationDelaySec;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private String _targetGroupName;
        @Nullable
        private TargetType _targetType;

        public Builder withPort(@Nullable Number value) {
            this._port = value;
            return this;
        }

        public Builder withProtocol(@Nullable ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }

        public Builder withSlowStartSec(@Nullable Number value) {
            this._slowStartSec = value;
            return this;
        }

        public Builder withStickinessCookieDurationSec(@Nullable Number value) {
            this._stickinessCookieDurationSec = value;
            return this;
        }

        public Builder withTargets(@Nullable List<IApplicationLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        public Builder withVpc(IVpcNetwork value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeregistrationDelaySec(@Nullable Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withTargetGroupName(@Nullable String value) {
            this._targetGroupName = value;
            return this;
        }

        public Builder withTargetType(@Nullable TargetType value) {
            this._targetType = value;
            return this;
        }

        public ApplicationTargetGroupProps build() {
            return new ApplicationTargetGroupProps(){
                @Nullable
                private final Number $port;
                @Nullable
                private final ApplicationProtocol $protocol;
                @Nullable
                private final Number $slowStartSec;
                @Nullable
                private final Number $stickinessCookieDurationSec;
                @Nullable
                private final List<IApplicationLoadBalancerTarget> $targets;
                private final IVpcNetwork $vpc;
                @Nullable
                private final Number $deregistrationDelaySec;
                @Nullable
                private final HealthCheck $healthCheck;
                @Nullable
                private final String $targetGroupName;
                @Nullable
                private final TargetType $targetType;
                {
                    this.$port = _port;
                    this.$protocol = _protocol;
                    this.$slowStartSec = _slowStartSec;
                    this.$stickinessCookieDurationSec = _stickinessCookieDurationSec;
                    this.$targets = _targets;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deregistrationDelaySec = _deregistrationDelaySec;
                    this.$healthCheck = _healthCheck;
                    this.$targetGroupName = _targetGroupName;
                    this.$targetType = _targetType;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public Number getSlowStartSec() {
                    return this.$slowStartSec;
                }

                @Override
                public Number getStickinessCookieDurationSec() {
                    return this.$stickinessCookieDurationSec;
                }

                @Override
                public List<IApplicationLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public IVpcNetwork getVpc() {
                    return this.$vpc;
                }

                @Override
                public Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public TargetType getTargetType() {
                    return this.$targetType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree((Object)this.getPort()));
                    obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    obj.set("slowStartSec", om.valueToTree((Object)this.getSlowStartSec()));
                    obj.set("stickinessCookieDurationSec", om.valueToTree((Object)this.getStickinessCookieDurationSec()));
                    obj.set("targets", om.valueToTree(this.getTargets()));
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    obj.set("deregistrationDelaySec", om.valueToTree((Object)this.getDeregistrationDelaySec()));
                    obj.set("healthCheck", om.valueToTree((Object)this.getHealthCheck()));
                    obj.set("targetGroupName", om.valueToTree((Object)this.getTargetGroupName()));
                    obj.set("targetType", om.valueToTree((Object)this.getTargetType()));
                    return obj;
                }
            };
        }
    }
}

