/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface NetworkTargetGroupProps
extends JsiiSerializable,
BaseTargetGroupProps {
    public Number getPort();

    public Boolean getProxyProtocolV2();

    public List<INetworkLoadBalancerTarget> getTargets();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _port;
        @Nullable
        private Boolean _proxyProtocolV2;
        @Nullable
        private List<INetworkLoadBalancerTarget> _targets;
        private IVpc _vpc;
        @Nullable
        private Number _deregistrationDelaySec;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private String _targetGroupName;
        @Nullable
        private TargetType _targetType;

        public Builder withPort(Number value) {
            this._port = Objects.requireNonNull(value, "port is required");
            return this;
        }

        public Builder withProxyProtocolV2(@Nullable Boolean value) {
            this._proxyProtocolV2 = value;
            return this;
        }

        public Builder withTargets(@Nullable List<INetworkLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeregistrationDelaySec(@Nullable Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withTargetGroupName(@Nullable String value) {
            this._targetGroupName = value;
            return this;
        }

        public Builder withTargetType(@Nullable TargetType value) {
            this._targetType = value;
            return this;
        }

        public NetworkTargetGroupProps build() {
            return new NetworkTargetGroupProps(){
                private final Number $port;
                @Nullable
                private final Boolean $proxyProtocolV2;
                @Nullable
                private final List<INetworkLoadBalancerTarget> $targets;
                private final IVpc $vpc;
                @Nullable
                private final Number $deregistrationDelaySec;
                @Nullable
                private final HealthCheck $healthCheck;
                @Nullable
                private final String $targetGroupName;
                @Nullable
                private final TargetType $targetType;
                {
                    this.$port = Objects.requireNonNull(_port, "port is required");
                    this.$proxyProtocolV2 = _proxyProtocolV2;
                    this.$targets = _targets;
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deregistrationDelaySec = _deregistrationDelaySec;
                    this.$healthCheck = _healthCheck;
                    this.$targetGroupName = _targetGroupName;
                    this.$targetType = _targetType;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public Boolean getProxyProtocolV2() {
                    return this.$proxyProtocolV2;
                }

                @Override
                public List<INetworkLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public TargetType getTargetType() {
                    return this.$targetType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree((Object)this.getPort()));
                    obj.set("proxyProtocolV2", om.valueToTree((Object)this.getProxyProtocolV2()));
                    obj.set("targets", om.valueToTree(this.getTargets()));
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    obj.set("deregistrationDelaySec", om.valueToTree((Object)this.getDeregistrationDelaySec()));
                    obj.set("healthCheck", om.valueToTree((Object)this.getHealthCheck()));
                    obj.set("targetGroupName", om.valueToTree((Object)this.getTargetGroupName()));
                    obj.set("targetType", om.valueToTree((Object)this.getTargetType()));
                    return obj;
                }
            };
        }
    }
}

