package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:05:49.192Z")
public interface NetworkLoadBalancerAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARN of the load balancer.
     */
    java.lang.String getLoadBalancerArn();
    /**
     * The canonical hosted zone ID of this load balancer.
     * 
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    java.lang.String getLoadBalancerCanonicalHostedZoneId();
    /**
     * The DNS name of this load balancer.
     * 
     * Default: - When not provided, LB cannot be used as Route53 Alias target.
     */
    java.lang.String getLoadBalancerDnsName();

    /**
     * @return a {@link Builder} of {@link NetworkLoadBalancerAttributes}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link NetworkLoadBalancerAttributes}
     */
    final class Builder {
        private java.lang.String _loadBalancerArn;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerCanonicalHostedZoneId;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerDnsName;

        /**
         * Sets the value of LoadBalancerArn
         * @param value ARN of the load balancer.
         * @return {@code this}
         */
        public Builder withLoadBalancerArn(final java.lang.String value) {
            this._loadBalancerArn = java.util.Objects.requireNonNull(value, "loadBalancerArn is required");
            return this;
        }
        /**
         * Sets the value of LoadBalancerCanonicalHostedZoneId
         * @param value The canonical hosted zone ID of this load balancer.
         * @return {@code this}
         */
        public Builder withLoadBalancerCanonicalHostedZoneId(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerCanonicalHostedZoneId = value;
            return this;
        }
        /**
         * Sets the value of LoadBalancerDnsName
         * @param value The DNS name of this load balancer.
         * @return {@code this}
         */
        public Builder withLoadBalancerDnsName(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerDnsName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NetworkLoadBalancerAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        public NetworkLoadBalancerAttributes build() {
            return new NetworkLoadBalancerAttributes() {
                private final java.lang.String $loadBalancerArn = java.util.Objects.requireNonNull(_loadBalancerArn, "loadBalancerArn is required");
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerCanonicalHostedZoneId = _loadBalancerCanonicalHostedZoneId;
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerDnsName = _loadBalancerDnsName;

                @Override
                public java.lang.String getLoadBalancerArn() {
                    return this.$loadBalancerArn;
                }

                @Override
                public java.lang.String getLoadBalancerCanonicalHostedZoneId() {
                    return this.$loadBalancerCanonicalHostedZoneId;
                }

                @Override
                public java.lang.String getLoadBalancerDnsName() {
                    return this.$loadBalancerDnsName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("loadBalancerArn", om.valueToTree(this.getLoadBalancerArn()));
                    obj.set("loadBalancerCanonicalHostedZoneId", om.valueToTree(this.getLoadBalancerCanonicalHostedZoneId()));
                    obj.set("loadBalancerDnsName", om.valueToTree(this.getLoadBalancerDnsName()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARN of the load balancer.
         */
        @Override
        public java.lang.String getLoadBalancerArn() {
            return this.jsiiGet("loadBalancerArn", java.lang.String.class);
        }

        /**
         * The canonical hosted zone ID of this load balancer.
         * 
         * Default: - When not provided, LB cannot be used as Route53 Alias target.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerCanonicalHostedZoneId() {
            return this.jsiiGet("loadBalancerCanonicalHostedZoneId", java.lang.String.class);
        }

        /**
         * The DNS name of this load balancer.
         * 
         * Default: - When not provided, LB cannot be used as Route53 Alias target.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerDnsName() {
            return this.jsiiGet("loadBalancerDnsName", java.lang.String.class);
        }
    }
}
