package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define the target of a load balancer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.0 (build 3d6415e)", date = "2019-05-30T15:05:49.206Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.TargetGroupBase")
public abstract class TargetGroupBase extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.elasticloadbalancingv2.ITargetGroup {
    protected TargetGroupBase(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public TargetGroupBase(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.elasticloadbalancingv2.BaseTargetGroupProps baseProps, @javax.annotation.Nullable final java.lang.Object additionalProps) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(baseProps, "baseProps is required"), additionalProps });
    }

    /**
     * Register the given load balancing target as part of this group.
     */
    protected void addLoadBalancerTarget(final software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps props) {
        this.jsiiCall("addLoadBalancerTarget", Void.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Set/replace the target group's health check.
     */
    public void configureHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck healthCheck) {
        this.jsiiCall("configureHealthCheck", Void.class, new Object[] { java.util.Objects.requireNonNull(healthCheck, "healthCheck is required") });
    }

    /**
     * Set a non-standard attribute on the target group.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     */
    public void setAttribute(final java.lang.String key, @javax.annotation.Nullable final java.lang.String value) {
        this.jsiiCall("setAttribute", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * Set a non-standard attribute on the target group.
     * 
     * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes
     */
    public void setAttribute(final java.lang.String key) {
        this.jsiiCall("setAttribute", Void.class, new Object[] { java.util.Objects.requireNonNull(key, "key is required") });
    }

    /**
     * Default port configured for members of this target group.
     */
    protected java.lang.Number getDefaultPort() {
        return this.jsiiGet("defaultPort", java.lang.Number.class);
    }

    /**
     * Full name of first load balancer.
     * 
     * This identifier is emitted as a dimensions of the metrics of this target
     * group.
     * 
     * Example:
     * 
     * app/my-load-balancer/123456789
     */
    public java.lang.String getFirstLoadBalancerFullName() {
        return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
    }

    /**
     * Health check for the members of this target group A token representing a list of ARNs of the load balancers that route traffic to this target group.
     */
    @Override
    public java.lang.String getLoadBalancerArns() {
        return this.jsiiGet("loadBalancerArns", java.lang.String.class);
    }

    /**
     * List of constructs that need to be depended on to ensure the TargetGroup is associated to a load balancer.
     */
    @Override
    public software.amazon.awscdk.IDependable getLoadBalancerAttached() {
        return this.jsiiGet("loadBalancerAttached", software.amazon.awscdk.IDependable.class);
    }

    /**
     * Configurable dependable with all resources that lead to load balancer attachment.
     */
    protected software.amazon.awscdk.ConcreteDependable getLoadBalancerAttachedDependencies() {
        return this.jsiiGet("loadBalancerAttachedDependencies", software.amazon.awscdk.ConcreteDependable.class);
    }

    /**
     * The ARN of the target group.
     */
    @Override
    public java.lang.String getTargetGroupArn() {
        return this.jsiiGet("targetGroupArn", java.lang.String.class);
    }

    /**
     * The full name of the target group.
     */
    public java.lang.String getTargetGroupFullName() {
        return this.jsiiGet("targetGroupFullName", java.lang.String.class);
    }

    /**
     * ARNs of load balancers load balancing to this TargetGroup.
     */
    public java.util.List<java.lang.String> getTargetGroupLoadBalancerArns() {
        return this.jsiiGet("targetGroupLoadBalancerArns", java.util.List.class);
    }

    /**
     * The name of the target group.
     */
    public java.lang.String getTargetGroupName() {
        return this.jsiiGet("targetGroupName", java.lang.String.class);
    }

    public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
        return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
    }

    public void setHealthCheck(final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
        this.jsiiSet("healthCheck", java.util.Objects.requireNonNull(value, "healthCheck is required"));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Full name of first load balancer.
         * 
         * This identifier is emitted as a dimensions of the metrics of this target
         * group.
         * 
         * Example:
         * 
         * app/my-load-balancer/123456789
         */
        @Override
        public java.lang.String getFirstLoadBalancerFullName() {
            return this.jsiiGet("firstLoadBalancerFullName", java.lang.String.class);
        }

        /**
         * A token representing a list of ARNs of the load balancers that route traffic to this target group.
         */
        @Override
        public java.lang.String getLoadBalancerArns() {
            return this.jsiiGet("loadBalancerArns", java.lang.String.class);
        }

        /**
         * Return an object to depend on the listeners added to this target group.
         */
        @Override
        public software.amazon.awscdk.IDependable getLoadBalancerAttached() {
            return this.jsiiGet("loadBalancerAttached", software.amazon.awscdk.IDependable.class);
        }

        /**
         * ARN of the target group.
         */
        @Override
        public java.lang.String getTargetGroupArn() {
            return this.jsiiGet("targetGroupArn", java.lang.String.class);
        }

        /**
         * The construct node in the scope tree.
         */
        @Override
        public software.amazon.awscdk.ConstructNode getNode() {
            return this.jsiiGet("node", software.amazon.awscdk.ConstructNode.class);
        }
    }
}
