package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a fixed response to a listener.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.2 (build 27d16c2)", date = "2019-06-10T11:12:23.775Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AddFixedResponseProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps, software.amazon.awscdk.services.elasticloadbalancingv2.FixedResponse {

    /**
     * @return a {@link Builder} of {@link AddFixedResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddFixedResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.lang.Number _priority;
        private java.lang.String _statusCode;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.ContentType _contentType;
        @javax.annotation.Nullable
        private java.lang.String _messageBody;

        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this._priority = value;
            return this;
        }
        /**
         * Sets the value of StatusCode
         * @param value The HTTP response code (2XX, 4XX or 5XX).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withStatusCode(final java.lang.String value) {
            this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
            return this;
        }
        /**
         * Sets the value of ContentType
         * @param value The content type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withContentType(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ContentType value) {
            this._contentType = value;
            return this;
        }
        /**
         * Sets the value of MessageBody
         * @param value The message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMessageBody(@javax.annotation.Nullable final java.lang.String value) {
            this._messageBody = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddFixedResponseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public AddFixedResponseProps build() {
            return new AddFixedResponseProps() {
                @javax.annotation.Nullable
                private final java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private final java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private final java.lang.Number $priority = _priority;
                private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.ContentType $contentType = _contentType;
                @javax.annotation.Nullable
                private final java.lang.String $messageBody = _messageBody;

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                @Override
                public java.lang.String getStatusCode() {
                    return this.$statusCode;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.ContentType getContentType() {
                    return this.$contentType;
                }

                @Override
                public java.lang.String getMessageBody() {
                    return this.$messageBody;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getHostHeader() != null) {
                        obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
                    }
                    if (this.getPathPattern() != null) {
                        obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
                    }
                    if (this.getPriority() != null) {
                        obj.set("priority", om.valueToTree(this.getPriority()));
                    }
                    obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                    if (this.getContentType() != null) {
                        obj.set("contentType", om.valueToTree(this.getContentType()));
                    }
                    if (this.getMessageBody() != null) {
                        obj.set("messageBody", om.valueToTree(this.getMessageBody()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.AddFixedResponseProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Rule applies if the requested host matches the indicated host.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * 
         * Default: No host condition
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * 
         * Default: No path condition
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Priority of this target group.
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * 
         * Default: Target groups are used as defaults
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }

        /**
         * The HTTP response code (2XX, 4XX or 5XX).
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getStatusCode() {
            return this.jsiiGet("statusCode", java.lang.String.class);
        }

        /**
         * The content type.
         * 
         * Default: text/plain
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.ContentType getContentType() {
            return this.jsiiGet("contentType", software.amazon.awscdk.services.elasticloadbalancingv2.ContentType.class);
        }

        /**
         * The message.
         * 
         * Default: no message
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getMessageBody() {
            return this.jsiiGet("messageBody", java.lang.String.class);
        }
    }
}
