/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface BaseTargetGroupProps
extends JsiiSerializable {
    public IVpc getVpc();

    public Number getDeregistrationDelaySec();

    public HealthCheck getHealthCheck();

    public String getTargetGroupName();

    public TargetType getTargetType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IVpc _vpc;
        @Nullable
        private Number _deregistrationDelaySec;
        @Nullable
        private HealthCheck _healthCheck;
        @Nullable
        private String _targetGroupName;
        @Nullable
        private TargetType _targetType;

        public Builder withVpc(IVpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public Builder withDeregistrationDelaySec(@Nullable Number value) {
            this._deregistrationDelaySec = value;
            return this;
        }

        public Builder withHealthCheck(@Nullable HealthCheck value) {
            this._healthCheck = value;
            return this;
        }

        public Builder withTargetGroupName(@Nullable String value) {
            this._targetGroupName = value;
            return this;
        }

        public Builder withTargetType(@Nullable TargetType value) {
            this._targetType = value;
            return this;
        }

        public BaseTargetGroupProps build() {
            return new BaseTargetGroupProps(){
                private final IVpc $vpc;
                @Nullable
                private final Number $deregistrationDelaySec;
                @Nullable
                private final HealthCheck $healthCheck;
                @Nullable
                private final String $targetGroupName;
                @Nullable
                private final TargetType $targetType;
                {
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                    this.$deregistrationDelaySec = _deregistrationDelaySec;
                    this.$healthCheck = _healthCheck;
                    this.$targetGroupName = _targetGroupName;
                    this.$targetType = _targetType;
                }

                @Override
                public IVpc getVpc() {
                    return this.$vpc;
                }

                @Override
                public Number getDeregistrationDelaySec() {
                    return this.$deregistrationDelaySec;
                }

                @Override
                public HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public TargetType getTargetType() {
                    return this.$targetType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    if (this.getDeregistrationDelaySec() != null) {
                        obj.set("deregistrationDelaySec", om.valueToTree((Object)this.getDeregistrationDelaySec()));
                    }
                    if (this.getHealthCheck() != null) {
                        obj.set("healthCheck", om.valueToTree((Object)this.getHealthCheck()));
                    }
                    if (this.getTargetGroupName() != null) {
                        obj.set("targetGroupName", om.valueToTree((Object)this.getTargetGroupName()));
                    }
                    if (this.getTargetType() != null) {
                        obj.set("targetType", om.valueToTree((Object)this.getTargetType()));
                    }
                    return obj;
                }
            };
        }
    }
}

