/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.Protocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface NetworkListenerProps
extends JsiiSerializable,
BaseNetworkListenerProps {
    public INetworkLoadBalancer getLoadBalancer();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private INetworkLoadBalancer _loadBalancer;
        private Number _port;
        @Nullable
        private List<INetworkListenerCertificateProps> _certificates;
        @Nullable
        private List<INetworkTargetGroup> _defaultTargetGroups;
        @Nullable
        private Protocol _protocol;
        @Nullable
        private SslPolicy _sslPolicy;

        public Builder withLoadBalancer(INetworkLoadBalancer value) {
            this._loadBalancer = Objects.requireNonNull(value, "loadBalancer is required");
            return this;
        }

        public Builder withPort(Number value) {
            this._port = Objects.requireNonNull(value, "port is required");
            return this;
        }

        public Builder withCertificates(@Nullable List<INetworkListenerCertificateProps> value) {
            this._certificates = value;
            return this;
        }

        public Builder withDefaultTargetGroups(@Nullable List<INetworkTargetGroup> value) {
            this._defaultTargetGroups = value;
            return this;
        }

        public Builder withProtocol(@Nullable Protocol value) {
            this._protocol = value;
            return this;
        }

        public Builder withSslPolicy(@Nullable SslPolicy value) {
            this._sslPolicy = value;
            return this;
        }

        public NetworkListenerProps build() {
            return new NetworkListenerProps(){
                private final INetworkLoadBalancer $loadBalancer;
                private final Number $port;
                @Nullable
                private final List<INetworkListenerCertificateProps> $certificates;
                @Nullable
                private final List<INetworkTargetGroup> $defaultTargetGroups;
                @Nullable
                private final Protocol $protocol;
                @Nullable
                private final SslPolicy $sslPolicy;
                {
                    this.$loadBalancer = Objects.requireNonNull(_loadBalancer, "loadBalancer is required");
                    this.$port = Objects.requireNonNull(_port, "port is required");
                    this.$certificates = _certificates;
                    this.$defaultTargetGroups = _defaultTargetGroups;
                    this.$protocol = _protocol;
                    this.$sslPolicy = _sslPolicy;
                }

                @Override
                public INetworkLoadBalancer getLoadBalancer() {
                    return this.$loadBalancer;
                }

                @Override
                public Number getPort() {
                    return this.$port;
                }

                @Override
                public List<INetworkListenerCertificateProps> getCertificates() {
                    return this.$certificates;
                }

                @Override
                public List<INetworkTargetGroup> getDefaultTargetGroups() {
                    return this.$defaultTargetGroups;
                }

                @Override
                public Protocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public SslPolicy getSslPolicy() {
                    return this.$sslPolicy;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("loadBalancer", om.valueToTree((Object)this.getLoadBalancer()));
                    obj.set("port", om.valueToTree((Object)this.getPort()));
                    if (this.getCertificates() != null) {
                        obj.set("certificates", om.valueToTree(this.getCertificates()));
                    }
                    if (this.getDefaultTargetGroups() != null) {
                        obj.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
                    }
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree((Object)this.getProtocol()));
                    }
                    if (this.getSslPolicy() != null) {
                        obj.set("sslPolicy", om.valueToTree((Object)this.getSslPolicy()));
                    }
                    return obj;
                }
            };
        }
    }
}

