package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding new targets to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:19:23.852Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddApplicationTargetsProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {
    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0-3600 seconds.
     * 
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getDeregistrationDelay();
    /**
     * Health check configuration.
     * 
     * Default: No health check
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck();
    /**
     * The port on which the listener listens for requests.
     * 
     * Default: Determined from protocol if known
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();
    /**
     * The protocol to use.
     * 
     * Default: Determined from port if known
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol();
    /**
     * The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
     * 
     * The range is 30-900 seconds (15 minutes).
     * 
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getSlowStart();
    /**
     * The stickiness cookie expiration period.
     * 
     * Setting this value enables load balancer stickiness.
     * 
     * After this period, the cookie is considered stale. The minimum value is
     * 1 second and the maximum value is 7 days (604800 seconds).
     * 
     * Default: Duration.days(1)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getStickinessCookieDuration();
    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * 
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTargetGroupName();
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets();

    /**
     * @return a {@link Builder} of {@link AddApplicationTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddApplicationTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _deregistrationDelay;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol _protocol;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _slowStart;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _stickinessCookieDuration;
        @javax.annotation.Nullable
        private java.lang.String _targetGroupName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> _targets;
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.lang.Number _priority;

        /**
         * Sets the value of DeregistrationDelay
         * @param value The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeregistrationDelay(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._deregistrationDelay = value;
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPort(@javax.annotation.Nullable final java.lang.Number value) {
            this._port = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value The protocol to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of SlowStart
         * @param value The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSlowStart(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._slowStart = value;
            return this;
        }
        /**
         * Sets the value of StickinessCookieDuration
         * @param value The stickiness cookie expiration period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStickinessCookieDuration(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._stickinessCookieDuration = value;
            return this;
        }
        /**
         * Sets the value of TargetGroupName
         * @param value The name of the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._targetGroupName = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value The targets to add to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }
        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this._priority = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddApplicationTargetsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddApplicationTargetsProps build() {
            return new AddApplicationTargetsProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $deregistrationDelay = _deregistrationDelay;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private final java.lang.Number $port = _port;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol $protocol = _protocol;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $slowStart = _slowStart;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $stickinessCookieDuration = _stickinessCookieDuration;
                @javax.annotation.Nullable
                private final java.lang.String $targetGroupName = _targetGroupName;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> $targets = _targets;
                @javax.annotation.Nullable
                private final java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private final java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private final java.lang.Number $priority = _priority;

                @Override
                public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
                    return this.$deregistrationDelay;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public software.amazon.awscdk.core.Duration getSlowStart() {
                    return this.$slowStart;
                }

                @Override
                public software.amazon.awscdk.core.Duration getStickinessCookieDuration() {
                    return this.$stickinessCookieDuration;
                }

                @Override
                public java.lang.String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getDeregistrationDelay() != null) {
                        obj.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
                    }
                    if (this.getHealthCheck() != null) {
                        obj.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                    }
                    if (this.getPort() != null) {
                        obj.set("port", om.valueToTree(this.getPort()));
                    }
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                    }
                    if (this.getSlowStart() != null) {
                        obj.set("slowStart", om.valueToTree(this.getSlowStart()));
                    }
                    if (this.getStickinessCookieDuration() != null) {
                        obj.set("stickinessCookieDuration", om.valueToTree(this.getStickinessCookieDuration()));
                    }
                    if (this.getTargetGroupName() != null) {
                        obj.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
                    }
                    if (this.getTargets() != null) {
                        obj.set("targets", om.valueToTree(this.getTargets()));
                    }
                    if (this.getHostHeader() != null) {
                        obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
                    }
                    if (this.getPathPattern() != null) {
                        obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
                    }
                    if (this.getPriority() != null) {
                        obj.set("priority", om.valueToTree(this.getPriority()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0-3600 seconds.
         * 
         * Default: Duration.minutes(5)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.jsiiGet("deregistrationDelay", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Health check configuration.
         * 
         * Default: No health check
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
        }

        /**
         * The port on which the listener listens for requests.
         * 
         * Default: Determined from protocol if known
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The protocol to use.
         * 
         * Default: Determined from port if known
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol.class);
        }

        /**
         * The time period during which the load balancer sends a newly registered target a linearly increasing share of the traffic to the target group.
         * 
         * The range is 30-900 seconds (15 minutes).
         * 
         * Default: 0
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getSlowStart() {
            return this.jsiiGet("slowStart", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * The stickiness cookie expiration period.
         * 
         * Setting this value enables load balancer stickiness.
         * 
         * After this period, the cookie is considered stale. The minimum value is
         * 1 second and the maximum value is 7 days (604800 seconds).
         * 
         * Default: Duration.days(1)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getStickinessCookieDuration() {
            return this.jsiiGet("stickinessCookieDuration", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * 
         * Default: Automatically generated
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getTargetGroupName() {
            return this.jsiiGet("targetGroupName", java.lang.String.class);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * 
         * Default: No host condition
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * 
         * Default: No path condition
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Priority of this target group.
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * 
         * Default: Target groups are used as defaults
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }
    }
}
