package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding new network targets to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:19:23.854Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddNetworkTargetsProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The port on which the listener listens for requests.
     * 
     * Default: Determined from protocol if known
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();
    /**
     * The amount of time for Elastic Load Balancing to wait before deregistering a target.
     * 
     * The range is 0-3600 seconds.
     * 
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.core.Duration getDeregistrationDelay();
    /**
     * Health check configuration.
     * 
     * Default: No health check
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck();
    /**
     * Indicates whether Proxy Protocol version 2 is enabled.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getProxyProtocolV2();
    /**
     * The name of the target group.
     * 
     * This name must be unique per region per account, can have a maximum of
     * 32 characters, must contain only alphanumeric characters or hyphens, and
     * must not begin or end with a hyphen.
     * 
     * Default: Automatically generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTargetGroupName();
    /**
     * The targets to add to this target group.
     * 
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets();

    /**
     * @return a {@link Builder} of {@link AddNetworkTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddNetworkTargetsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _deregistrationDelay;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck _healthCheck;
        @javax.annotation.Nullable
        private java.lang.Boolean _proxyProtocolV2;
        @javax.annotation.Nullable
        private java.lang.String _targetGroupName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> _targets;

        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of DeregistrationDelay
         * @param value The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeregistrationDelay(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._deregistrationDelay = value;
            return this;
        }
        /**
         * Sets the value of HealthCheck
         * @param value Health check configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHealthCheck(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck value) {
            this._healthCheck = value;
            return this;
        }
        /**
         * Sets the value of ProxyProtocolV2
         * @param value Indicates whether Proxy Protocol version 2 is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProxyProtocolV2(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._proxyProtocolV2 = value;
            return this;
        }
        /**
         * Sets the value of TargetGroupName
         * @param value The name of the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetGroupName(@javax.annotation.Nullable final java.lang.String value) {
            this._targetGroupName = value;
            return this;
        }
        /**
         * Sets the value of Targets
         * @param value The targets to add to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargets(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> value) {
            this._targets = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddNetworkTargetsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddNetworkTargetsProps build() {
            return new AddNetworkTargetsProps() {
                private final java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $deregistrationDelay = _deregistrationDelay;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck $healthCheck = _healthCheck;
                @javax.annotation.Nullable
                private final java.lang.Boolean $proxyProtocolV2 = _proxyProtocolV2;
                @javax.annotation.Nullable
                private final java.lang.String $targetGroupName = _targetGroupName;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> $targets = _targets;

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
                    return this.$deregistrationDelay;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
                    return this.$healthCheck;
                }

                @Override
                public java.lang.Boolean getProxyProtocolV2() {
                    return this.$proxyProtocolV2;
                }

                @Override
                public java.lang.String getTargetGroupName() {
                    return this.$targetGroupName;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
                    return this.$targets;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree(this.getPort()));
                    if (this.getDeregistrationDelay() != null) {
                        obj.set("deregistrationDelay", om.valueToTree(this.getDeregistrationDelay()));
                    }
                    if (this.getHealthCheck() != null) {
                        obj.set("healthCheck", om.valueToTree(this.getHealthCheck()));
                    }
                    if (this.getProxyProtocolV2() != null) {
                        obj.set("proxyProtocolV2", om.valueToTree(this.getProxyProtocolV2()));
                    }
                    if (this.getTargetGroupName() != null) {
                        obj.set("targetGroupName", om.valueToTree(this.getTargetGroupName()));
                    }
                    if (this.getTargets() != null) {
                        obj.set("targets", om.valueToTree(this.getTargets()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.AddNetworkTargetsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The port on which the listener listens for requests.
         * 
         * Default: Determined from protocol if known
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * The amount of time for Elastic Load Balancing to wait before deregistering a target.
         * 
         * The range is 0-3600 seconds.
         * 
         * Default: Duration.minutes(5)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getDeregistrationDelay() {
            return this.jsiiGet("deregistrationDelay", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Health check configuration.
         * 
         * Default: No health check
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck getHealthCheck() {
            return this.jsiiGet("healthCheck", software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck.class);
        }

        /**
         * Indicates whether Proxy Protocol version 2 is enabled.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getProxyProtocolV2() {
            return this.jsiiGet("proxyProtocolV2", java.lang.Boolean.class);
        }

        /**
         * The name of the target group.
         * 
         * This name must be unique per region per account, can have a maximum of
         * 32 characters, must contain only alphanumeric characters or hyphens, and
         * must not begin or end with a hyphen.
         * 
         * Default: Automatically generated
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getTargetGroupName() {
            return this.jsiiGet("targetGroupName", java.lang.String.class);
        }

        /**
         * The targets to add to this target group.
         * 
         * Can be `Instance`, `IPAddress`, or any self-registering load balancing
         * target. If you use either `Instance` or `IPAddress` as targets, all
         * target must be of the same type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget> getTargets() {
            return this.jsiiGet("targets", java.util.List.class);
        }
    }
}
