package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * An EC2 instance that is the target for load balancing.
 * 
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can connect to the instance.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:19:23.903Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.InstanceTarget")
public class InstanceTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget,software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget {
    protected InstanceTarget(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * Create a new Instance target.
     * 
     * @param instanceId Instance ID of the instance to register to.
     * @param port Override the default port for the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceTarget(final java.lang.String instanceId, @javax.annotation.Nullable final java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceId, "instanceId is required"), port });
    }
    /**
     * Create a new Instance target.
     * 
     * @param instanceId Instance ID of the instance to register to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public InstanceTarget(final java.lang.String instanceId) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(instanceId, "instanceId is required") });
    }

    /**
     * Register this instance target with a load balancer.
     * 
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup targetGroup) {
        return this.jsiiCall("attachToApplicationTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Register this instance target with a load balancer.
     * 
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup targetGroup) {
        return this.jsiiCall("attachToNetworkTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }
}
