package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * An IP address that is a target for load balancing.
 * 
 * Specify IP addresses from the subnets of the virtual private cloud (VPC) for
 * the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
 * 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify
 * publicly routable IP addresses.
 * 
 * If you register a target of this type, you are responsible for making
 * sure the load balancer's security group can send packets to the IP address.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:19:23.903Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.elasticloadbalancingv2.$Module.class, fqn = "@aws-cdk/aws-elasticloadbalancingv2.IpTarget")
public class IpTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget,software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget {
    protected IpTarget(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    /**
     * Create a new IPAddress target.
     * 
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * 
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * 
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * 
     * Default is automatic.
     * 
     * @param ipAddress The IP Address to load balance to.
     * @param port Override the group's default port.
     * @param availabilityZone Availability zone to send traffic from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IpTarget(final java.lang.String ipAddress, @javax.annotation.Nullable final java.lang.Number port, @javax.annotation.Nullable final java.lang.String availabilityZone) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(ipAddress, "ipAddress is required"), port, availabilityZone });
    }
    /**
     * Create a new IPAddress target.
     * 
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * 
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * 
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * 
     * Default is automatic.
     * 
     * @param ipAddress The IP Address to load balance to.
     * @param port Override the group's default port.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IpTarget(final java.lang.String ipAddress, @javax.annotation.Nullable final java.lang.Number port) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(ipAddress, "ipAddress is required"), port });
    }
    /**
     * Create a new IPAddress target.
     * 
     * The availabilityZone parameter determines whether the target receives
     * traffic from the load balancer nodes in the specified Availability Zone
     * or from all enabled Availability Zones for the load balancer.
     * 
     * This parameter is not supported if the target type of the target group
     * is instance. If the IP address is in a subnet of the VPC for the target
     * group, the Availability Zone is automatically detected and this
     * parameter is optional. If the IP address is outside the VPC, this
     * parameter is required.
     * 
     * With an Application Load Balancer, if the IP address is outside the VPC
     * for the target group, the only supported value is all.
     * 
     * Default is automatic.
     * 
     * @param ipAddress The IP Address to load balance to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IpTarget(final java.lang.String ipAddress) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(ipAddress, "ipAddress is required") });
    }

    /**
     * Register this instance target with a load balancer.
     * 
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup targetGroup) {
        return this.jsiiCall("attachToApplicationTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * Register this instance target with a load balancer.
     * 
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroup targetGroup) {
        return this.jsiiCall("attachToNetworkTargetGroup", software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class, new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }
}
