package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties to reference an existing target group.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-03T12:19:23.915Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TargetGroupImportProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Port target group is listening on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDefaultPort();
    /**
     * ARN of the target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getTargetGroupArn();
    /**
     * A Token representing the list of ARNs for the load balancer routing to this target group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getLoadBalancerArns();

    /**
     * @return a {@link Builder} of {@link TargetGroupImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link TargetGroupImportProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.String _defaultPort;
        private java.lang.String _targetGroupArn;
        @javax.annotation.Nullable
        private java.lang.String _loadBalancerArns;

        /**
         * Sets the value of DefaultPort
         * @param value Port target group is listening on.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDefaultPort(final java.lang.String value) {
            this._defaultPort = java.util.Objects.requireNonNull(value, "defaultPort is required");
            return this;
        }
        /**
         * Sets the value of TargetGroupArn
         * @param value ARN of the target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetGroupArn(final java.lang.String value) {
            this._targetGroupArn = java.util.Objects.requireNonNull(value, "targetGroupArn is required");
            return this;
        }
        /**
         * Sets the value of LoadBalancerArns
         * @param value A Token representing the list of ARNs for the load balancer routing to this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLoadBalancerArns(@javax.annotation.Nullable final java.lang.String value) {
            this._loadBalancerArns = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TargetGroupImportProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public TargetGroupImportProps build() {
            return new TargetGroupImportProps() {
                private final java.lang.String $defaultPort = java.util.Objects.requireNonNull(_defaultPort, "defaultPort is required");
                private final java.lang.String $targetGroupArn = java.util.Objects.requireNonNull(_targetGroupArn, "targetGroupArn is required");
                @javax.annotation.Nullable
                private final java.lang.String $loadBalancerArns = _loadBalancerArns;

                @Override
                public java.lang.String getDefaultPort() {
                    return this.$defaultPort;
                }

                @Override
                public java.lang.String getTargetGroupArn() {
                    return this.$targetGroupArn;
                }

                @Override
                public java.lang.String getLoadBalancerArns() {
                    return this.$loadBalancerArns;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("defaultPort", om.valueToTree(this.getDefaultPort()));
                    obj.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                    if (this.getLoadBalancerArns() != null) {
                        obj.set("loadBalancerArns", om.valueToTree(this.getLoadBalancerArns()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupImportProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Port target group is listening on.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDefaultPort() {
            return this.jsiiGet("defaultPort", java.lang.String.class);
        }

        /**
         * ARN of the target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getTargetGroupArn() {
            return this.jsiiGet("targetGroupArn", java.lang.String.class);
        }

        /**
         * A Token representing the list of ARNs for the load balancer routing to this target group.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getLoadBalancerArns() {
            return this.jsiiGet("loadBalancerArns", java.lang.String.class);
        }
    }
}
