package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a new target group to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:37:05.130Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddApplicationTargetGroupsProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps {
    /**
     * Target groups to forward requests to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups();

    /**
     * @return a {@link Builder} of {@link AddApplicationTargetGroupsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link AddApplicationTargetGroupsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> _targetGroups;
        @javax.annotation.Nullable
        private java.lang.String _hostHeader;
        @javax.annotation.Nullable
        private java.lang.String _pathPattern;
        @javax.annotation.Nullable
        private java.lang.Number _priority;

        /**
         * Sets the value of TargetGroups
         * @param value Target groups to forward requests to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTargetGroups(final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> value) {
            this._targetGroups = java.util.Objects.requireNonNull(value, "targetGroups is required");
            return this;
        }
        /**
         * Sets the value of HostHeader
         * @param value Rule applies if the requested host matches the indicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withHostHeader(@javax.annotation.Nullable final java.lang.String value) {
            this._hostHeader = value;
            return this;
        }
        /**
         * Sets the value of PathPattern
         * @param value Rule applies if the requested path matches the given path pattern.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPathPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._pathPattern = value;
            return this;
        }
        /**
         * Sets the value of Priority
         * @param value Priority of this target group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPriority(@javax.annotation.Nullable final java.lang.Number value) {
            this._priority = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddApplicationTargetGroupsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AddApplicationTargetGroupsProps build() {
            return new AddApplicationTargetGroupsProps() {
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> $targetGroups = java.util.Objects.requireNonNull(_targetGroups, "targetGroups is required");
                @javax.annotation.Nullable
                private final java.lang.String $hostHeader = _hostHeader;
                @javax.annotation.Nullable
                private final java.lang.String $pathPattern = _pathPattern;
                @javax.annotation.Nullable
                private final java.lang.Number $priority = _priority;

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
                    return this.$targetGroups;
                }

                @Override
                public java.lang.String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public java.lang.String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public java.lang.Number getPriority() {
                    return this.$priority;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                    if (this.getHostHeader() != null) {
                        obj.set("hostHeader", om.valueToTree(this.getHostHeader()));
                    }
                    if (this.getPathPattern() != null) {
                        obj.set("pathPattern", om.valueToTree(this.getPathPattern()));
                    }
                    if (this.getPriority() != null) {
                        obj.set("priority", om.valueToTree(this.getPriority()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Target groups to forward requests to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.jsiiGet("targetGroups", java.util.List.class);
        }

        /**
         * Rule applies if the requested host matches the indicated host.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * 
         * Default: No host condition
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#host-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getHostHeader() {
            return this.jsiiGet("hostHeader", java.lang.String.class);
        }

        /**
         * Rule applies if the requested path matches the given path pattern.
         * 
         * May contain up to three '*' wildcards.
         * 
         * Requires that priority is set.
         * 
         * Default: No path condition
         * 
         * @see https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#path-conditions
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getPathPattern() {
            return this.jsiiGet("pathPattern", java.lang.String.class);
        }

        /**
         * Priority of this target group.
         * 
         * The rule with the lowest priority will be used for every request.
         * If priority is not given, these target groups will be added as
         * defaults, and must not have conditions.
         * 
         * Priorities must be unique.
         * 
         * Default: Target groups are used as defaults
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getPriority() {
            return this.jsiiGet("priority", java.lang.Number.class);
        }
    }
}
