package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for adding a set of certificates to a listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:37:05.141Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerCertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ARNs of certificates to attach.
     * 
     * Duplicates are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<java.lang.String> getCertificateArns();
    /**
     * The listener to attach the rule to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ApplicationListenerCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.util.List<java.lang.String> _certificateArns;
        private software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener _listener;

        /**
         * Sets the value of CertificateArns
         * @param value ARNs of certificates to attach.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCertificateArns(final java.util.List<java.lang.String> value) {
            this._certificateArns = java.util.Objects.requireNonNull(value, "certificateArns is required");
            return this;
        }
        /**
         * Sets the value of Listener
         * @param value The listener to attach the rule to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withListener(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener value) {
            this._listener = java.util.Objects.requireNonNull(value, "listener is required");
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ApplicationListenerCertificateProps build() {
            return new ApplicationListenerCertificateProps() {
                private final java.util.List<java.lang.String> $certificateArns = java.util.Objects.requireNonNull(_certificateArns, "certificateArns is required");
                private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener $listener = java.util.Objects.requireNonNull(_listener, "listener is required");

                @Override
                public java.util.List<java.lang.String> getCertificateArns() {
                    return this.$certificateArns;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
                    return this.$listener;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("certificateArns", om.valueToTree(this.getCertificateArns()));
                    obj.set("listener", om.valueToTree(this.getListener()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerCertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * ARNs of certificates to attach.
         * 
         * Duplicates are not allowed.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.util.List<java.lang.String> getCertificateArns() {
            return this.jsiiGet("certificateArns", java.util.List.class);
        }

        /**
         * The listener to attach the rule to.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.jsiiGet("listener", software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class);
        }
    }
}
