package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Basic properties for a Network Listener.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.3 (build 3624e0f)", date = "2019-07-04T19:37:05.155Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BaseNetworkListenerProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * The port on which the listener listens for requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Number getPort();
    /**
     * Certificate list of ACM cert ARNs.
     * 
     * Default: - No certificates.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> getCertificates();
    /**
     * Default target groups to load balance to.
     * 
     * Default: - None.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups();
    /**
     * Protocol for listener, expects TCP or TLS.
     * 
     * Default: - TLS if certificates are provided. TCP otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol();
    /**
     * SSL Policy.
     * 
     * Default: - Current predefined security policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy();

    /**
     * @return a {@link Builder} of {@link BaseNetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link BaseNetworkListenerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private java.lang.Number _port;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> _certificates;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> _defaultTargetGroups;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.Protocol _protocol;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy _sslPolicy;

        /**
         * Sets the value of Port
         * @param value The port on which the listener listens for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withPort(final java.lang.Number value) {
            this._port = java.util.Objects.requireNonNull(value, "port is required");
            return this;
        }
        /**
         * Sets the value of Certificates
         * @param value Certificate list of ACM cert ARNs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCertificates(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> value) {
            this._certificates = value;
            return this;
        }
        /**
         * Sets the value of DefaultTargetGroups
         * @param value Default target groups to load balance to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDefaultTargetGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> value) {
            this._defaultTargetGroups = value;
            return this;
        }
        /**
         * Sets the value of Protocol
         * @param value Protocol for listener, expects TCP or TLS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withProtocol(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol value) {
            this._protocol = value;
            return this;
        }
        /**
         * Sets the value of SslPolicy
         * @param value SSL Policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSslPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy value) {
            this._sslPolicy = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BaseNetworkListenerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public BaseNetworkListenerProps build() {
            return new BaseNetworkListenerProps() {
                private final java.lang.Number $port = java.util.Objects.requireNonNull(_port, "port is required");
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> $certificates = _certificates;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> $defaultTargetGroups = _defaultTargetGroups;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.Protocol $protocol = _protocol;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy $sslPolicy = _sslPolicy;

                @Override
                public java.lang.Number getPort() {
                    return this.$port;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> getCertificates() {
                    return this.$certificates;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
                    return this.$defaultTargetGroups;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
                    return this.$protocol;
                }

                @Override
                public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
                    return this.$sslPolicy;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("port", om.valueToTree(this.getPort()));
                    if (this.getCertificates() != null) {
                        obj.set("certificates", om.valueToTree(this.getCertificates()));
                    }
                    if (this.getDefaultTargetGroups() != null) {
                        obj.set("defaultTargetGroups", om.valueToTree(this.getDefaultTargetGroups()));
                    }
                    if (this.getProtocol() != null) {
                        obj.set("protocol", om.valueToTree(this.getProtocol()));
                    }
                    if (this.getSslPolicy() != null) {
                        obj.set("sslPolicy", om.valueToTree(this.getSslPolicy()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The port on which the listener listens for requests.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.Number getPort() {
            return this.jsiiGet("port", java.lang.Number.class);
        }

        /**
         * Certificate list of ACM cert ARNs.
         * 
         * Default: - No certificates.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListenerCertificateProps> getCertificates() {
            return this.jsiiGet("certificates", java.util.List.class);
        }

        /**
         * Default target groups to load balance to.
         * 
         * Default: - None.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup> getDefaultTargetGroups() {
            return this.jsiiGet("defaultTargetGroups", java.util.List.class);
        }

        /**
         * Protocol for listener, expects TCP or TLS.
         * 
         * Default: - TLS if certificates are provided. TCP otherwise.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.Protocol getProtocol() {
            return this.jsiiGet("protocol", software.amazon.awscdk.services.elasticloadbalancingv2.Protocol.class);
        }

        /**
         * SSL Policy.
         * 
         * Default: - Current predefined security policy.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy getSslPolicy() {
            return this.jsiiGet("sslPolicy", software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy.class);
        }
    }
}
