/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.elasticloadbalancingv2.AddRuleProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface AddApplicationTargetGroupsProps
extends JsiiSerializable,
AddRuleProps {
    public List<IApplicationTargetGroup> getTargetGroups();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<IApplicationTargetGroup> _targetGroups;
        @Nullable
        private String _hostHeader;
        @Nullable
        private String _pathPattern;
        @Nullable
        private Number _priority;

        public Builder withTargetGroups(List<IApplicationTargetGroup> value) {
            this._targetGroups = Objects.requireNonNull(value, "targetGroups is required");
            return this;
        }

        public Builder withHostHeader(@Nullable String value) {
            this._hostHeader = value;
            return this;
        }

        public Builder withPathPattern(@Nullable String value) {
            this._pathPattern = value;
            return this;
        }

        public Builder withPriority(@Nullable Number value) {
            this._priority = value;
            return this;
        }

        public AddApplicationTargetGroupsProps build() {
            return new AddApplicationTargetGroupsProps(){
                private final List<IApplicationTargetGroup> $targetGroups;
                @Nullable
                private final String $hostHeader;
                @Nullable
                private final String $pathPattern;
                @Nullable
                private final Number $priority;
                {
                    this.$targetGroups = Objects.requireNonNull(_targetGroups, "targetGroups is required");
                    this.$hostHeader = _hostHeader;
                    this.$pathPattern = _pathPattern;
                    this.$priority = _priority;
                }

                @Override
                public List<IApplicationTargetGroup> getTargetGroups() {
                    return this.$targetGroups;
                }

                @Override
                public String getHostHeader() {
                    return this.$hostHeader;
                }

                @Override
                public String getPathPattern() {
                    return this.$pathPattern;
                }

                @Override
                public Number getPriority() {
                    return this.$priority;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("targetGroups", om.valueToTree(this.getTargetGroups()));
                    if (this.getHostHeader() != null) {
                        obj.set("hostHeader", om.valueToTree((Object)this.getHostHeader()));
                    }
                    if (this.getPathPattern() != null) {
                        obj.set("pathPattern", om.valueToTree((Object)this.getPathPattern()));
                    }
                    if (this.getPriority() != null) {
                        obj.set("priority", om.valueToTree((Object)this.getPriority()));
                    }
                    return obj;
                }
            };
        }
    }
}

